/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.multiblock;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import mcjty.lib.varia.DimensionId;
import mcjty.lib.worlddata.AbstractWorldData;
import mcjty.xnet.multiblock.WorldBlob;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class XNetBlobData
extends AbstractWorldData<XNetBlobData> {
    private static final String NAME = "XNetBlobData";
    private final Map<DimensionId, WorldBlob> worldBlobMap = new HashMap<DimensionId, WorldBlob>();

    public XNetBlobData(String name) {
        super(name);
    }

    @Nonnull
    public static XNetBlobData get(World world) {
        return (XNetBlobData)XNetBlobData.getData((World)world, () -> new XNetBlobData(NAME), (String)NAME);
    }

    public WorldBlob getWorldBlob(World world) {
        return this.getWorldBlob(DimensionId.fromWorld((World)world));
    }

    public WorldBlob getWorldBlob(DimensionId type) {
        if (!this.worldBlobMap.containsKey(type)) {
            this.worldBlobMap.put(type, new WorldBlob(type));
        }
        return this.worldBlobMap.get(type);
    }

    public void func_76184_a(CompoundNBT compound) {
        this.worldBlobMap.clear();
        if (compound.func_74764_b("worlds")) {
            ListNBT worlds = (ListNBT)compound.func_74781_a("worlds");
            for (INBT world : worlds) {
                CompoundNBT tc = (CompoundNBT)world;
                String dimtype = tc.func_74779_i("dimtype");
                DimensionId dim = DimensionId.fromResourceLocation((ResourceLocation)new ResourceLocation(dimtype));
                WorldBlob blob = new WorldBlob(dim);
                blob.readFromNBT(tc);
                this.worldBlobMap.put(dim, blob);
            }
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        ListNBT list = new ListNBT();
        for (Map.Entry<DimensionId, WorldBlob> entry : this.worldBlobMap.entrySet()) {
            WorldBlob blob = entry.getValue();
            CompoundNBT tc = new CompoundNBT();
            tc.func_74778_a("dimtype", blob.getDimensionType().getRegistryName().toString());
            blob.writeToNBT(tc);
            list.add((Object)tc);
        }
        compound.func_218657_a("worlds", (INBT)list);
        return compound;
    }
}

