/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.client;

import com.google.common.base.Function;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.client.AbstractDynamicBakedModel;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.cables.blocks.ConnectorBlock;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.cables.client.CablePatterns;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class GenericCableBakedModel
extends AbstractDynamicBakedModel {
    private TextureAtlasSprite spriteCable;
    private static CableTextures[] cableTextures = null;
    private static TextureAtlasSprite spriteSide;

    private static void initTextures() {
        if (cableTextures == null) {
            CableTextures[] tt = new CableTextures[CableColor.VALUES.length];
            for (CableColor color : CableColor.VALUES) {
                int i = color.ordinal();
                tt[i] = new CableTextures();
                tt[i].spriteConnector = GenericCableBakedModel.getTexture((ResourceLocation)new ResourceLocation("xnet", "block/cable" + i + "/connector"));
                tt[i].spriteAdvancedConnector = GenericCableBakedModel.getTexture((ResourceLocation)new ResourceLocation("xnet", "block/cable" + i + "/advanced_connector"));
                tt[i].spriteNormalCable = GenericCableBakedModel.getTexture((ResourceLocation)new ResourceLocation("xnet", "block/cable" + i + "/normal_netcable"));
                tt[i].spriteNoneCable = GenericCableBakedModel.getTexture((ResourceLocation)new ResourceLocation("xnet", "block/cable" + i + "/normal_none_netcable"));
                tt[i].spriteEndCable = GenericCableBakedModel.getTexture((ResourceLocation)new ResourceLocation("xnet", "block/cable" + i + "/normal_end_netcable"));
                tt[i].spriteCornerCable = GenericCableBakedModel.getTexture((ResourceLocation)new ResourceLocation("xnet", "block/cable" + i + "/normal_corner_netcable"));
                tt[i].spriteThreeCable = GenericCableBakedModel.getTexture((ResourceLocation)new ResourceLocation("xnet", "block/cable" + i + "/normal_three_netcable"));
                tt[i].spriteCrossCable = GenericCableBakedModel.getTexture((ResourceLocation)new ResourceLocation("xnet", "block/cable" + i + "/normal_cross_netcable"));
            }
            spriteSide = GenericCableBakedModel.getTexture((ResourceLocation)new ResourceLocation("xnet", "block/connector_side"));
            cableTextures = tt;
        }
    }

    private static TextureAtlasSprite getSpriteNormal(CablePatterns.SpriteIdx idx, int index) {
        GenericCableBakedModel.initTextures();
        CableTextures cableTexture = cableTextures[index];
        switch (idx) {
            case SPRITE_NONE: {
                return cableTexture.spriteNoneCable;
            }
            case SPRITE_END: {
                return cableTexture.spriteEndCable;
            }
            case SPRITE_STRAIGHT: {
                return cableTexture.spriteNormalCable;
            }
            case SPRITE_CORNER: {
                return cableTexture.spriteCornerCable;
            }
            case SPRITE_THREE: {
                return cableTexture.spriteThreeCable;
            }
            case SPRITE_CROSS: {
                return cableTexture.spriteCrossCable;
            }
        }
        return cableTexture.spriteNoneCable;
    }

    private BakedQuad createQuad(Vector3d v1, Vector3d v2, Vector3d v3, Vector3d v4, TextureAtlasSprite sprite, int rotation, float hilight) {
        switch (rotation) {
            case 0: {
                return this.createQuad(v1, v2, v3, v4, sprite, hilight);
            }
            case 1: {
                return this.createQuad(v2, v3, v4, v1, sprite, hilight);
            }
            case 2: {
                return this.createQuad(v3, v4, v1, v2, sprite, hilight);
            }
            case 3: {
                return this.createQuad(v4, v1, v2, v3, sprite, hilight);
            }
        }
        return this.createQuad(v1, v2, v3, v4, sprite, hilight);
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState facadeId;
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        RenderType layer = MinecraftForgeClient.getRenderLayer();
        if (side == null && (layer == null || layer.equals((Object)RenderType.func_228639_c_()))) {
            CablePatterns.QuadSetting pattern;
            ConnectorType north = (ConnectorType)((Object)state.func_177229_b(GenericCableBlock.NORTH));
            ConnectorType south = (ConnectorType)((Object)state.func_177229_b(GenericCableBlock.SOUTH));
            ConnectorType west = (ConnectorType)((Object)state.func_177229_b(GenericCableBlock.WEST));
            ConnectorType east = (ConnectorType)((Object)state.func_177229_b(GenericCableBlock.EAST));
            ConnectorType up = (ConnectorType)((Object)state.func_177229_b(GenericCableBlock.UP));
            ConnectorType down = (ConnectorType)((Object)state.func_177229_b(GenericCableBlock.DOWN));
            CableColor cableColor = (CableColor)((Object)state.func_177229_b(GenericCableBlock.COLOR));
            int index = cableColor.ordinal();
            GenericCableBakedModel.initTextures();
            CableTextures ct = cableTextures[index];
            this.spriteCable = ct.spriteNormalCable;
            GenericCableBlock block = (GenericCableBlock)state.func_177230_c();
            TextureAtlasSprite spriteConnector = block.isAdvancedConnector() ? ct.spriteAdvancedConnector : ct.spriteConnector;
            Function getSprite = idx -> GenericCableBakedModel.getSpriteNormal(idx, index);
            float hilight = 1.0f;
            if (block instanceof ConnectorBlock && north != ConnectorType.BLOCK && south != ConnectorType.BLOCK && west != ConnectorType.BLOCK && east != ConnectorType.BLOCK && up != ConnectorType.BLOCK && down != ConnectorType.BLOCK) {
                hilight = 0.5f;
            }
            double o = 0.4;
            double p = 0.1;
            double q = 0.2;
            if (up == ConnectorType.CABLE) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)1.0, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)1.0, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)1.0, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)1.0, (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)1.0, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)1.0, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)1.0, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)1.0, (double)(1.0 - o)), this.spriteCable, hilight));
            } else if (up == ConnectorType.BLOCK) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - p), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - p), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - p), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - p), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - p), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - p), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - p), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - p), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - p), (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)1.0, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)1.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - p), (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - p), (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)1.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)1.0, (double)q), GenericCableBakedModel.v((double)q, (double)(1.0 - p), (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)1.0, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)1.0, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - p), (double)q), GenericCableBakedModel.v((double)q, (double)(1.0 - p), (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - p), (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - p), (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)1.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)1.0, (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - p), (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - p), (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - p), (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)(1.0 - p), (double)(1.0 - q)), spriteConnector, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)1.0, (double)q), GenericCableBakedModel.v((double)q, (double)1.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)1.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)1.0, (double)q), spriteSide, hilight));
            } else {
                pattern = CablePatterns.findPattern(west, south, east, north);
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
            }
            if (down == ConnectorType.CABLE) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)0.0, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)0.0, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)0.0, (double)o), GenericCableBakedModel.v((double)o, (double)0.0, (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)0.0, (double)o), GenericCableBakedModel.v((double)o, (double)0.0, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)0.0, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)0.0, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
            } else if (down == ConnectorType.BLOCK) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)p, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)p, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)p, (double)o), GenericCableBakedModel.v((double)o, (double)p, (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)p, (double)o), GenericCableBakedModel.v((double)o, (double)p, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)p, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)p, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - q), (double)0.0, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)p, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)p, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)0.0, (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)0.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)p, (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)p, (double)q), GenericCableBakedModel.v((double)q, (double)0.0, (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)p, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)p, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)0.0, (double)q), GenericCableBakedModel.v((double)q, (double)0.0, (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)0.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)0.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)p, (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)p, (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)p, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)p, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - q), (double)p, (double)q), GenericCableBakedModel.v((double)q, (double)p, (double)q), spriteConnector, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)0.0, (double)(1.0 - q)), GenericCableBakedModel.v((double)q, (double)0.0, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)0.0, (double)q), GenericCableBakedModel.v((double)(1.0 - q), (double)0.0, (double)(1.0 - q)), spriteSide, hilight));
            } else {
                pattern = CablePatterns.findPattern(west, north, east, south);
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
            }
            if (east == ConnectorType.CABLE) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)1.0, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)1.0, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)1.0, (double)o, (double)o), GenericCableBakedModel.v((double)1.0, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)1.0, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)1.0, (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)1.0, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)1.0, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
            } else if (east == ConnectorType.BLOCK) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - p), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - p), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)1.0, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)1.0, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - q), (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)q, (double)q), GenericCableBakedModel.v((double)1.0, (double)q, (double)q), GenericCableBakedModel.v((double)1.0, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - p), (double)q, (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)1.0, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)1.0, (double)q, (double)q), GenericCableBakedModel.v((double)(1.0 - p), (double)q, (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)1.0, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)1.0, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - q), (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - p), (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)(1.0 - p), (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)(1.0 - p), (double)q, (double)q), spriteConnector, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)1.0, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)1.0, (double)q, (double)q), GenericCableBakedModel.v((double)1.0, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)1.0, (double)(1.0 - q), (double)(1.0 - q)), spriteSide, hilight));
            } else {
                pattern = CablePatterns.findPattern(down, north, up, south);
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
            }
            if (west == ConnectorType.CABLE) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)0.0, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)0.0, (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)0.0, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)0.0, (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)0.0, (double)o, (double)o), GenericCableBakedModel.v((double)0.0, (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)0.0, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)0.0, (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
            } else if (west == ConnectorType.BLOCK) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)p, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)p, (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)p, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)p, (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)p, (double)o, (double)o), GenericCableBakedModel.v((double)p, (double)(1.0 - o), (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)p, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)p, (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)0.0, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)p, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)p, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)0.0, (double)(1.0 - q), (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)0.0, (double)q, (double)q), GenericCableBakedModel.v((double)p, (double)q, (double)q), GenericCableBakedModel.v((double)p, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)0.0, (double)q, (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)0.0, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)p, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)p, (double)q, (double)q), GenericCableBakedModel.v((double)0.0, (double)q, (double)q), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)0.0, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)p, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)p, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)0.0, (double)(1.0 - q), (double)(1.0 - q)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)p, (double)q, (double)q), GenericCableBakedModel.v((double)p, (double)(1.0 - q), (double)q), GenericCableBakedModel.v((double)p, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)p, (double)q, (double)(1.0 - q)), spriteConnector, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)0.0, (double)q, (double)q), GenericCableBakedModel.v((double)0.0, (double)q, (double)(1.0 - q)), GenericCableBakedModel.v((double)0.0, (double)(1.0 - q), (double)(1.0 - q)), GenericCableBakedModel.v((double)0.0, (double)(1.0 - q), (double)q), spriteSide, hilight));
            } else {
                pattern = CablePatterns.findPattern(down, south, up, north);
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)o), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
            }
            if (north == ConnectorType.CABLE) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)0.0), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)0.0), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)0.0), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)0.0), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)0.0), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)0.0), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)0.0), GenericCableBakedModel.v((double)o, (double)o, (double)0.0), this.spriteCable, hilight));
            } else if (north == ConnectorType.BLOCK) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)p), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)p), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)p), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)p), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)p), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)p), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)p), GenericCableBakedModel.v((double)o, (double)o, (double)p), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)p), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)p), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)0.0), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)0.0), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)q, (double)0.0), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)0.0), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)p), GenericCableBakedModel.v((double)q, (double)q, (double)p), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)0.0), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)0.0), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)p), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)p), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)q, (double)p), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)p), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)0.0), GenericCableBakedModel.v((double)q, (double)q, (double)0.0), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)q, (double)p), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)p), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)p), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)p), spriteConnector, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)q, (double)0.0), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)0.0), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)0.0), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)0.0), spriteSide, hilight));
            } else {
                pattern = CablePatterns.findPattern(west, up, east, down);
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)o), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)o), GenericCableBakedModel.v((double)o, (double)o, (double)o), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
            }
            if (south == ConnectorType.CABLE) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)1.0), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)1.0), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)1.0), GenericCableBakedModel.v((double)o, (double)o, (double)1.0), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)1.0), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)1.0), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)1.0), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)1.0), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
            } else if (south == ConnectorType.BLOCK) {
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - p)), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - p)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - p)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - p)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - p)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), this.spriteCable, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)1.0), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)1.0), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)(1.0 - p)), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)(1.0 - p)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)q, (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)1.0), GenericCableBakedModel.v((double)q, (double)q, (double)1.0), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)1.0), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)1.0), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)q, (double)1.0), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)1.0), GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)(1.0 - p)), GenericCableBakedModel.v((double)q, (double)q, (double)(1.0 - p)), spriteSide, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)(1.0 - p)), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)(1.0 - p)), GenericCableBakedModel.v((double)q, (double)q, (double)(1.0 - p)), spriteConnector, hilight));
                quads.add(this.createQuad(GenericCableBakedModel.v((double)q, (double)(1.0 - q), (double)1.0), GenericCableBakedModel.v((double)q, (double)q, (double)1.0), GenericCableBakedModel.v((double)(1.0 - q), (double)q, (double)1.0), GenericCableBakedModel.v((double)(1.0 - q), (double)(1.0 - q), (double)1.0), spriteSide, hilight));
            } else {
                pattern = CablePatterns.findPattern(west, down, east, up);
                quads.add(this.createQuad(GenericCableBakedModel.v((double)o, (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)o, (double)(1.0 - o)), GenericCableBakedModel.v((double)(1.0 - o), (double)(1.0 - o), (double)(1.0 - o)), GenericCableBakedModel.v((double)o, (double)(1.0 - o), (double)(1.0 - o)), (TextureAtlasSprite)getSprite.apply((Object)pattern.getSprite()), pattern.getRotation(), hilight));
            }
        }
        if ((facadeId = (BlockState)extraData.getData(GenericCableBlock.FACADEID)) != null) {
            BlockState facadeState = facadeId.getBlockState();
            if (layer == null || RenderTypeLookup.canRenderInLayer((BlockState)facadeState, (RenderType)layer)) {
                IBakedModel model = Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178125_b(facadeState);
                try {
                    quads.addAll(model.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return quads;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.spriteCable == null ? GenericCableBakedModel.getTexture((ResourceLocation)new ResourceLocation("minecraft", "missingno")) : this.spriteCable;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }

    static {
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, false, false, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_NONE, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, false, false, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_END, 3));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, true, false, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_END, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, false, true, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_END, 1));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, false, false, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_END, 2));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, true, false, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CORNER, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, true, true, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CORNER, 1));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, false, true, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CORNER, 2));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, false, false, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CORNER, 3));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, true, false, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_STRAIGHT, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, false, true, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_STRAIGHT, 1));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, true, true, false), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_THREE, 0));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(false, true, true, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_THREE, 1));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, false, true, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_THREE, 2));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, true, false, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_THREE, 3));
        CablePatterns.PATTERNS.put(new CablePatterns.Pattern(true, true, true, true), new CablePatterns.QuadSetting(CablePatterns.SpriteIdx.SPRITE_CROSS, 0));
    }

    public static class CableTextures {
        private TextureAtlasSprite spriteConnector;
        private TextureAtlasSprite spriteAdvancedConnector;
        private TextureAtlasSprite spriteNoneCable;
        private TextureAtlasSprite spriteNormalCable;
        private TextureAtlasSprite spriteEndCable;
        private TextureAtlasSprite spriteCornerCable;
        private TextureAtlasSprite spriteThreeCable;
        private TextureAtlasSprite spriteCrossCable;
    }
}

