/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.modules.cables.blocks;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.builder.InfoLine;
import mcjty.lib.builder.TooltipBuilder;
import mcjty.lib.container.ContainerFactory;
import mcjty.lib.container.GenericContainer;
import mcjty.lib.gui.ManualEntry;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.tooltips.ITooltipSettings;
import mcjty.lib.varia.EnergyTools;
import mcjty.rftoolsbase.api.xnet.channels.IConnectable;
import mcjty.rftoolsbase.api.xnet.keys.ConsumerId;
import mcjty.rftoolsbase.tools.ManualHelper;
import mcjty.xnet.XNet;
import mcjty.xnet.modules.cables.CableColor;
import mcjty.xnet.modules.cables.CableModule;
import mcjty.xnet.modules.cables.ConnectorType;
import mcjty.xnet.modules.cables.blocks.ConnectorTileEntity;
import mcjty.xnet.modules.cables.blocks.GenericCableBlock;
import mcjty.xnet.modules.cables.blocks.NetCableBlock;
import mcjty.xnet.modules.controller.blocks.TileEntityController;
import mcjty.xnet.modules.facade.FacadeModule;
import mcjty.xnet.modules.facade.blocks.FacadeBlockItem;
import mcjty.xnet.modules.router.blocks.TileEntityRouter;
import mcjty.xnet.modules.various.blocks.RedstoneProxyBlock;
import mcjty.xnet.modules.wireless.blocks.TileEntityWirelessRouter;
import mcjty.xnet.multiblock.ColorId;
import mcjty.xnet.multiblock.WorldBlob;
import mcjty.xnet.multiblock.XNetBlobData;
import mcjty.xnet.setup.Config;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.FluidState;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameters;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;

public class ConnectorBlock
extends GenericCableBlock
implements ITooltipSettings {
    public static final ManualEntry MANUAL = ManualHelper.create((String)"xnet:simple/connector");
    private final Lazy<TooltipBuilder> tooltipBuilder = () -> new TooltipBuilder().info(new InfoLine[]{TooltipBuilder.key((String)"message.xnet.shiftmessage")}).infoShift(new InfoLine[]{TooltipBuilder.header(), TooltipBuilder.gold(stack -> this.isAdvancedConnector()), TooltipBuilder.parameter((String)"info", stack -> Integer.toString(this.isAdvancedConnector() ? ((Integer)Config.maxRfAdvancedConnector.get()).intValue() : ((Integer)Config.maxRfConnector.get()).intValue()))});

    public ConnectorBlock(GenericCableBlock.CableBlockType type) {
        super(Material.field_151573_f, type);
    }

    public ManualEntry getManualEntry() {
        return MANUAL;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new ConnectorTileEntity();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, final BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        TileEntity te;
        if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof GenericTileEntity) {
            final GenericTileEntity genericTileEntity = (GenericTileEntity)te;
            NetworkHooks.openGui((ServerPlayerEntity)((ServerPlayerEntity)player), (INamedContainerProvider)new INamedContainerProvider(){

                public ITextComponent func_145748_c_() {
                    return new StringTextComponent("Connector");
                }

                @Nullable
                public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
                    return new GenericContainer((ContainerType)CableModule.CONTAINER_CONNECTOR.get(), id, (ContainerFactory)ContainerFactory.EMPTY.get(), pos, genericTileEntity);
                }
            }, (BlockPos)pos);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_180657_a(World worldIn, PlayerEntity player, BlockPos pos, BlockState state, @Nullable TileEntity te, ItemStack stack) {
        ConnectorTileEntity connectorTileEntity;
        if (te instanceof ConnectorTileEntity && (connectorTileEntity = (ConnectorTileEntity)te).getMimicBlock() != null) {
            ItemStack item = new ItemStack((IItemProvider)FacadeModule.FACADE.get());
            FacadeBlockItem.setMimicBlock(item, connectorTileEntity.getMimicBlock());
            connectorTileEntity.setMimicBlock(null);
            ConnectorBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item);
            return;
        }
        super.func_180657_a(worldIn, player, pos, state, te, stack);
    }

    public boolean removedByPlayer(BlockState state, World world, BlockPos pos, PlayerEntity player, boolean willHarvest, FluidState fluid) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ConnectorTileEntity) {
            ConnectorTileEntity connectorTileEntity = (ConnectorTileEntity)te;
            if (connectorTileEntity.getMimicBlock() == null) {
                this.func_176208_a(world, pos, state, player);
                return world.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), world.field_72995_K ? 11 : 3);
            }
            this.func_176208_a(world, pos, state, player);
            if (player.field_71075_bZ.field_75098_d) {
                connectorTileEntity.setMimicBlock(null);
            }
        } else {
            return super.removedByPlayer(state, world, pos, player, willHarvest, fluid);
        }
        return true;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        this.checkRedstone(world, pos);
        super.func_220069_a(state, world, pos, blockIn, fromPos, isMoving);
    }

    public void onNeighborChange(BlockState state, IWorldReader blockAccess, BlockPos pos, BlockPos neighbor) {
        if (blockAccess instanceof World) {
            TileEntity te;
            World world = (World)blockAccess;
            if (!world.field_72995_K && (te = world.func_175625_s(pos)) instanceof ConnectorTileEntity) {
                ConnectorTileEntity connector = (ConnectorTileEntity)te;
                connector.possiblyMarkNetworkDirty(neighbor);
            }
        }
        super.onNeighborChange(state, blockAccess, pos, neighbor);
    }

    public boolean shouldCheckWeakPower(BlockState state, IWorldReader world, BlockPos pos, Direction side) {
        return false;
    }

    private void checkRedstone(World world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ConnectorTileEntity) {
            int powered = world.func_175687_A(pos);
            ConnectorTileEntity genericTileEntity = (ConnectorTileEntity)te;
            genericTileEntity.setPowerInput(powered);
        }
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    public int func_180656_a(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.getRedstoneOutput(state, world, pos, side);
    }

    public int func_176211_b(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return this.getRedstoneOutput(state, world, pos, side);
    }

    protected int getRedstoneOutput(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        TileEntity te = world.func_175625_s(pos);
        if (state.func_177230_c() instanceof ConnectorBlock && te instanceof ConnectorTileEntity) {
            ConnectorTileEntity connector = (ConnectorTileEntity)te;
            return connector.getPowerOut(side.func_176734_d());
        }
        return 0;
    }

    @Override
    protected ConnectorType getConnectorType(@Nonnull CableColor color, IBlockReader world, BlockPos connectorPos, Direction facing) {
        BlockPos pos = connectorPos.func_177972_a(facing);
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if ((block instanceof NetCableBlock || block instanceof ConnectorBlock) && state.func_177229_b((Property)COLOR) == color) {
            return ConnectorType.CABLE;
        }
        if (ConnectorBlock.isConnectable(world, connectorPos, facing) && color != CableColor.ROUTING) {
            return ConnectorType.BLOCK;
        }
        if (ConnectorBlock.isConnectableRouting(world, pos) && color == CableColor.ROUTING) {
            return ConnectorType.BLOCK;
        }
        return ConnectorType.NONE;
    }

    public static boolean isConnectableRouting(IBlockReader world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te == null) {
            return false;
        }
        return te instanceof TileEntityRouter || te instanceof TileEntityWirelessRouter;
    }

    public static boolean isConnectable(IBlockReader world, BlockPos connectorPos, Direction facing) {
        BlockPos pos = connectorPos.func_177972_a(facing);
        BlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block.isAir(state, world, pos)) {
            return false;
        }
        TileEntity tileEntity = world.func_175625_s(connectorPos);
        if (!(tileEntity instanceof ConnectorTileEntity)) {
            return false;
        }
        ConnectorTileEntity connectorTE = (ConnectorTileEntity)tileEntity;
        if (!connectorTE.isEnabled(facing)) {
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (block instanceof IConnectable) {
            IConnectable.ConnectResult result = ((IConnectable)block).canConnect(world, connectorPos, pos, te, facing);
            if (result == IConnectable.ConnectResult.NO) {
                return false;
            }
            if (result == IConnectable.ConnectResult.YES) {
                return true;
            }
        }
        for (IConnectable connectable : XNet.xNetApi.getConnectables()) {
            IConnectable.ConnectResult result = connectable.canConnect(world, connectorPos, pos, te, facing);
            if (result == IConnectable.ConnectResult.NO) {
                return false;
            }
            if (result != IConnectable.ConnectResult.YES) continue;
            return true;
        }
        if (block instanceof ConnectorBlock) {
            return false;
        }
        if (block instanceof RedstoneProxyBlock || block == Blocks.field_150379_bu || block == Blocks.field_150331_J || block == Blocks.field_150320_F) {
            return true;
        }
        if (block.canConnectRedstone(state, world, pos, null) || state.func_185897_m()) {
            return true;
        }
        if (te == null) {
            return false;
        }
        if (EnergyTools.isEnergyTE((TileEntity)te, null)) {
            return true;
        }
        if (te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).isPresent()) {
            return true;
        }
        if (te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY).isPresent()) {
            return true;
        }
        if (te instanceof TileEntityController) {
            return true;
        }
        return te instanceof TileEntityRouter;
    }

    @Override
    public List<ItemStack> func_220076_a(BlockState state, LootContext.Builder builder) {
        List<ItemStack> drops = super.func_220076_a(state, builder);
        ServerWorld world = builder.func_216018_a();
        for (ItemStack drop : drops) {
            WorldBlob worldBlob = XNetBlobData.get((World)world).getWorldBlob((World)world);
            ConsumerId consumer = worldBlob.getConsumerAt(new BlockPos((Vector3d)builder.func_216019_b(LootParameters.field_237457_g_)));
            if (consumer == null) continue;
            drop.func_196082_o().func_74768_a("consumerId", consumer.getId());
        }
        return drops;
    }

    public void func_190948_a(ItemStack stack, @Nullable IBlockReader worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        ((TooltipBuilder)this.tooltipBuilder.get()).makeTooltip(this.getRegistryName(), stack, tooltip, flagIn);
    }

    @Override
    public void createCableSegment(World world, BlockPos pos, ItemStack stack) {
        ConsumerId consumer;
        if (!stack.func_190926_b() && stack.func_77942_o() && stack.func_77978_p().func_74764_b("consumerId")) {
            consumer = new ConsumerId(stack.func_77978_p().func_74762_e("consumerId"));
        } else {
            XNetBlobData blobData = XNetBlobData.get(world);
            WorldBlob worldBlob = blobData.getWorldBlob(world);
            consumer = worldBlob.newConsumer();
        }
        this.createCableSegment(world, pos, consumer);
    }

    public void createCableSegment(World world, BlockPos pos, ConsumerId consumer) {
        XNetBlobData blobData = XNetBlobData.get(world);
        WorldBlob worldBlob = blobData.getWorldBlob(world);
        CableColor color = (CableColor)((Object)world.func_180495_p(pos).func_177229_b((Property)COLOR));
        worldBlob.createNetworkConsumer(pos, new ColorId(color.ordinal() + 1), consumer);
        blobData.save();
    }

    public static boolean isAdvancedConnector(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos).func_177230_c();
        if (block instanceof GenericCableBlock) {
            return ((GenericCableBlock)block).isAdvancedConnector();
        }
        return false;
    }

    @Override
    public boolean isAdvancedConnector() {
        return false;
    }
}

