/*
 * Decompiled with CFR 0.152.
 */
package mcjty.xnet.apiimpl.logic;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.FluidTools;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.xnet.apiimpl.energy.EnergyChannelSettings;
import mcjty.xnet.apiimpl.fluids.FluidChannelSettings;
import mcjty.xnet.apiimpl.items.ItemChannelSettings;
import mcjty.xnet.apiimpl.logic.LogicConnectorSettings;
import mcjty.xnet.compat.RFToolsSupport;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;

public class Sensor {
    public static final String TAG_MODE = "mode";
    public static final String TAG_OPERATOR = "op";
    public static final String TAG_AMOUNT = "amount";
    public static final String TAG_COLOR = "scolor";
    public static final String TAG_STACK = "stack";
    private final int index;
    private SensorMode sensorMode = SensorMode.OFF;
    private Operator operator = Operator.EQUAL;
    private int amount = 0;
    private Color outputColor = Color.OFF;
    private ItemStack filter = ItemStack.field_190927_a;

    public Sensor(int index) {
        this.index = index;
    }

    public SensorMode getSensorMode() {
        return this.sensorMode;
    }

    public void setSensorMode(SensorMode sensorMode) {
        this.sensorMode = sensorMode;
    }

    public Operator getOperator() {
        return this.operator;
    }

    public void setOperator(Operator operator) {
        this.operator = operator;
    }

    public ItemStack getFilter() {
        return this.filter;
    }

    public void setFilter(ItemStack filter) {
        this.filter = filter;
    }

    public int getAmount() {
        return this.amount;
    }

    public void setAmount(int amount) {
        this.amount = amount;
    }

    public Color getOutputColor() {
        return this.outputColor;
    }

    public void setOutputColor(Color outputColor) {
        this.outputColor = outputColor;
    }

    public boolean isEnabled(String tag) {
        if ((TAG_MODE + this.index).equals(tag)) {
            return true;
        }
        if ((TAG_OPERATOR + this.index).equals(tag)) {
            return true;
        }
        if ((TAG_AMOUNT + this.index).equals(tag)) {
            return true;
        }
        if ((TAG_COLOR + this.index).equals(tag)) {
            return true;
        }
        if ((TAG_STACK + this.index).equals(tag)) {
            return this.sensorMode == SensorMode.FLUID || this.sensorMode == SensorMode.ITEM;
        }
        return false;
    }

    public void createGui(IEditorGui gui) {
        gui.choices(TAG_MODE + this.index, "Sensor mode", (Enum)this.sensorMode, (Enum[])SensorMode.values()).choices(TAG_OPERATOR + this.index, "Operator", (Enum)this.operator, (Enum[])Operator.values()).integer(TAG_AMOUNT + this.index, "Amount to compare with", Integer.valueOf(this.amount), 46).colors(TAG_COLOR + this.index, "Output color", Integer.valueOf(this.outputColor.getColor()), Color.COLORS).ghostSlot(TAG_STACK + this.index, this.filter).nl();
    }

    public boolean test(@Nullable TileEntity te, @Nonnull World world, @Nonnull BlockPos pos, LogicConnectorSettings settings) {
        switch (this.sensorMode) {
            case ITEM: {
                if (RFToolsSupport.isStorageScanner(te)) {
                    int cnt = RFToolsSupport.countItems(te, this.filter, this.amount + 1);
                    return this.operator.match(cnt, this.amount);
                }
                return ItemChannelSettings.getItemHandlerAt(te, settings.getFacing()).map(h -> {
                    int cnt = this.countItem((IItemHandler)h, this.filter, this.amount + 1);
                    return this.operator.match(cnt, this.amount);
                }).orElse(false);
            }
            case FLUID: {
                return FluidChannelSettings.getFluidHandlerAt(te, settings.getFacing()).map(h -> {
                    int cnt = this.countFluid((IFluidHandler)h, this.filter, this.amount + 1);
                    return this.operator.match(cnt, this.amount);
                }).orElse(false);
            }
            case ENERGY: {
                if (!EnergyChannelSettings.isEnergyTE(te, settings.getFacing())) break;
                int cnt = EnergyChannelSettings.getEnergyLevel(te, settings.getFacing());
                return this.operator.match(cnt, this.amount);
            }
            case RS: {
                int cnt = world.func_175651_c(pos, settings.getFacing());
                return this.operator.match(cnt, this.amount);
            }
        }
        return false;
    }

    private int safeInt(Object o) {
        if (o instanceof Integer) {
            return (Integer)o;
        }
        return 0;
    }

    public void update(Map<String, Object> data) {
        Object sm = data.get(TAG_MODE + this.index);
        this.sensorMode = sm != null ? SensorMode.valueOf(((String)sm).toUpperCase()) : SensorMode.OFF;
        Object op = data.get(TAG_OPERATOR + this.index);
        this.operator = op != null ? Operator.valueOfCode(((String)op).toUpperCase()) : Operator.EQUAL;
        this.amount = this.safeInt(data.get(TAG_AMOUNT + this.index));
        Object co = data.get(TAG_COLOR + this.index);
        this.outputColor = co != null ? Color.colorByValue((int)((Integer)co)) : Color.OFF;
        this.filter = (ItemStack)data.get(TAG_STACK + this.index);
        if (this.filter == null) {
            this.filter = ItemStack.field_190927_a;
        }
    }

    public void readFromNBT(CompoundNBT tag) {
        this.sensorMode = SensorMode.values()[tag.func_74771_c("sensorMode" + this.index)];
        this.operator = Operator.values()[tag.func_74771_c("operator" + this.index)];
        this.amount = tag.func_74762_e(TAG_AMOUNT + this.index);
        this.outputColor = Color.values()[tag.func_74771_c(TAG_COLOR + this.index)];
        if (tag.func_74764_b("filter" + this.index)) {
            CompoundNBT itemTag = tag.func_74775_l("filter" + this.index);
            this.filter = ItemStack.func_199557_a((CompoundNBT)itemTag);
        } else {
            this.filter = ItemStack.field_190927_a;
        }
    }

    public void writeToNBT(CompoundNBT tag) {
        tag.func_74774_a("sensorMode" + this.index, (byte)this.sensorMode.ordinal());
        tag.func_74774_a("operator" + this.index, (byte)this.operator.ordinal());
        tag.func_74768_a(TAG_AMOUNT + this.index, this.amount);
        tag.func_74774_a(TAG_COLOR + this.index, (byte)this.outputColor.ordinal());
        if (!this.filter.func_190926_b()) {
            CompoundNBT itemTag = new CompoundNBT();
            this.filter.func_77955_b(itemTag);
            tag.func_218657_a("filter" + this.index, (INBT)itemTag);
        }
    }

    private int countItem(@Nonnull IItemHandler handler, ItemStack matcher, int maxNeeded) {
        int cnt = 0;
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.func_190926_b() || !(!matcher.func_190926_b() ? matcher.func_77969_a(stack) && (cnt += stack.func_190916_E()) >= maxNeeded : (cnt += stack.func_190916_E()) >= maxNeeded)) continue;
            return cnt;
        }
        return cnt;
    }

    private int countFluid(@Nonnull IFluidHandler handler, ItemStack matcher, int maxNeeded) {
        FluidStack fluidStack = !matcher.func_190926_b() ? FluidTools.convertBucketToFluid((ItemStack)matcher) : null;
        int cnt = 0;
        for (int i = 0; i < handler.getTanks(); ++i) {
            FluidStack contents = handler.getFluidInTank(i);
            if (contents.isEmpty() || !(fluidStack != null ? fluidStack.isFluidEqual(contents) && (cnt += contents.getAmount()) >= maxNeeded : (cnt += contents.getAmount()) >= maxNeeded)) continue;
            return cnt;
        }
        return cnt;
    }

    public static enum Operator {
        EQUAL("=", (i1, i2) -> i1 == i2),
        NOTEQUAL("!=", (i1, i2) -> i1 != i2),
        LESS("<", (i1, i2) -> i1 < i2),
        GREATER(">", (i1, i2) -> i1 > i2),
        LESSOREQUAL("<=", (i1, i2) -> i1 <= i2),
        GREATOROREQUAL(">=", (i1, i2) -> i1 >= i2);

        private final String code;
        private final BiPredicate<Integer, Integer> matcher;
        private static final Map<String, Operator> OPERATOR_MAP;

        private Operator(String code, BiPredicate<Integer, Integer> matcher) {
            this.code = code;
            this.matcher = matcher;
        }

        public String getCode() {
            return this.code;
        }

        public boolean match(int i1, int i2) {
            return this.matcher.test(i1, i2);
        }

        public String toString() {
            return this.code;
        }

        public static Operator valueOfCode(String code) {
            return OPERATOR_MAP.get(code);
        }

        static {
            OPERATOR_MAP = new HashMap<String, Operator>();
            for (Operator operator : Operator.values()) {
                OPERATOR_MAP.put(operator.code, operator);
            }
        }
    }

    public static enum SensorMode {
        OFF,
        ITEM,
        FLUID,
        ENERGY,
        RS;

    }
}

