/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.registry.provider.statement;

import com.valkyrieofnight.vlib.core.util.logic.operators.RelationalOperator;
import com.valkyrieofnight.vlib.registry.conditiondata.ConditionContainerProvider;
import com.valkyrieofnight.vlib.registry.provider.Provider;
import com.valkyrieofnight.vlib.registry.provider.deserializers.DeserializerUtils;
import com.valkyrieofnight.vlib.registry.provider.deserializers.ProviderDeserializerRegistry;
import com.valkyrieofnight.vlib.registry.provider.deserializers.statement.IfElseProviderDeserializers;
import com.valkyrieofnight.vlib.registry.provider.statement.Comparator;
import net.minecraft.block.Block;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tags.Tag;

public class IfElseProvider<RETURN_VALUE, TEST_VALUE>
extends Provider<RETURN_VALUE> {
    protected Provider<TEST_VALUE> left;
    protected RelationalOperator testType;
    protected Provider<TEST_VALUE> right;
    protected Comparator<TEST_VALUE> comparator;
    protected Provider<RETURN_VALUE> trueValue;
    protected Provider<RETURN_VALUE> falseValue;

    public IfElseProvider(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<RETURN_VALUE> trueValue, Provider<RETURN_VALUE> falseValue) {
        this.comparator = comparator;
        this.left = left;
        this.right = right;
        this.testType = testType;
        this.trueValue = trueValue;
        this.falseValue = falseValue;
    }

    @Override
    public RETURN_VALUE request(ConditionContainerProvider dataContainer) {
        if (this.comparator.compare(this.left.request(dataContainer), this.testType, this.right.request(dataContainer))) {
            return this.trueValue.request(dataContainer);
        }
        return this.falseValue.request(dataContainer);
    }

    @Override
    public void writePacketData(PacketBuffer buffer) {
        ProviderDeserializerRegistry PDR = ProviderDeserializerRegistry.getInstance();
        this.left.writePacketData(buffer);
        buffer.func_179249_a((Enum)this.testType);
        this.right.writePacketData(buffer);
        buffer.func_180714_a(this.comparator.getID());
        this.trueValue.writePacketData(buffer);
        this.falseValue.writePacketData(buffer);
    }

    @Override
    public void readPacketData(PacketBuffer buffer) {
        ProviderDeserializerRegistry PDR = ProviderDeserializerRegistry.getInstance();
        this.left = DeserializerUtils.readProviderFromPacket(buffer);
        this.testType = (RelationalOperator)buffer.func_179257_a(RelationalOperator.class);
        this.right = DeserializerUtils.readProviderFromPacket(buffer);
        this.comparator = Comparator.getFromID(buffer.func_218666_n());
        this.trueValue = DeserializerUtils.readProviderFromPacket(buffer);
        this.falseValue = DeserializerUtils.readProviderFromPacket(buffer);
    }

    @Override
    public boolean isValid() {
        return !this.left.isValid() && this.right.isValid() && this.trueValue.isValid() && this.falseValue.isValid();
    }

    public static class FluidTag<TEST_VALUE>
    extends IfElseProvider<Tag<net.minecraft.fluid.Fluid>, TEST_VALUE> {
        public FluidTag(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<Tag<net.minecraft.fluid.Fluid>> trueValue, Provider<Tag<net.minecraft.fluid.Fluid>> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.FLUID_TAG.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class BlockTag<TEST_VALUE>
    extends IfElseProvider<Tag<Block>, TEST_VALUE> {
        public BlockTag(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<Tag<Block>> trueValue, Provider<Tag<Block>> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.BLOCK_TAG.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class ItemTag<TEST_VALUE>
    extends IfElseProvider<Tag<net.minecraft.item.Item>, TEST_VALUE> {
        public ItemTag(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<Tag<net.minecraft.item.Item>> trueValue, Provider<Tag<net.minecraft.item.Item>> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.ITEM_TAG.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class CompoundNBT<TEST_VALUE>
    extends IfElseProvider<net.minecraft.nbt.CompoundNBT, TEST_VALUE> {
        public CompoundNBT(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<net.minecraft.nbt.CompoundNBT> trueValue, Provider<net.minecraft.nbt.CompoundNBT> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.NBT.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class Fluid<TEST_VALUE>
    extends IfElseProvider<net.minecraft.fluid.Fluid, TEST_VALUE> {
        public Fluid(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<net.minecraft.fluid.Fluid> trueValue, Provider<net.minecraft.fluid.Fluid> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.FLUID.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class Item<TEST_VALUE>
    extends IfElseProvider<net.minecraft.item.Item, TEST_VALUE> {
        public Item(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<net.minecraft.item.Item> trueValue, Provider<net.minecraft.item.Item> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.ITEM.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class FluidStack<TEST_VALUE>
    extends IfElseProvider<net.minecraftforge.fluids.FluidStack, TEST_VALUE> {
        public FluidStack(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<net.minecraftforge.fluids.FluidStack> trueValue, Provider<net.minecraftforge.fluids.FluidStack> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.FLUIDSTACK.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class ItemStack<TEST_VALUE>
    extends IfElseProvider<net.minecraft.item.ItemStack, TEST_VALUE> {
        public ItemStack(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<net.minecraft.item.ItemStack> trueValue, Provider<net.minecraft.item.ItemStack> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.ITEMSTACK.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class String<TEST_VALUE>
    extends IfElseProvider<java.lang.String, TEST_VALUE> {
        public String(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<java.lang.String> trueValue, Provider<java.lang.String> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.STRING.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class Char<TEST_VALUE>
    extends IfElseProvider<Character, TEST_VALUE> {
        public Char(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<Character> trueValue, Provider<Character> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.CHAR.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class Double<TEST_VALUE>
    extends IfElseProvider<java.lang.Double, TEST_VALUE> {
        public Double(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<java.lang.Double> trueValue, Provider<java.lang.Double> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.DOUBLE.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class Float<TEST_VALUE>
    extends IfElseProvider<java.lang.Float, TEST_VALUE> {
        public Float(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<java.lang.Float> trueValue, Provider<java.lang.Float> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.FLOAT.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class Long<TEST_VALUE>
    extends IfElseProvider<java.lang.Long, TEST_VALUE> {
        public Long(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<java.lang.Long> trueValue, Provider<java.lang.Long> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.LONG.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class Int<TEST_VALUE>
    extends IfElseProvider<Integer, TEST_VALUE> {
        public Int(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<Integer> trueValue, Provider<Integer> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.INT.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class Short<TEST_VALUE>
    extends IfElseProvider<java.lang.Short, TEST_VALUE> {
        public Short(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<java.lang.Short> trueValue, Provider<java.lang.Short> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.SHORT.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class Byte<TEST_VALUE>
    extends IfElseProvider<java.lang.Byte, TEST_VALUE> {
        public Byte(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<java.lang.Byte> trueValue, Provider<java.lang.Byte> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.BYTE.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }

    public static class Boolean<TEST_VALUE>
    extends IfElseProvider<java.lang.Boolean, TEST_VALUE> {
        public Boolean(Comparator<TEST_VALUE> comparator, Provider<TEST_VALUE> left, RelationalOperator testType, Provider<TEST_VALUE> right, Provider<java.lang.Boolean> trueValue, Provider<java.lang.Boolean> falseValue) {
            super(comparator, left, testType, right, trueValue, falseValue);
        }

        @Override
        public void writePacketData(PacketBuffer buffer) {
            buffer.func_180714_a(IfElseProviderDeserializers.BOOLEAN.getTypeIdentifier());
            super.writePacketData(buffer);
        }
    }
}

