/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.multiblock.constructor.base;

import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.util.math.BlockOffset;
import com.valkyrieofnight.vlib.multiblock.Structure;
import com.valkyrieofnight.vlib.multiblock.component.Component;
import com.valkyrieofnight.vlib.multiblock.obj.tile.impl.ControllerTile;
import java.util.Map;
import java.util.Queue;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;

public class Formation
implements INBTSerializer {
    protected TileEntity te;
    protected Map<BlockOffset, Boolean> claimed;
    protected boolean formed = false;

    public Formation(ControllerTile te) {
        this.te = te;
        this.claimed = Maps.newHashMap();
    }

    public boolean isFormed() {
        return this.te.func_145831_w().func_201670_d() ? this.formed : !this.claimed.isEmpty() && !this.claimed.containsValue(Boolean.FALSE);
    }

    public boolean isPartiallyFormed() {
        return this.claimed.containsValue(Boolean.TRUE) && this.claimed.containsKey(Boolean.FALSE);
    }

    public boolean isPartiallyUnformed() {
        return this.claimed.containsValue(Boolean.FALSE);
    }

    public boolean isUnformed() {
        return !this.claimed.containsValue(Boolean.TRUE);
    }

    public void setup(Structure structure) {
        this.claimed = structure.getBlankClaimedStateMap();
    }

    public void setClaimed(BlockOffset offset, boolean opt) {
        if (this.claimed.containsKey(offset)) {
            this.claimed.put(offset, opt);
        }
    }

    public boolean check(BlockOffset offset) {
        if (!this.claimed.containsKey(offset)) {
            return false;
        }
        return this.claimed.get(offset);
    }

    public void populateQueueWithAll(Structure structure, Queue<Map.Entry<BlockOffset, Component>> q) {
        for (BlockOffset bo : this.claimed.keySet()) {
            Component comp = structure.getComponent(bo);
            q.add(Maps.immutableEntry((Object)bo, (Object)comp));
        }
    }

    public void populateQueueWithClaimed(Structure structure, Queue<Map.Entry<BlockOffset, Component>> q) {
        for (BlockOffset bo : this.claimed.keySet()) {
            if (!this.claimed.get(bo).booleanValue()) continue;
            q.add(Maps.immutableEntry((Object)bo, (Object)structure.getComponent(bo)));
        }
    }

    public void populateQueueWithUnClaimed(Structure structure, Queue<Map.Entry<BlockOffset, Component>> q) {
        for (BlockOffset bo : this.claimed.keySet()) {
            if (this.claimed.get(bo).booleanValue()) continue;
            q.add(Maps.immutableEntry((Object)bo, (Object)structure.getComponent(bo)));
        }
    }

    public void setFormed(boolean opt) {
        this.formed = opt;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74757_a("formed", this.isFormed());
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        this.setFormed(nbt.func_74767_n("formed"));
    }
}

