/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.integration.forge.fluid;

import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import com.valkyrieofnight.vlib.core.util.wrapped.VLID;
import com.valkyrieofnight.vlib.integration.forge.fluid.IPreciseFluidTank;
import com.valkyrieofnight.vlib.integration.forge.fluid.IVLFluidTank;
import java.util.function.Predicate;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.registries.ForgeRegistries;

public class VLFluidTankPrecise
implements IVLFluidTank,
IPreciseFluidTank {
    protected Predicate<FluidStack> validator;
    protected Fluid fluid = Fluids.field_204541_a;
    protected double level;
    protected int capacity;

    public VLFluidTankPrecise(int capacity) {
        this(capacity, e -> true);
    }

    public VLFluidTankPrecise(int capacity, Predicate<FluidStack> validator) {
        this.capacity = capacity;
        this.validator = validator;
    }

    public VLFluidTankPrecise setValidator(Predicate<FluidStack> validator) {
        if (validator != null) {
            this.validator = validator;
        }
        return this;
    }

    public boolean isFluidValid(FluidStack stack) {
        return this.validator.test(stack);
    }

    @NotNull
    public FluidStack getFluid() {
        return new FluidStack(this.fluid, (int)this.level);
    }

    public int getFluidAmount() {
        return (int)this.level;
    }

    public int getCapacity() {
        return this.capacity;
    }

    @Override
    public CompoundNBT serializeNBT() {
        return NBTBuilder.create().putDouble("level", this.level).putString("fluid", this.fluid.getRegistryName().toString()).build();
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        if (!nbt.func_74764_b("fluid")) {
            this.fluid = Fluids.field_204541_a;
        } else {
            this.fluid = (Fluid)ForgeRegistries.FLUIDS.getValue((ResourceLocation)VLID.from(nbt.func_74779_i("fluid")));
            if (nbt.func_74764_b("level")) {
                this.level = nbt.func_74769_h("level");
            }
        }
    }

    public int getTanks() {
        return 1;
    }

    @NotNull
    public FluidStack getFluidInTank(int tank) {
        return new FluidStack(this.fluid, (int)this.level);
    }

    public int getTankCapacity(int tank) {
        return this.getCapacity();
    }

    public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
        return this.isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !this.isFluidValid(resource)) {
            return 0;
        }
        if (action.simulate()) {
            if (this.level == 0.0) {
                return Math.min(this.capacity, resource.getAmount());
            }
            if (!this.fluid.func_207187_a(resource.getFluid())) {
                return 0;
            }
            return Math.min(this.capacity - (int)this.level, resource.getAmount());
        }
        if (this.level <= 0.0) {
            this.fluid = resource.getFluid();
            this.level = Math.min(this.capacity, resource.getAmount());
            this.onContentsChanged();
            return (int)this.level;
        }
        if (!this.fluid.func_207187_a(resource.getFluid())) {
            return 0;
        }
        int filled = this.capacity - (int)this.level;
        if (resource.getAmount() < filled) {
            this.level += (double)resource.getAmount();
            filled = resource.getAmount();
        } else {
            this.level = this.capacity;
        }
        if (filled > 0) {
            this.onContentsChanged();
        }
        return filled;
    }

    @NotNull
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        if (resource.isEmpty() || !resource.isFluidEqual(new FluidStack(this.fluid, 1))) {
            return FluidStack.EMPTY;
        }
        return this.drain(resource.getAmount(), action);
    }

    @NotNull
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        int drained = maxDrain;
        if (this.level < (double)drained) {
            drained = (int)this.level;
        }
        FluidStack stack = new FluidStack(this.fluid, drained);
        if (action.execute() && drained > 0) {
            this.level -= (double)drained;
        }
        if (drained > 0) {
            this.onContentsChanged();
        }
        return stack;
    }

    protected void onContentsChanged() {
    }

    @Override
    public double getLevel() {
        return this.level;
    }

    @Override
    public double getRemainingLevel() {
        return (double)this.capacity - this.level;
    }

    @Override
    public double fill(Fluid fluid, double amount, IFluidHandler.FluidAction action) {
        if (amount <= 0.0 || !this.isFluidValid(new FluidStack(fluid, 1))) {
            return 0.0;
        }
        if (action.simulate()) {
            if (this.level <= 0.0) {
                return Math.min((double)this.capacity, amount);
            }
            if (!this.fluid.func_207187_a(fluid)) {
                return 0.0;
            }
            return Math.min((double)this.capacity - this.level, amount);
        }
        if (this.fluid == Fluids.field_204541_a) {
            this.fluid = fluid;
            this.level = Math.min((double)this.capacity, amount);
            this.onContentsChanged();
            return this.level;
        }
        double filled = this.getRemainingLevel();
        if (amount < filled) {
            this.level += amount;
            filled = amount;
        } else {
            this.level = this.capacity;
        }
        if (filled > 0.0) {
            this.onContentsChanged();
        }
        return filled;
    }

    @Override
    public double drain(Fluid fluid, double max, IFluidHandler.FluidAction action) {
        double drained = max;
        if (this.level < drained) {
            drained = this.level;
        }
        if (action.execute() && drained > 0.0) {
            this.level -= drained;
        }
        if (drained > 0.0) {
            this.onContentsChanged();
        }
        return drained;
    }
}

