/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.scanner;

import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.convenience.ITick;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Action1a;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Function1a;
import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;

public class BlockLineScanner
implements ITick,
INBTSerializer {
    private Queue<BlockPos> queue = new LinkedList<BlockPos>();
    private int scanRate;
    private Function1a<BlockPos, Boolean> validator;
    private Action1a<BlockPos> endFound;
    private BlockPos start;
    private int range;
    private Direction direction;
    private BlockPos beforeEndPos;
    private BlockPos endPos;
    private boolean enableScan = false;

    public BlockLineScanner(int scanRate, @NotNull Function1a<BlockPos, Boolean> validator, Action1a<BlockPos> endFound) {
        this.scanRate = scanRate;
        this.validator = validator;
        this.endFound = endFound;
    }

    @Override
    public void tick() {
        if (!this.enableScan) {
            return;
        }
        for (int i = 0; i < this.scanRate; ++i) {
            BlockPos pos;
            if (this.queue.isEmpty()) {
                this.startQueue();
            }
            if (!this.isValid(pos = this.queue.poll())) {
                this.startQueue();
                this.endPos = pos;
                this.endFound.execute(this.endPos);
                continue;
            }
            this.beforeEndPos = pos;
        }
    }

    public void setup(@NotNull BlockPos startPos, @NotNull Direction direction, int range) {
        this.start = startPos;
        this.direction = direction;
        this.range = range;
    }

    public void start() {
        if (this.start != null || this.direction != null || this.range > 0) {
            this.enableScan = true;
        }
    }

    public void stop() {
        this.enableScan = false;
    }

    protected boolean isValid(BlockPos pos) {
        return this.validator.execute(pos);
    }

    protected void startQueue() {
        this.queue = new LinkedList<BlockPos>();
        BlockPos cp = new BlockPos((Vector3i)this.start);
        for (int i = 0; i < this.range; ++i) {
            this.queue.add(cp);
            cp = cp.func_177972_a(this.direction);
        }
    }

    public BlockPos getEndPos() {
        return this.endPos;
    }

    @Override
    public CompoundNBT serializeNBT() {
        if (this.endPos != null) {
            return NBTBuilder.create().putInt("x", this.endPos.func_177958_n()).putInt("y", this.endPos.func_177956_o()).putInt("z", this.endPos.func_177952_p()).build();
        }
        return new CompoundNBT();
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("x") && nbt.func_74764_b("y") && nbt.func_74764_b("z")) {
            this.endPos = new BlockPos(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"));
        }
    }
}

