/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.util.math;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.valkyrieofnight.vlib.core.util.math.RelativeDirection;
import com.valkyrieofnight.vlib.core.util.math.XYZDirection;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.util.Direction;

public enum XYZOrientation {
    PXPYPZ(0, XYZDirection.POS_X, XYZDirection.POS_Y, XYZDirection.POS_Z, 0),
    PXPZNY(1, XYZDirection.POS_X, XYZDirection.POS_Z, XYZDirection.NEG_Y, 3),
    PXNYNZ(2, XYZDirection.POS_X, XYZDirection.NEG_Y, XYZDirection.NEG_Z, 2),
    PXNZPY(3, XYZDirection.POS_X, XYZDirection.NEG_Z, XYZDirection.POS_Y, 1),
    PYPXNZ(4, XYZDirection.POS_Y, XYZDirection.POS_X, XYZDirection.NEG_Z, 4),
    PYPZPX(5, XYZDirection.POS_Y, XYZDirection.POS_Z, XYZDirection.POS_X, 8),
    PYNXPZ(6, XYZDirection.POS_Y, XYZDirection.NEG_X, XYZDirection.POS_Z, 16),
    PYNZNX(7, XYZDirection.POS_Y, XYZDirection.NEG_Z, XYZDirection.NEG_X, 20),
    PZPXPY(8, XYZDirection.POS_Z, XYZDirection.POS_X, XYZDirection.POS_Y, 5),
    PZPYNX(9, XYZDirection.POS_Z, XYZDirection.POS_Y, XYZDirection.NEG_X, 21),
    PZNXNY(10, XYZDirection.POS_Z, XYZDirection.NEG_X, XYZDirection.NEG_Y, 19),
    PZNYPX(11, XYZDirection.POS_Z, XYZDirection.NEG_Y, XYZDirection.POS_X, 11),
    NXPYNZ(12, XYZDirection.NEG_X, XYZDirection.POS_Y, XYZDirection.NEG_Z, 12),
    NXPZPY(13, XYZDirection.NEG_X, XYZDirection.POS_Z, XYZDirection.POS_Y, 13),
    NXNYPZ(14, XYZDirection.NEG_X, XYZDirection.NEG_Y, XYZDirection.POS_Z, 14),
    NXNZNY(15, XYZDirection.NEG_X, XYZDirection.NEG_Z, XYZDirection.NEG_Y, 15),
    NYPXPZ(16, XYZDirection.NEG_Y, XYZDirection.POS_X, XYZDirection.POS_Z, 6),
    NYPZNX(17, XYZDirection.NEG_Y, XYZDirection.POS_Z, XYZDirection.NEG_X, 22),
    NYNXNZ(18, XYZDirection.NEG_Y, XYZDirection.NEG_X, XYZDirection.NEG_Z, 18),
    NYNZPX(19, XYZDirection.NEG_Y, XYZDirection.NEG_Z, XYZDirection.POS_X, 10),
    NZPXNY(20, XYZDirection.NEG_Z, XYZDirection.POS_X, XYZDirection.NEG_Y, 7),
    NZPYPX(21, XYZDirection.NEG_Z, XYZDirection.POS_Y, XYZDirection.POS_X, 9),
    NZNXPY(22, XYZDirection.NEG_Z, XYZDirection.NEG_X, XYZDirection.POS_Y, 17),
    NZNYNX(23, XYZDirection.NEG_Z, XYZDirection.NEG_Y, XYZDirection.NEG_X, 23);

    private final int index;
    private final int indexReverseRotation;
    private final ConcurrentMap<Integer, XYZDirection> ordinalToXYZ = Maps.newConcurrentMap();
    private final ConcurrentMap<XYZDirection, Integer> xyzToOrdinal = Maps.newConcurrentMap();
    private static ConcurrentMap<RelativeDirection, XYZDirection> relativeToXYZ;
    private static ConcurrentMap<RelativeDirection, Integer> relativeToOrdinal;
    private static ConcurrentMap<Direction, Integer> dirToRelativeOrdinal;
    private static ConcurrentMap<Integer, Direction> relativeOrdinalToDir;
    private static ConcurrentMap<Direction, XYZDirection> directionToXYZDirection;
    private static final XYZOrientation[] ALL;
    private static final List<XYZOrientation> ALL_LIST;

    private XYZOrientation(int index, XYZDirection x, XYZDirection y, XYZDirection z, int indexReverseRotation) {
        this.index = index;
        this.ordinalToXYZ.put(0, x);
        this.ordinalToXYZ.put(1, y);
        this.ordinalToXYZ.put(2, z);
        this.ordinalToXYZ.put(3, x.getOpposite());
        this.ordinalToXYZ.put(4, y.getOpposite());
        this.ordinalToXYZ.put(5, z.getOpposite());
        this.xyzToOrdinal.put(x, 0);
        this.xyzToOrdinal.put(y, 1);
        this.xyzToOrdinal.put(z, 2);
        this.xyzToOrdinal.put(x.getOpposite(), 3);
        this.xyzToOrdinal.put(y.getOpposite(), 4);
        this.xyzToOrdinal.put(z.getOpposite(), 5);
        this.indexReverseRotation = indexReverseRotation;
    }

    public XYZDirection getNewX() {
        return (XYZDirection)((Object)this.ordinalToXYZ.get(0));
    }

    public XYZDirection getNewY() {
        return (XYZDirection)((Object)this.ordinalToXYZ.get(1));
    }

    public XYZDirection getNewZ() {
        return (XYZDirection)((Object)this.ordinalToXYZ.get(2));
    }

    public XYZDirection getNewXYZFrom(RelativeDirection rd) {
        if (rd == null) {
            return (XYZDirection)((Object)this.ordinalToXYZ.get(0));
        }
        return (XYZDirection)((Object)this.ordinalToXYZ.get(relativeToOrdinal.get((Object)rd)));
    }

    public Direction getDirectionFrom(RelativeDirection rd) {
        return (Direction)relativeOrdinalToDir.get(this.xyzToOrdinal.get(relativeToXYZ.get((Object)rd)));
    }

    public XYZOrientation getOpposite() {
        return XYZOrientation.getByIndex(this.indexReverseRotation);
    }

    public int getIndex() {
        return this.index;
    }

    public static final XYZOrientation getByIndex(int index) {
        return ALL[index % ALL.length];
    }

    public static final XYZOrientation[] getAll() {
        return ALL;
    }

    public static final List<XYZOrientation> getAllList() {
        return ALL_LIST;
    }

    public static List<XYZOrientation> getAllWith(Direction dir, RelativeDirection rd) {
        return XYZOrientation.getAllWith(dir, rd, (List<XYZOrientation>)Lists.newArrayList((Object[])ALL));
    }

    public static List<XYZOrientation> getAllWith(Direction dir, RelativeDirection rd, List<XYZOrientation> from) {
        ArrayList ors = Lists.newArrayList();
        XYZDirection rxyz = (XYZDirection)((Object)relativeToXYZ.get((Object)rd));
        int ordinal = (Integer)dirToRelativeOrdinal.get(dir);
        for (XYZOrientation xyz : from) {
            if (xyz.ordinalToXYZ.get(ordinal) != rxyz) continue;
            ors.add(xyz);
        }
        return ors;
    }

    @Deprecated
    public static List<XYZOrientation> getAllWith(RelativeDirection relative, Direction direction) {
        return XYZOrientation.getAllWith(relative, direction, (List<XYZOrientation>)Lists.newArrayList((Object[])ALL));
    }

    @Deprecated
    public static List<XYZOrientation> getAllWith(RelativeDirection relative, Direction direction, List<XYZOrientation> from) {
        ArrayList ors = Lists.newArrayList();
        XYZDirection rxyz = (XYZDirection)((Object)directionToXYZDirection.get(direction));
        for (XYZOrientation xyz : from) {
            if (xyz.getNewXYZFrom(relative) != rxyz) continue;
            ors.add(xyz);
        }
        return ors;
    }

    public static List<XYZOrientation> getWithForwardAs(Direction direction) {
        ArrayList ors = Lists.newArrayList();
        XYZDirection xd = (XYZDirection)((Object)directionToXYZDirection.get(direction));
        for (XYZOrientation xyz : ALL) {
            if (xyz.getNewXYZFrom(RelativeDirection.FORWARD) != xd) continue;
            ors.add(xyz);
        }
        return ors;
    }

    static {
        relativeToXYZ = Maps.newConcurrentMap();
        relativeToOrdinal = Maps.newConcurrentMap();
        dirToRelativeOrdinal = Maps.newConcurrentMap();
        relativeOrdinalToDir = Maps.newConcurrentMap();
        directionToXYZDirection = Maps.newConcurrentMap();
        relativeToOrdinal.put(RelativeDirection.UP, 1);
        relativeToOrdinal.put(RelativeDirection.DOWN, 4);
        relativeToOrdinal.put(RelativeDirection.LEFT, 0);
        relativeToOrdinal.put(RelativeDirection.RIGHT, 3);
        relativeToOrdinal.put(RelativeDirection.FORWARD, 2);
        relativeToOrdinal.put(RelativeDirection.BACKWARD, 5);
        dirToRelativeOrdinal.put(Direction.UP, 1);
        dirToRelativeOrdinal.put(Direction.DOWN, 4);
        dirToRelativeOrdinal.put(Direction.EAST, 0);
        dirToRelativeOrdinal.put(Direction.WEST, 3);
        dirToRelativeOrdinal.put(Direction.SOUTH, 2);
        dirToRelativeOrdinal.put(Direction.NORTH, 5);
        relativeOrdinalToDir.put(1, Direction.UP);
        relativeOrdinalToDir.put(4, Direction.DOWN);
        relativeOrdinalToDir.put(0, Direction.EAST);
        relativeOrdinalToDir.put(3, Direction.WEST);
        relativeOrdinalToDir.put(2, Direction.SOUTH);
        relativeOrdinalToDir.put(5, Direction.NORTH);
        relativeToXYZ.put(RelativeDirection.LEFT, XYZDirection.POS_X);
        relativeToXYZ.put(RelativeDirection.UP, XYZDirection.POS_Y);
        relativeToXYZ.put(RelativeDirection.FORWARD, XYZDirection.POS_Z);
        relativeToXYZ.put(RelativeDirection.RIGHT, XYZDirection.NEG_X);
        relativeToXYZ.put(RelativeDirection.DOWN, XYZDirection.NEG_Y);
        relativeToXYZ.put(RelativeDirection.BACKWARD, XYZDirection.NEG_Z);
        directionToXYZDirection.put(Direction.DOWN, XYZDirection.NEG_Y);
        directionToXYZDirection.put(Direction.UP, XYZDirection.POS_Y);
        directionToXYZDirection.put(Direction.NORTH, XYZDirection.NEG_Z);
        directionToXYZDirection.put(Direction.SOUTH, XYZDirection.POS_Z);
        directionToXYZDirection.put(Direction.WEST, XYZDirection.NEG_X);
        directionToXYZDirection.put(Direction.EAST, XYZDirection.POS_X);
        ALL = XYZOrientation.values();
        ALL_LIST = Lists.newArrayList((Object[])ALL);
    }
}

