/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.text;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.ui.client.renderer.RenderUtils;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.VLElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.ElementColor;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementDraw;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.base.IElementThemeListener;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.HAlignment;
import com.valkyrieofnight.vlib.core.ui.client.screen.util.format.VAlignment;
import com.valkyrieofnight.vlib.core.ui.theme.client.AssetID;
import com.valkyrieofnight.vlib.core.ui.theme.client.Theme;
import com.valkyrieofnight.vlib.core.util.color.Color4;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class LabelElement
extends VLElement
implements IElementDraw,
IElementThemeListener {
    protected ITextComponent text;
    protected FontRenderer textRenderer;
    protected ElementColor color;
    protected HAlignment hAlignment;
    protected VAlignment vAlignment;
    protected boolean enableShadow = false;

    public LabelElement(String id, ITextComponent text, AssetID color) {
        super(id);
        this.setup();
        this.text = text;
        if (text == null) {
            this.text = new StringTextComponent("NA");
        }
        this.color = new ElementColor((IElement)this, color);
    }

    public LabelElement(String id, ITextComponent text, Color4 color) {
        super(id);
        this.setup();
        this.text = text;
        this.color = new ElementColor((IElement)this, color);
    }

    private void setup() {
        this.hAlignment = HAlignment.LEFT;
        this.vAlignment = VAlignment.TOP;
        this.textRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    public LabelElement setText(ITextComponent text) {
        this.text = text;
        return this;
    }

    public LabelElement setColor(AssetID colorID) {
        this.color.override(colorID);
        return this;
    }

    @Deprecated
    public LabelElement setColor(Color4 color) {
        this.color.override(color);
        return this;
    }

    public LabelElement setVerticalAlignment(VAlignment va) {
        this.vAlignment = va;
        return this;
    }

    public LabelElement setHorizontalAlignment(HAlignment ha) {
        this.hAlignment = ha;
        return this;
    }

    @Override
    public void onThemeChanged(Theme current) {
        this.color.onThemeChanged(current);
    }

    @Override
    public void load(CompoundNBT nbt) {
    }

    @Override
    public CompoundNBT save(CompoundNBT nbt) {
        return nbt;
    }

    @Override
    public int getSizeX() {
        return this.textRenderer.func_78256_a(this.text.getString());
    }

    @Override
    public int getSizeY() {
        this.textRenderer.getClass();
        return 9;
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        RenderUtils.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int tsw = this.textRenderer.func_78256_a(this.text.getString());
        this.textRenderer.getClass();
        int tsh = 9;
        int xOffset = this.hAlignment.getOffset(tsw);
        int yOffset = this.vAlignment.getOffset(tsh);
        if (this.enableShadow) {
            this.textRenderer.func_243248_b(matrixStack, this.text, (float)(this.getActualX() + xOffset), (float)(this.getActualY() + yOffset), this.color.getColor().getRGBA());
        } else {
            this.textRenderer.func_243248_b(matrixStack, this.text, (float)(this.getActualX() + xOffset), (float)(this.getActualY() + yOffset), this.color.getColor().getRGBA());
        }
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mouseX, double mouseY) {
    }
}

