/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.ui.client.screen.element.sidemenu.sideconfig;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.valkyrieofnight.vlib.core.obj.container.config.SidedConfigWL;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.container.FixedContainerElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.sidemenu.sideconfig.ISidedConfigElement;
import com.valkyrieofnight.vlib.core.ui.client.screen.element.sidemenu.sideconfig.SlotConfigElement;
import com.valkyrieofnight.vlib.core.ui.container.VLContainer;
import com.valkyrieofnight.vlib.core.ui.theme.client.StandardThemeAssets;
import com.valkyrieofnight.vlib.core.util.convenience.IToggleable;
import com.valkyrieofnight.vlib.core.util.logic.lambda.Provider;
import java.util.List;
import net.minecraft.inventory.container.Slot;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;

public class SlotConfigArrayElement
extends FixedContainerElement
implements ISidedConfigElement {
    protected SidedConfigWL config;
    protected VLContainer cont;
    protected int totalSlots;
    protected List<Integer> allSlots = Lists.newArrayList();
    protected Provider<Integer> gx;
    protected Provider<Integer> gy;

    public SlotConfigArrayElement(String id, SidedConfigWL config, VLContainer cont, Provider<Integer> xSize, Provider<Integer> ySize) {
        super(id, 0, 0);
        this.config = config;
        this.cont = cont;
        this.gx = xSize;
        this.gy = ySize;
        this.totalSlots = config.getTotalSlots();
        for (int i = 0; i < this.totalSlots; ++i) {
            this.allSlots.add(i);
        }
    }

    @Override
    public int getSizeX() {
        return this.gx.request();
    }

    @Override
    public int getSizeY() {
        return this.gy.request();
    }

    @Override
    public void addElements() {
        for (int i = 0; i < this.totalSlots; ++i) {
            this.addElement(new SlotConfigElement(i + "", this.config, i, StandardThemeAssets.TEX_VANILLA_SIDE_CONFIG_ENA, StandardThemeAssets.TEX_VANILLA_SIDE_CONFIG_DIS, StandardThemeAssets.TEX_VANILLA_SIDE_CONFIG_HOV), this.cont.func_75139_a((int)i).field_75223_e, this.cont.func_75139_a((int)i).field_75221_f);
        }
    }

    public void savePacketData(CompoundNBT data) {
        data.func_218657_a(this.config.getName(), (INBT)this.config.serializeNBT());
    }

    @Override
    public void renderBg(MatrixStack matrixStack, double mouseX, double mouseY, float partialTicks) {
        super.renderBg(matrixStack, mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderFg(MatrixStack matrixStack, double mouseX, double mouseY) {
        super.renderFg(matrixStack, mouseX, mouseY);
    }

    @Override
    public void enableConfig() {
        this.cont.blockInteraction(this.allSlots);
        for (int i : this.allSlots) {
            Slot s = this.cont.func_75139_a(i);
            if (!(s instanceof IToggleable)) continue;
            ((IToggleable)s).setActive(false);
        }
    }

    @Override
    public void disableConfig() {
        this.cont.resetBlockedSlots();
        for (int i : this.allSlots) {
            Slot s = this.cont.func_75139_a(i);
            if (!(s instanceof IToggleable)) continue;
            ((IToggleable)s).setActive(true);
        }
    }
}

