/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.obj.tileentity.base.tick;

import com.valkyrieofnight.vlib.core.io.nbt.INBTSerializer;
import com.valkyrieofnight.vlib.core.util.nbt.NBTBuilder;
import net.minecraft.nbt.CompoundNBT;

public class LongTickCounter
implements INBTSerializer {
    private long tickTotal = 0L;
    private long tickProgress = 0L;

    public void reset(long duration) {
        this.tickTotal = duration + 1L;
        this.tickProgress = 0L;
    }

    public void start() {
        if (this.tickProgress <= 0L) {
            this.tick();
        }
    }

    public boolean hasStarted() {
        return this.tickProgress >= 1L && !this.isComplete();
    }

    public boolean isComplete() {
        return this.tickProgress >= this.tickTotal;
    }

    public void tick() {
        ++this.tickProgress;
    }

    public void tick(long tickAmount) {
        this.tickProgress += tickAmount;
    }

    public long getTicksRemaining() {
        return this.tickTotal - this.tickProgress;
    }

    public long getTicksOvershot() {
        return Math.max(this.tickProgress - this.tickTotal, 0L);
    }

    public long getDuration() {
        return this.tickTotal - 1L;
    }

    public long getProgress() {
        if (this.tickProgress == 0L) {
            return 0L;
        }
        return this.tickProgress - 1L;
    }

    public long clampTicks(long attemptingTickAmmount) {
        return Math.min(attemptingTickAmmount, this.getTicksRemaining());
    }

    @Override
    public CompoundNBT serializeNBT() {
        return NBTBuilder.create().putLong("tick_total", this.tickTotal).putLong("tick_progress", this.tickProgress).build();
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt != null) {
            this.tickTotal = nbt.func_74763_f("tick_total");
            this.tickProgress = nbt.func_74763_f("tick_progress");
        }
    }
}

