/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.vlib.core.io.json.config.property.properties;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropBase;
import com.valkyrieofnight.vlib.core.io.json.config.property.PropParserBase;
import com.valkyrieofnight.vlib.core.util.annotations.NotNull;
import com.valkyrieofnight.vlib.core.util.math.MathUtil;

public class PropLong
extends PropBase<Long> {
    public static final PropLongParser PARSER = new PropLongParser();
    protected long min;
    protected long max;

    public PropLong(long value, long min, long max) {
        super(value);
        this.min = min;
        this.max = max;
    }

    public PropLong(long value) {
        this(value, Long.MIN_VALUE, Long.MAX_VALUE);
    }

    @Override
    public String getExtra() {
        return "[" + this.min + "~" + this.max + "]";
    }

    @Override
    protected Long validateData(Long data) {
        return MathUtil.clamp(data, this.min, this.max);
    }

    @Override
    public PropParserBase getParser() {
        return PARSER;
    }

    protected static class PropLongParser
    extends PropParserBase<PropLong> {
        public PropLongParser() {
            super("lo");
        }

        @Override
        public PropLong fromJson(@NotNull JsonElement json) throws Exception {
            return new PropLong(json.getAsLong());
        }

        @Override
        public JsonElement toJson(@NotNull PropLong prop) throws Exception {
            return new JsonPrimitive((Number)prop.getValue());
        }
    }
}

