/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.curios.common.event;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.server.management.PlayerList;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.GameRules;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerXpEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import net.minecraftforge.items.ItemHandlerHelper;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.event.CurioChangeEvent;
import top.theillusivec4.curios.api.event.CurioDropsEvent;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.ISlotType;
import top.theillusivec4.curios.api.type.capability.ICurio;
import top.theillusivec4.curios.api.type.capability.ICurioItem;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;
import top.theillusivec4.curios.api.type.inventory.IDynamicStackHandler;
import top.theillusivec4.curios.api.type.util.ICuriosHelper;
import top.theillusivec4.curios.common.capability.CurioInventoryCapability;
import top.theillusivec4.curios.common.capability.CurioItemCapability;
import top.theillusivec4.curios.common.capability.ItemizedCurioCapability;
import top.theillusivec4.curios.common.network.NetworkHandler;
import top.theillusivec4.curios.common.network.server.SPacketSetIcons;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncCurios;
import top.theillusivec4.curios.common.network.server.sync.SPacketSyncStack;
import top.theillusivec4.curios.common.triggers.EquipCurioTrigger;

public class CuriosEventHandler {
    public static boolean dirtyTags = false;

    private static void handleDrops(LivingEntity livingEntity, List<Tuple<Predicate<ItemStack>, ICurio.DropRule>> dropRules, IDynamicStackHandler stacks, Collection<ItemEntity> drops, boolean keepInventory) {
        for (int i = 0; i < stacks.getSlots(); ++i) {
            ICurio.DropRule dropRule;
            ItemStack stack = stacks.getStackInSlot(i);
            if (stack.func_190926_b()) continue;
            ICurio.DropRule dropRuleOverride = null;
            for (Tuple<Predicate<ItemStack>, ICurio.DropRule> override : dropRules) {
                if (!((Predicate)override.func_76341_a()).test(stack)) continue;
                dropRuleOverride = (ICurio.DropRule)((Object)override.func_76340_b());
            }
            ICurio.DropRule dropRule2 = dropRule = dropRuleOverride != null ? dropRuleOverride : CuriosApi.getCuriosHelper().getCurio(stack).map(curio -> curio.getDropRule(livingEntity)).orElse(ICurio.DropRule.DEFAULT);
            if (dropRule == ICurio.DropRule.DEFAULT && keepInventory || dropRule == ICurio.DropRule.ALWAYS_KEEP) continue;
            if (!EnchantmentHelper.func_190939_c((ItemStack)stack) && dropRule != ICurio.DropRule.DESTROY) {
                drops.add(CuriosEventHandler.getDroppedItem(stack, livingEntity));
            }
            stacks.setStackInSlot(i, ItemStack.field_190927_a);
        }
    }

    private static ItemEntity getDroppedItem(ItemStack droppedItem, LivingEntity livingEntity) {
        double d0 = livingEntity.func_226278_cu_() - (double)0.3f + (double)livingEntity.func_70047_e();
        ItemEntity entityitem = new ItemEntity(livingEntity.field_70170_p, livingEntity.func_226277_ct_(), d0, livingEntity.func_226281_cx_(), droppedItem);
        entityitem.func_174867_a(40);
        float f = livingEntity.field_70170_p.field_73012_v.nextFloat() * 0.5f;
        float f1 = livingEntity.field_70170_p.field_73012_v.nextFloat() * ((float)Math.PI * 2);
        entityitem.func_213293_j((double)(-MathHelper.func_76126_a((float)f1) * f), (double)0.2f, (double)(MathHelper.func_76134_b((float)f1) * f));
        return entityitem;
    }

    private static boolean handleMending(PlayerEntity player, IDynamicStackHandler stacks, PlayerXpEvent.PickupXp evt) {
        for (int i = 0; i < stacks.getSlots(); ++i) {
            ItemStack stack = stacks.getStackInSlot(i);
            if (stack.func_190926_b() || EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185296_A, (ItemStack)stack) <= 0 || !stack.func_77951_h()) continue;
            evt.setCanceled(true);
            ExperienceOrbEntity orb = evt.getOrb();
            player.field_71090_bL = 2;
            player.func_71001_a((Entity)orb, 1);
            int toRepair = Math.min(orb.field_70530_e * 2, stack.func_77952_i());
            orb.field_70530_e -= toRepair / 2;
            stack.func_196085_b(stack.func_77952_i() - toRepair);
            if (orb.field_70530_e > 0) {
                player.func_195068_e(orb.field_70530_e);
            }
            orb.func_70106_y();
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void playerLoggedIn(PlayerEvent.PlayerLoggedInEvent evt) {
        PlayerEntity playerEntity = evt.getPlayer();
        if (playerEntity instanceof ServerPlayerEntity) {
            Collection<ISlotType> slotTypes = CuriosApi.getSlotHelper().getSlotTypes();
            HashMap<String, ResourceLocation> icons = new HashMap<String, ResourceLocation>();
            slotTypes.forEach(type -> icons.put(type.getIdentifier(), type.getIcon()));
            NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)playerEntity), (Object)new SPacketSetIcons(icons));
        }
    }

    @SubscribeEvent
    public void attachEntitiesCapabilities(AttachCapabilitiesEvent<Entity> evt) {
        if (evt.getObject() instanceof PlayerEntity) {
            evt.addCapability(CuriosCapability.ID_INVENTORY, CurioInventoryCapability.createProvider((PlayerEntity)evt.getObject()));
        }
    }

    @SubscribeEvent
    public void attachStackCapabilities(AttachCapabilitiesEvent<ItemStack> evt) {
        ICurioItem itemCurio;
        ItemStack stack = (ItemStack)evt.getObject();
        if (stack.func_77973_b() instanceof ICurioItem && (itemCurio = (ICurioItem)stack.func_77973_b()).hasCurioCapability(stack)) {
            ItemizedCurioCapability itemizedCapability = new ItemizedCurioCapability(itemCurio, stack);
            evt.addCapability(CuriosCapability.ID_ITEM, CurioItemCapability.createProvider(itemizedCapability));
        }
    }

    @SubscribeEvent
    public void entityJoinWorld(EntityJoinWorldEvent evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof ServerPlayerEntity) {
            ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)entity;
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)serverPlayerEntity).ifPresent(handler -> {
                ServerPlayerEntity mp = (ServerPlayerEntity)entity;
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> mp), (Object)new SPacketSyncCurios(mp.func_145782_y(), handler.getCurios()));
            });
        }
    }

    @SubscribeEvent
    public void playerStartTracking(PlayerEvent.StartTracking evt) {
        Entity target = evt.getTarget();
        PlayerEntity player = evt.getPlayer();
        if (player instanceof ServerPlayerEntity && target instanceof LivingEntity) {
            LivingEntity livingBase = (LivingEntity)target;
            CuriosApi.getCuriosHelper().getCuriosHandler(livingBase).ifPresent(handler -> NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new SPacketSyncCurios(target.func_145782_y(), handler.getCurios())));
        }
    }

    @SubscribeEvent
    public void playerClone(PlayerEvent.Clone evt) {
        PlayerEntity player = evt.getPlayer();
        PlayerEntity oldPlayer = evt.getOriginal();
        oldPlayer.revive();
        LazyOptional<ICuriosItemHandler> oldHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)oldPlayer);
        LazyOptional<ICuriosItemHandler> newHandler = CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player);
        oldHandler.ifPresent(oldCurios -> newHandler.ifPresent(newCurios -> {
            newCurios.setCurios(new LinkedHashMap<String, ICurioStacksHandler>(oldCurios.getCurios()));
            oldCurios.getCurios().forEach((identifier, stacksHandler) -> {
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    SlotContext slotContext = new SlotContext((String)identifier, (LivingEntity)player, i);
                    if (stack.func_190926_b()) continue;
                    UUID uuid = UUID.nameUUIDFromBytes((identifier + i).getBytes());
                    player.func_233645_dx_().func_233793_b_(CuriosApi.getCuriosHelper().getAttributeModifiers(slotContext, uuid, stack));
                    CuriosApi.getCuriosHelper().getCurio(stack).ifPresent(curio -> curio.onEquip(slotContext, ItemStack.field_190927_a));
                    if (!(player instanceof ServerPlayerEntity)) continue;
                    EquipCurioTrigger.INSTANCE.trigger((ServerPlayerEntity)player, stack, (ServerWorld)player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                }
            });
        }));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void playerDrops(LivingDropsEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        if (!livingEntity.func_175149_v()) {
            CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> {
                Collection drops = evt.getDrops();
                ArrayList<ItemEntity> curioDrops = new ArrayList<ItemEntity>();
                Map<String, ICurioStacksHandler> curios = handler.getCurios();
                DropRulesEvent dropRulesEvent = new DropRulesEvent(livingEntity, (ICuriosItemHandler)handler, evt.getSource(), evt.getLootingLevel(), evt.isRecentlyHit());
                MinecraftForge.EVENT_BUS.post((Event)dropRulesEvent);
                ImmutableList<Tuple<Predicate<ItemStack>, ICurio.DropRule>> dropRules = dropRulesEvent.getOverrides();
                boolean keepInventory = livingEntity.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223600_c);
                curios.forEach((id, stacksHandler) -> {
                    CuriosEventHandler.handleDrops(livingEntity, dropRules, stacksHandler.getStacks(), curioDrops, keepInventory);
                    CuriosEventHandler.handleDrops(livingEntity, dropRules, stacksHandler.getCosmeticStacks(), curioDrops, keepInventory);
                });
                if (!MinecraftForge.EVENT_BUS.post((Event)new CurioDropsEvent(livingEntity, (ICuriosItemHandler)handler, evt.getSource(), (Collection<ItemEntity>)curioDrops, evt.getLootingLevel(), evt.isRecentlyHit()))) {
                    drops.addAll(curioDrops);
                }
            });
        }
    }

    @SubscribeEvent
    public void playerXPPickUp(PlayerXpEvent.PickupXp evt) {
        PlayerEntity player = evt.getPlayer();
        if (!player.field_70170_p.field_72995_K) {
            CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                Map<String, ICurioStacksHandler> curios = handler.getCurios();
                for (ICurioStacksHandler stacksHandler : curios.values()) {
                    if (!CuriosEventHandler.handleMending(player, stacksHandler.getStacks(), evt) && !CuriosEventHandler.handleMending(player, stacksHandler.getCosmeticStacks(), evt)) continue;
                    return;
                }
            });
        }
    }

    @SubscribeEvent
    public void curioRightClick(PlayerInteractEvent.RightClickItem evt) {
        PlayerEntity player = evt.getPlayer();
        ItemStack stack = evt.getItemStack();
        ICuriosHelper curiosHelper = CuriosApi.getCuriosHelper();
        curiosHelper.getCurio(stack).ifPresent(curio -> curiosHelper.getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
            if (!player.field_70170_p.field_72995_K) {
                Map<String, ICurioStacksHandler> curios = handler.getCurios();
                for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
                    IDynamicStackHandler stackHandler = entry.getValue().getStacks();
                    for (int i = 0; i < stackHandler.getSlots(); ++i) {
                        ItemStack present;
                        String id = entry.getKey();
                        SlotContext slotContext = new SlotContext(id, (LivingEntity)player, i);
                        if (!curiosHelper.isStackValid(slotContext, stack) || !curio.canEquip(id, (LivingEntity)player) || !curio.canEquipFromUse(slotContext) || !(present = stackHandler.getStackInSlot(i)).func_190926_b()) continue;
                        stackHandler.setStackInSlot(i, stack.func_77946_l());
                        curio.onEquipFromUse(slotContext);
                        if (!player.func_184812_l_()) {
                            int count = stack.func_190916_E();
                            stack.func_190918_g(count);
                        }
                        evt.setCancellationResult(ActionResultType.SUCCESS);
                        evt.setCanceled(true);
                        return;
                    }
                }
            } else {
                evt.setCancellationResult(ActionResultType.func_233537_a_((boolean)player.field_70170_p.func_201670_d()));
                evt.setCanceled(true);
            }
        }));
    }

    @SubscribeEvent
    public void worldTick(TickEvent.WorldTickEvent evt) {
        if (evt.world instanceof ServerWorld && dirtyTags) {
            PlayerList list = ((ServerWorld)evt.world).func_73046_m().func_184103_al();
            ICuriosHelper curiosHelper = CuriosApi.getCuriosHelper();
            for (ServerPlayerEntity player : list.func_181057_v()) {
                curiosHelper.getCuriosHandler((LivingEntity)player).ifPresent(handler -> {
                    for (Map.Entry<String, ICurioStacksHandler> entry : handler.getCurios().entrySet()) {
                        ICurioStacksHandler stacksHandler = entry.getValue();
                        String id = entry.getKey();
                        IDynamicStackHandler stacks = stacksHandler.getStacks();
                        IDynamicStackHandler cosmeticStacks = stacksHandler.getCosmeticStacks();
                        CuriosEventHandler.replaceInvalidStacks(curiosHelper, player, id, stacks);
                        CuriosEventHandler.replaceInvalidStacks(curiosHelper, player, id, cosmeticStacks);
                    }
                });
            }
            dirtyTags = false;
        }
    }

    private static void replaceInvalidStacks(ICuriosHelper curiosHelper, ServerPlayerEntity player, String id, IDynamicStackHandler stacks) {
        for (int i = 0; i < stacks.getSlots(); ++i) {
            ItemStack stack = stacks.getStackInSlot(i);
            SlotContext slotContext = new SlotContext(id, (LivingEntity)player, i);
            if (stack.func_190926_b() || curiosHelper.isStackValid(slotContext, stack)) continue;
            stacks.setStackInSlot(i, ItemStack.field_190927_a);
            ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack);
        }
    }

    @SubscribeEvent
    public void looting(LootingLevelEvent event) {
        if (event.getDamageSource() != null && event.getDamageSource().func_76346_g() instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)event.getDamageSource().func_76346_g();
            CuriosApi.getCuriosHelper().getCuriosHandler(living).ifPresent(handler -> event.setLootingLevel(event.getLootingLevel() + handler.getLootingBonus()));
        }
    }

    @SubscribeEvent
    public void tick(LivingEvent.LivingUpdateEvent evt) {
        LivingEntity livingEntity = evt.getEntityLiving();
        CuriosApi.getCuriosHelper().getCuriosHandler(livingEntity).ifPresent(handler -> {
            handler.handleInvalidStacks();
            Map<String, ICurioStacksHandler> curios = handler.getCurios();
            int totalFortuneBonus = 0;
            int totalLootingBonus = 0;
            for (Map.Entry<String, ICurioStacksHandler> entry : curios.entrySet()) {
                ICurioStacksHandler stacksHandler = entry.getValue();
                String identifier = entry.getKey();
                IDynamicStackHandler stackHandler = stacksHandler.getStacks();
                IDynamicStackHandler cosmeticStackHandler = stacksHandler.getCosmeticStacks();
                for (int i = 0; i < stackHandler.getSlots(); ++i) {
                    ItemStack prevCosmeticStack;
                    ItemStack cosmeticStack;
                    SlotContext slotContext = new SlotContext(identifier, livingEntity, i);
                    ItemStack stack = stackHandler.getStackInSlot(i);
                    LazyOptional<ICurio> currentCurio = CuriosApi.getCuriosHelper().getCurio(stack);
                    int index = i;
                    if (!stack.func_190926_b()) {
                        stack.func_77945_a(livingEntity.field_70170_p, (Entity)livingEntity, -1, false);
                        currentCurio.ifPresent(curio -> curio.curioTick(identifier, index, livingEntity));
                        if (livingEntity.field_70170_p.field_72995_K) {
                            currentCurio.ifPresent(curio -> curio.curioAnimate(identifier, index, livingEntity));
                        }
                        totalFortuneBonus += currentCurio.map(curio -> curio.getFortuneBonus(identifier, livingEntity, stack, index)).orElse(0).intValue();
                        totalLootingBonus += currentCurio.map(curio -> curio.getLootingBonus(identifier, livingEntity, stack, index)).orElse(0).intValue();
                    }
                    if (livingEntity.field_70170_p.field_72995_K) continue;
                    ItemStack prevStack = stackHandler.getPreviousStackInSlot(i);
                    if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)prevStack)) {
                        LazyOptional<ICurio> prevCurio = CuriosApi.getCuriosHelper().getCurio(prevStack);
                        CuriosEventHandler.syncCurios(livingEntity, stack, currentCurio, prevCurio, identifier, index, SPacketSyncStack.HandlerType.EQUIPMENT);
                        MinecraftForge.EVENT_BUS.post((Event)new CurioChangeEvent(livingEntity, identifier, i, prevStack, stack));
                        UUID uuid = UUID.nameUUIDFromBytes((identifier + i).getBytes());
                        if (!prevStack.func_190926_b()) {
                            livingEntity.func_233645_dx_().func_233785_a_(CuriosApi.getCuriosHelper().getAttributeModifiers(slotContext, uuid, prevStack));
                            prevCurio.ifPresent(curio -> curio.onUnequip(slotContext, stack));
                        }
                        if (!stack.func_190926_b()) {
                            livingEntity.func_233645_dx_().func_233793_b_(CuriosApi.getCuriosHelper().getAttributeModifiers(slotContext, uuid, stack));
                            currentCurio.ifPresent(curio -> curio.onEquip(slotContext, prevStack));
                            if (livingEntity instanceof ServerPlayerEntity) {
                                EquipCurioTrigger.INSTANCE.trigger((ServerPlayerEntity)livingEntity, stack, (ServerWorld)livingEntity.field_70170_p, livingEntity.func_226277_ct_(), livingEntity.func_226278_cu_(), livingEntity.func_226281_cx_());
                            }
                        }
                        stackHandler.setPreviousStackInSlot(i, stack.func_77946_l());
                    }
                    if (ItemStack.func_77989_b((ItemStack)(cosmeticStack = cosmeticStackHandler.getStackInSlot(i)), (ItemStack)(prevCosmeticStack = cosmeticStackHandler.getPreviousStackInSlot(i)))) continue;
                    CuriosEventHandler.syncCurios(livingEntity, cosmeticStack, CuriosApi.getCuriosHelper().getCurio(cosmeticStack), CuriosApi.getCuriosHelper().getCurio(prevCosmeticStack), identifier, index, SPacketSyncStack.HandlerType.COSMETIC);
                    cosmeticStackHandler.setPreviousStackInSlot(index, cosmeticStack.func_77946_l());
                }
            }
            handler.processSlots();
            handler.setEnchantmentBonuses((Tuple<Integer, Integer>)new Tuple((Object)totalFortuneBonus, (Object)totalLootingBonus));
        });
    }

    private static void syncCurios(LivingEntity livingEntity, ItemStack stack, LazyOptional<ICurio> currentCurio, LazyOptional<ICurio> prevCurio, String identifier, int index, SPacketSyncStack.HandlerType type) {
        boolean syncable = currentCurio.map(curio -> curio.canSync(identifier, index, livingEntity)).orElse(false) != false || prevCurio.map(curio -> curio.canSync(identifier, index, livingEntity)).orElse(false) != false;
        CompoundNBT syncTag = syncable ? currentCurio.map(curio -> {
            CompoundNBT tag = curio.writeSyncData();
            return tag != null ? tag : new CompoundNBT();
        }).orElse(new CompoundNBT()) : new CompoundNBT();
        NetworkHandler.INSTANCE.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> livingEntity), (Object)new SPacketSyncStack(livingEntity.func_145782_y(), identifier, index, stack, type, syncTag));
    }
}

