/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.logic;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Arrays;
import java.util.Map;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.channels.Color;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.helper.BaseStringTranslators;
import mekanism.api.chemical.gas.Gas;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.slurry.Slurry;
import mekanism.api.chemical.slurry.SlurryStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import terrails.xnetgases.gas.GasUtils;
import terrails.xnetgases.logic.LogicUtils;
import terrails.xnetgases.logic.XGLogicConnectorSettings;
import terrails.xnetgases.slurry.SlurryUtils;

public class XGSensor {
    public final String TAG_MODE;
    public final String TAG_OPERATOR;
    public final String TAG_AMOUNT;
    public final String TAG_COLOR;
    public final String TAG_FILTER;
    private int amount = 0;
    private SensorMode sensorMode = SensorMode.OFF;
    private Color outputColor = Color.OFF;
    private Operator operator = Operator.EQUAL;
    private ItemStack filter = ItemStack.field_190927_a;

    public XGSensor(int index) {
        String temp = String.format("sensor%s_", index);
        this.TAG_MODE = temp + "mode";
        this.TAG_OPERATOR = temp + "operator";
        this.TAG_AMOUNT = temp + "amount";
        this.TAG_COLOR = temp + "color";
        this.TAG_FILTER = temp + "filter";
    }

    public Color getOutputColor() {
        return this.outputColor;
    }

    public boolean isEnabled(String tag) {
        if (this.TAG_MODE.equals(tag)) {
            return true;
        }
        if (this.TAG_OPERATOR.equals(tag)) {
            return true;
        }
        if (this.TAG_AMOUNT.equals(tag)) {
            return true;
        }
        if (this.TAG_COLOR.equals(tag)) {
            return true;
        }
        if (this.TAG_FILTER.equals(tag)) {
            return this.sensorMode != SensorMode.OFF;
        }
        return false;
    }

    public void createGui(IEditorGui gui) {
        gui.choices(this.TAG_MODE, "Sensor mode", (Enum)this.sensorMode, (Enum[])SensorMode.values()).choices(this.TAG_OPERATOR, "Operator", (Enum)this.operator, (Enum[])Operator.values()).integer(this.TAG_AMOUNT, "Amount to compare with", Integer.valueOf(this.amount), 46).colors(this.TAG_COLOR, "Output color", Integer.valueOf(this.outputColor.getColor()), Color.COLORS).ghostSlot(this.TAG_FILTER, this.filter).nl();
    }

    public boolean test(@Nullable TileEntity te, XGLogicConnectorSettings settings) {
        switch (this.sensorMode) {
            case GAS: {
                return GasUtils.getGasHandlerFor((ICapabilityProvider)te, settings.getFacing()).map(handler -> GasUtils.getGasHandlerFor((ICapabilityProvider)this.filter, null).map(filterHandler -> {
                    if (filterHandler.getTanks() <= 0) {
                        return false;
                    }
                    Gas filterChemical = (Gas)((GasStack)filterHandler.getChemicalInTank(0)).getType();
                    return this.operator.match(GasUtils.getGasCount(handler, settings.getFacing(), filterChemical), this.amount);
                }).orElseGet(() -> this.filter.func_190926_b() && this.operator.match(GasUtils.getGasCount(handler, settings.getFacing()), this.amount))).orElse(false);
            }
            case SLURRY: {
                return SlurryUtils.getSlurryHandlerFor((ICapabilityProvider)te, settings.getFacing()).map(handler -> SlurryUtils.getSlurryHandlerFor((ICapabilityProvider)this.filter, null).map(filterHandler -> {
                    if (filterHandler.getTanks() <= 0) {
                        return false;
                    }
                    Slurry filterChemical = (Slurry)((SlurryStack)filterHandler.getChemicalInTank(0)).getType();
                    return this.operator.match(SlurryUtils.getSlurryCount(handler, settings.getFacing(), filterChemical), this.amount);
                }).orElseGet(() -> this.filter.func_190926_b() && this.operator.match(SlurryUtils.getSlurryCount(handler, settings.getFacing()), this.amount))).orElse(false);
            }
        }
        return false;
    }

    public void update(Map<String, Object> data) {
        this.sensorMode = this.getObjectFromMap(data, this.TAG_MODE, SensorMode.OFF, object -> SensorMode.valueOf(((String)object).toUpperCase()));
        this.operator = this.getObjectFromMap(data, this.TAG_OPERATOR, Operator.EQUAL, object -> Operator.byCode(((String)object).toUpperCase()));
        this.amount = this.getObjectFromMap(data, this.TAG_AMOUNT, 0, Integer.class::cast);
        this.outputColor = this.getObjectFromMap(data, this.TAG_COLOR, Color.OFF, object -> Color.colorByValue((int)((Integer)object)));
        this.filter = this.getObjectFromMap(data, this.TAG_FILTER, ItemStack.field_190927_a, ItemStack.class::cast);
    }

    private <T> T getObjectFromMap(Map<String, Object> data, String key, T defaultValue, Function<Object, T> function) {
        Object object = data.get(key);
        if (object != null) {
            return function.apply(object);
        }
        return defaultValue;
    }

    public void readFromNBT(CompoundNBT tag) {
        this.sensorMode = SensorMode.values()[tag.func_74771_c(this.TAG_MODE)];
        this.operator = Operator.values()[tag.func_74771_c(this.TAG_OPERATOR)];
        this.amount = tag.func_74762_e(this.TAG_AMOUNT);
        this.outputColor = Color.values()[tag.func_74771_c(this.TAG_COLOR)];
        if (tag.func_74764_b(this.TAG_FILTER)) {
            CompoundNBT itemTag = tag.func_74775_l(this.TAG_FILTER);
            this.filter = ItemStack.func_199557_a((CompoundNBT)itemTag);
        } else {
            this.filter = ItemStack.field_190927_a;
        }
    }

    public void writeToNBT(CompoundNBT tag) {
        tag.func_74774_a(this.TAG_MODE, (byte)this.sensorMode.ordinal());
        tag.func_74774_a(this.TAG_OPERATOR, (byte)this.operator.ordinal());
        tag.func_74768_a(this.TAG_AMOUNT, this.amount);
        tag.func_74774_a(this.TAG_COLOR, (byte)this.outputColor.ordinal());
        if (!this.filter.func_190926_b()) {
            CompoundNBT itemTag = new CompoundNBT();
            this.filter.func_77955_b(itemTag);
            tag.func_218657_a(this.TAG_FILTER, (INBT)itemTag);
        }
    }

    public void writeToJson(JsonObject json) {
        json.add(this.TAG_MODE, (JsonElement)new JsonPrimitive(this.sensorMode.name()));
        json.add(this.TAG_COLOR, (JsonElement)new JsonPrimitive(this.outputColor.name()));
        json.add(this.TAG_OPERATOR, (JsonElement)new JsonPrimitive(this.operator.name()));
        json.add(this.TAG_AMOUNT, (JsonElement)new JsonPrimitive((Number)this.amount));
        if (!this.filter.func_190926_b()) {
            json.add("filter", (JsonElement)JSonTools.itemStackToJson((ItemStack)this.filter));
        }
    }

    public void readFromJson(JsonObject json) {
        this.amount = json.has(this.TAG_AMOUNT) ? json.get(this.TAG_AMOUNT).getAsInt() : 0;
        this.operator = json.has(this.TAG_OPERATOR) ? LogicUtils.getOperatorFrom(json.get(this.TAG_OPERATOR).getAsString()) : Operator.EQUAL;
        this.outputColor = json.has(this.TAG_COLOR) ? BaseStringTranslators.getColor((String)json.get(this.TAG_COLOR).getAsString()) : Color.OFF;
        this.sensorMode = json.has(this.TAG_MODE) ? LogicUtils.getSensorModeFrom(json.get(this.TAG_MODE).getAsString()) : SensorMode.OFF;
        this.filter = json.has("filter") ? JSonTools.jsonToItemStack((JsonObject)json.get("filter").getAsJsonObject()) : ItemStack.field_190927_a;
    }

    public static enum Operator {
        EQUAL("=", Long::equals),
        NOTEQUAL("!=", (i1, i2) -> !i1.equals(i2)),
        LESS("<", (i1, i2) -> i1 < i2),
        GREATER(">", (i1, i2) -> i1 > i2),
        LESSOREQUAL("<=", (i1, i2) -> i1 <= i2),
        GREATEROREQUAL(">=", (i1, i2) -> i1 >= i2);

        private final String code;
        private final BiPredicate<Long, Long> matcher;
        private static final Map<String, Operator> OPERATOR_MAP;

        private Operator(String code, BiPredicate<Long, Long> matcher) {
            this.code = code;
            this.matcher = matcher;
        }

        public static Operator byCode(String name) {
            return OPERATOR_MAP.get(name);
        }

        public boolean match(long i1, long i2) {
            return this.matcher.test(i1, i2);
        }

        public String toString() {
            return this.code;
        }

        static {
            OPERATOR_MAP = Arrays.stream(Operator.values()).collect(Collectors.toMap(op -> op.code, op -> op));
        }
    }

    public static enum SensorMode {
        OFF,
        GAS,
        SLURRY;

    }
}

