/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.logic;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import terrails.xnetgases.logic.XGSensor;

public class XGLogicConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final String TAG_MODE = "mode";
    public static final String TAG_SPEED = "speed";
    public static final String TAG_REDSTONE_OUT = "rsout";
    public static final int SENSORS = 4;
    private final List<XGSensor> sensors = new ArrayList<XGSensor>(4);
    private int colors;
    private int speed = 2;
    private static final Set<String> TAGS = ImmutableSet.of((Object)"rsout", (Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object[])new String[]{"color3"});

    public XGLogicConnectorSettings(@Nonnull Direction side) {
        super(side);
        for (int i = 0; i < 4; ++i) {
            this.sensors.add(new XGSensor(i));
        }
    }

    public List<XGSensor> getSensors() {
        return this.sensors;
    }

    public void setColorMask(int colors) {
        this.colors = colors;
    }

    public int getColorMask() {
        return this.colors;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 26, 70, 13, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String tag) {
        if (tag.equals("facing")) {
            return this.advanced;
        }
        if (tag.equals(TAG_SPEED)) {
            return true;
        }
        for (XGSensor sensor : this.sensors) {
            if (!sensor.isEnabled(tag)) continue;
            return true;
        }
        return TAGS.contains(tag);
    }

    public int getSpeed() {
        return this.speed;
    }

    public void createGui(IEditorGui gui) {
        this.advanced = gui.isAdvanced();
        String[] speeds = this.advanced ? new String[]{"5", "10", "20", "60", "100", "200"} : new String[]{"10", "20", "60", "100", "200"};
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices(TAG_SPEED, "Number of ticks for each check", Integer.toString(this.speed * 5), speeds).nl();
        for (XGSensor sensor : this.sensors) {
            sensor.createGui(gui);
        }
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.speed = Integer.parseInt((String)data.get(TAG_SPEED)) / 5;
        if (this.speed == 0) {
            this.speed = 2;
        }
        for (XGSensor sensor : this.sensors) {
            sensor.update(data);
        }
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        XGLogicConnectorSettings.setIntegerSafe((JsonObject)object, (String)TAG_SPEED, (Integer)this.speed);
        JsonArray sensorArray = new JsonArray();
        for (XGSensor sensor : this.sensors) {
            JsonObject o = new JsonObject();
            sensor.writeToJson(o);
            sensorArray.add((JsonElement)o);
        }
        object.add("sensors", (JsonElement)sensorArray);
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.speed = XGLogicConnectorSettings.getIntegerNotNull((JsonObject)object, (String)TAG_SPEED);
        JsonArray sensorArray = object.get("sensors").getAsJsonArray();
        this.sensors.clear();
        for (JsonElement oe : sensorArray) {
            JsonObject o = oe.getAsJsonObject();
            XGSensor sensor = new XGSensor(this.sensors.size());
            sensor.readFromJson(o);
            this.sensors.add(sensor);
        }
    }

    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.speed = tag.func_74762_e(TAG_SPEED);
        if (this.speed == 0) {
            this.speed = 2;
        }
        this.colors = tag.func_74762_e("colors");
        for (XGSensor sensor : this.sensors) {
            sensor.readFromNBT(tag);
        }
    }

    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74768_a(TAG_SPEED, this.speed);
        tag.func_74768_a("colors", this.colors);
        for (XGSensor sensor : this.sensors) {
            sensor.writeToNBT(tag);
        }
    }
}

