/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.logic;

import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import mcjty.lib.varia.WorldTools;
import mcjty.rftoolsbase.api.xnet.channels.IChannelSettings;
import mcjty.rftoolsbase.api.xnet.channels.IControllerContext;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.DefaultChannelSettings;
import mcjty.rftoolsbase.api.xnet.keys.SidedConsumer;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import terrails.xnetgases.logic.XGLogicConnectorSettings;
import terrails.xnetgases.logic.XGSensor;

public class XGLogicChannelSettings
extends DefaultChannelSettings
implements IChannelSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    private int delay = 0;
    private int colors = 0;
    private List<Pair<SidedConsumer, XGLogicConnectorSettings>> sensors = null;

    public JsonObject writeToJson() {
        return new JsonObject();
    }

    public void readFromNBT(CompoundNBT tag) {
        this.delay = tag.func_74762_e("delay");
        this.colors = tag.func_74762_e("colors");
    }

    public void writeToNBT(CompoundNBT tag) {
        tag.func_74768_a("delay", this.delay);
        tag.func_74768_a("colors", this.colors);
    }

    public void tick(int channel, IControllerContext context) {
        --this.delay;
        if (this.delay <= 0) {
            this.delay = 1200;
        }
        if (this.delay % 5 != 0) {
            return;
        }
        int d = this.delay / 5;
        this.updateCache(channel, context);
        World world = context.getControllerWorld();
        this.colors = 0;
        for (Pair<SidedConsumer, XGLogicConnectorSettings> entry : this.sensors) {
            XGLogicConnectorSettings settings = (XGLogicConnectorSettings)((Object)entry.getValue());
            if (d % settings.getSpeed() != 0) {
                this.colors |= settings.getColorMask();
                continue;
            }
            int sensorColors = 0;
            BlockPos connectorPos = context.findConsumerPosition(((SidedConsumer)entry.getKey()).getConsumerId());
            if (connectorPos != null) {
                boolean sense;
                Direction side = ((SidedConsumer)entry.getKey()).getSide();
                BlockPos pos = connectorPos.func_177972_a(side);
                if (!WorldTools.isLoaded((World)world, (BlockPos)pos)) {
                    this.colors |= settings.getColorMask();
                    continue;
                }
                boolean bl = sense = !this.checkRedstone(world, settings, connectorPos);
                if (sense && !context.matchColor(settings.getColorsMask())) {
                    sense = false;
                }
                if (sense) {
                    TileEntity te = world.func_175625_s(pos);
                    for (XGSensor sensor : settings.getSensors()) {
                        if (!sensor.test(te, settings)) continue;
                        sensorColors |= 1 << sensor.getOutputColor().ordinal();
                    }
                }
            }
            settings.setColorMask(sensorColors);
            this.colors |= sensorColors;
        }
    }

    private void updateCache(int channel, IControllerContext context) {
        if (this.sensors == null) {
            this.sensors = new ArrayList<Pair<SidedConsumer, XGLogicConnectorSettings>>();
            context.getConnectors(channel).entrySet().stream().map(entry -> Pair.of(entry.getKey(), (Object)((Object)((XGLogicConnectorSettings)((Object)((Object)entry.getValue())))))).forEach(this.sensors::add);
        }
    }

    public void cleanCache() {
        this.sensors = null;
    }

    public int getColors() {
        return this.colors;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        return new IndicatorIcon(iconGuiElements, 11, 90, 11, 10);
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public boolean isEnabled(String s) {
        return true;
    }

    public void createGui(IEditorGui iEditorGui) {
    }

    public void update(Map<String, Object> map) {
    }
}

