/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.logic;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import terrails.xnetgases.logic.XGSensor;

public class LogicUtils {
    private static Map<String, XGSensor.SensorMode> sensorModeCache;
    private static Map<String, XGSensor.Operator> operatorCache;

    @Nonnull
    public static XGSensor.SensorMode getSensorModeFrom(String s) {
        if (sensorModeCache == null) {
            sensorModeCache = new HashMap<String, XGSensor.SensorMode>();
            for (XGSensor.SensorMode mode : XGSensor.SensorMode.values()) {
                sensorModeCache.put(mode.name(), mode);
            }
        }
        return sensorModeCache.get(s);
    }

    @Nonnull
    public static XGSensor.Operator getOperatorFrom(String s) {
        if (operatorCache == null) {
            operatorCache = new HashMap<String, XGSensor.Operator>();
            for (XGSensor.Operator mode : XGSensor.Operator.values()) {
                operatorCache.put(mode.name(), mode);
            }
        }
        return operatorCache.get(s);
    }
}

