/*
 * Decompiled with CFR 0.152.
 */
package terrails.xnetgases.gas;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.varia.JSonTools;
import mcjty.rftoolsbase.api.xnet.gui.IEditorGui;
import mcjty.rftoolsbase.api.xnet.gui.IndicatorIcon;
import mcjty.rftoolsbase.api.xnet.helper.AbstractConnectorSettings;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.common.capabilities.Capabilities;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import terrails.xnetgases.XNetGases;
import terrails.xnetgases.gas.GasUtils;

public class GasConnectorSettings
extends AbstractConnectorSettings {
    public static final ResourceLocation iconGuiElements = new ResourceLocation("xnet", "textures/gui/guielements.png");
    public static final String TAG_MODE = "mode";
    public static final String TAG_RATE = "rate";
    public static final String TAG_MINMAX = "minmax";
    public static final String TAG_PRIORITY = "priority";
    public static final String TAG_FILTER = "flt";
    public static final String TAG_SPEED = "speed";
    private GasMode gasMode = GasMode.INS;
    @Nullable
    private Integer priority = 0;
    @Nullable
    private Integer rate = null;
    @Nullable
    private Integer minmax = null;
    private int speed = 2;
    private ItemStack filter = ItemStack.field_190927_a;
    private final Set<String> INSERT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority", "flt"});
    private final Set<String> EXTRACT_TAGS = ImmutableSet.of((Object)"mode", (Object)"rs", (Object)"color0", (Object)"color1", (Object)"color2", (Object)"color3", (Object[])new String[]{"rate", "minmax", "priority", "flt", "speed"});

    public GasConnectorSettings(@Nonnull Direction side) {
        super(side);
    }

    public GasMode getGasMode() {
        return this.gasMode;
    }

    public int getSpeed() {
        return this.speed;
    }

    @Nonnull
    public Integer getPriority() {
        return this.priority == null ? 0 : this.priority;
    }

    @Nonnull
    public Integer getRate() {
        return this.rate == null ? (Integer)XNetGases.maxGasRateNormal.get() : this.rate;
    }

    @Nullable
    public Integer getMinmax() {
        return this.minmax;
    }

    @Nullable
    public IndicatorIcon getIndicatorIcon() {
        switch (this.gasMode) {
            case INS: {
                return new IndicatorIcon(iconGuiElements, 0, 70, 13, 10);
            }
            case EXT: {
                return new IndicatorIcon(iconGuiElements, 13, 70, 13, 10);
            }
        }
        return null;
    }

    @Nullable
    public String getIndicator() {
        return null;
    }

    public void createGui(IEditorGui gui) {
        int maxRate;
        String[] speeds;
        this.advanced = gui.isAdvanced();
        if (this.advanced) {
            speeds = new String[]{"10", "20", "60", "100", "200"};
            maxRate = (Integer)XNetGases.maxGasRateAdvanced.get();
        } else {
            speeds = new String[]{"20", "60", "100", "200"};
            maxRate = (Integer)XNetGases.maxGasRateNormal.get();
        }
        this.sideGui(gui);
        this.colorsGui(gui);
        this.redstoneGui(gui);
        gui.nl().choices(TAG_MODE, "Insert or extract mode", (Enum)this.gasMode, (Enum[])GasMode.values()).choices(TAG_SPEED, "Number of ticks for each operation", Integer.toString(this.speed * 10), speeds).nl().label("Pri").integer(TAG_PRIORITY, "Insertion priority", this.priority, 36).nl().label("Rate").integer(TAG_RATE, this.gasMode == GasMode.EXT ? "Gas extraction rate|(max " + maxRate + "mb)" : "Gas insertion rate|(max " + maxRate + "mb)", this.rate, 36, Integer.valueOf(maxRate)).shift(10).label(this.gasMode == GasMode.EXT ? "Min" : "Max").integer(TAG_MINMAX, this.gasMode == GasMode.EXT ? "Keep this amount of|gas in tank" : "Disable insertion if|gas level is too high", this.minmax, 36).nl().label("Filter").ghostSlot(TAG_FILTER, this.filter);
    }

    public boolean isEnabled(String tag) {
        if (this.gasMode == GasMode.INS) {
            if (tag.equals("facing")) {
                return this.advanced;
            }
            return this.INSERT_TAGS.contains(tag);
        }
        if (tag.equals("facing")) {
            return this.advanced;
        }
        return this.EXTRACT_TAGS.contains(tag);
    }

    @Nullable
    public GasStack getMatcher() {
        IGasHandler handler;
        if (!this.filter.func_190926_b() && Capabilities.GAS_HANDLER_CAPABILITY != null && this.filter.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).isPresent() && (handler = (IGasHandler)this.filter.getCapability(Capabilities.GAS_HANDLER_CAPABILITY).orElseThrow(() -> new IllegalArgumentException("IGasHandler Capability doesn't exist!"))).getTanks() > 0) {
            return (GasStack)handler.getChemicalInTank(0);
        }
        return null;
    }

    public void update(Map<String, Object> data) {
        super.update(data);
        this.gasMode = GasMode.valueOf(((String)data.get(TAG_MODE)).toUpperCase());
        this.rate = (Integer)data.get(TAG_RATE);
        this.minmax = (Integer)data.get(TAG_MINMAX);
        this.priority = (Integer)data.get(TAG_PRIORITY);
        this.speed = Integer.parseInt((String)data.get(TAG_SPEED)) / 10;
        if (this.speed == 0) {
            this.speed = 2;
        }
        this.filter = (ItemStack)data.get(TAG_FILTER);
        if (this.filter == null) {
            this.filter = ItemStack.field_190927_a;
        }
    }

    public JsonObject writeToJson() {
        JsonObject object = new JsonObject();
        super.writeToJsonInternal(object);
        GasConnectorSettings.setEnumSafe((JsonObject)object, (String)"gasmode", (Enum)this.gasMode);
        GasConnectorSettings.setIntegerSafe((JsonObject)object, (String)TAG_PRIORITY, (Integer)this.priority);
        GasConnectorSettings.setIntegerSafe((JsonObject)object, (String)TAG_RATE, (Integer)this.rate);
        GasConnectorSettings.setIntegerSafe((JsonObject)object, (String)TAG_MINMAX, (Integer)this.minmax);
        GasConnectorSettings.setIntegerSafe((JsonObject)object, (String)TAG_SPEED, (Integer)this.speed);
        if (!this.filter.func_190926_b()) {
            object.add("filter", (JsonElement)JSonTools.itemStackToJson((ItemStack)this.filter));
        }
        if (this.rate != null && this.rate > (Integer)XNetGases.maxGasRateNormal.get()) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        if (this.speed == 1) {
            object.add("advancedneeded", (JsonElement)new JsonPrimitive(Boolean.valueOf(true)));
        }
        return object;
    }

    public void readFromJson(JsonObject object) {
        super.readFromJsonInternal(object);
        this.gasMode = (GasMode)GasConnectorSettings.getEnumSafe((JsonObject)object, (String)"gasmode", GasUtils::getConnectorModeFrom);
        this.priority = GasConnectorSettings.getIntegerSafe((JsonObject)object, (String)TAG_PRIORITY);
        this.rate = GasConnectorSettings.getIntegerSafe((JsonObject)object, (String)TAG_RATE);
        this.minmax = GasConnectorSettings.getIntegerSafe((JsonObject)object, (String)TAG_MINMAX);
        this.speed = GasConnectorSettings.getIntegerNotNull((JsonObject)object, (String)TAG_SPEED);
        this.filter = object.has("filter") ? JSonTools.jsonToItemStack((JsonObject)object.get("filter").getAsJsonObject()) : ItemStack.field_190927_a;
    }

    public void readFromNBT(CompoundNBT tag) {
        super.readFromNBT(tag);
        this.gasMode = GasMode.values()[tag.func_74771_c("gasMode")];
        this.priority = tag.func_74764_b(TAG_PRIORITY) ? Integer.valueOf(tag.func_74762_e(TAG_PRIORITY)) : null;
        this.rate = tag.func_74764_b(TAG_RATE) ? Integer.valueOf(tag.func_74762_e(TAG_RATE)) : null;
        this.minmax = tag.func_74764_b(TAG_MINMAX) ? Integer.valueOf(tag.func_74762_e(TAG_MINMAX)) : null;
        this.speed = tag.func_74762_e(TAG_SPEED);
        if (this.speed == 0) {
            this.speed = 2;
        }
        if (tag.func_74764_b("filter")) {
            CompoundNBT itemTag = tag.func_74775_l("filter");
            this.filter = ItemStack.func_199557_a((CompoundNBT)itemTag);
        } else {
            this.filter = ItemStack.field_190927_a;
        }
    }

    public void writeToNBT(CompoundNBT tag) {
        super.writeToNBT(tag);
        tag.func_74774_a("gasMode", (byte)this.gasMode.ordinal());
        if (this.priority != null) {
            tag.func_74768_a(TAG_PRIORITY, this.priority.intValue());
        }
        if (this.rate != null) {
            tag.func_74768_a(TAG_RATE, this.rate.intValue());
        }
        if (this.minmax != null) {
            tag.func_74768_a(TAG_MINMAX, this.minmax.intValue());
        }
        tag.func_74768_a(TAG_SPEED, this.speed);
        if (!this.filter.func_190926_b()) {
            CompoundNBT itemTag = new CompoundNBT();
            this.filter.func_77955_b(itemTag);
            tag.func_218657_a("filter", (INBT)itemTag);
        }
    }

    public static enum GasMode {
        INS,
        EXT;

    }
}

