/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.terminal;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.EquatableItemStack;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.NetworkItem;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.packets.PacketGhostSlot;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalTileEntity;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import org.apache.commons.lang3.mutable.MutableInt;

public class CraftingTerminalTileEntity
extends ItemTerminalTileEntity {
    public final ItemStackHandler craftItems = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            for (PlayerEntity playerEntity : CraftingTerminalTileEntity.this.getLookingPlayers()) {
                playerEntity.field_71070_bA.func_75130_a(null);
            }
        }
    };
    public final ItemStackHandler ghostItems = new ItemStackHandler(9);

    public CraftingTerminalTileEntity() {
        super(Registry.craftingTerminalTileEntity);
    }

    public ItemStack getRequestedCraftItem(int slot) {
        ItemStack stack = this.craftItems.getStackInSlot(slot);
        if (!stack.func_190926_b()) {
            return stack;
        }
        return this.ghostItems.getStackInSlot(slot);
    }

    public boolean isGhostItem(int slot) {
        return this.craftItems.getStackInSlot(slot).func_190926_b() && !this.ghostItems.getStackInSlot(slot).func_190926_b();
    }

    public void setGhostItems(ListMultimap<Integer, ItemStack> stacks) {
        this.updateItems(new PlayerEntity[0]);
        for (int i = 0; i < this.ghostItems.getSlots(); ++i) {
            List items = stacks.get((Object)i);
            if (items.isEmpty()) {
                this.ghostItems.setStackInSlot(i, ItemStack.field_190927_a);
                continue;
            }
            ItemStack toSet = (ItemStack)items.get(0);
            if (items.size() > 1) {
                int highestAmount = 0;
                for (ItemStack stack : items) {
                    PipeTileEntity pipe;
                    int amount = 0;
                    NetworkItem network = (NetworkItem)this.networkItems.get(new EquatableItemStack(stack, ItemEquality.NBT));
                    if (network != null) {
                        amount = network.getLocations().stream().mapToInt(l -> l.getItemAmount(this.field_145850_b, stack, ItemEquality.NBT)).sum();
                    }
                    if (amount <= 0 && highestAmount <= 0 && (pipe = this.getConnectedPipe()) != null) {
                        amount = PipeNetwork.get(this.field_145850_b).getCraftableAmount(pipe.func_174877_v(), null, stack, new Stack<ItemStack>(), ItemEquality.NBT);
                    }
                    if (amount <= highestAmount) continue;
                    highestAmount = amount;
                    toSet = stack;
                }
            }
            this.ghostItems.setStackInSlot(i, toSet.func_77946_l());
        }
        if (!this.field_145850_b.field_72995_K) {
            ArrayListMultimap clients = ArrayListMultimap.create();
            for (int i = 0; i < this.ghostItems.getSlots(); ++i) {
                clients.put((Object)i, (Object)this.ghostItems.getStackInSlot(i));
            }
            PacketHandler.sendToAllLoaded(this.field_145850_b, this.field_174879_c, new PacketGhostSlot(this.field_174879_c, (ListMultimap<Integer, ItemStack>)clients));
        }
    }

    public void requestCraftingItems(PlayerEntity player, int maxAmount) {
        PipeTileEntity pipe = this.getConnectedPipe();
        if (pipe == null) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(this.field_145850_b);
        network.startProfile("terminal_request_crafting");
        this.updateItems(new PlayerEntity[0]);
        int lowestAvailable = CraftingTerminalTileEntity.getAvailableCrafts(pipe, this.craftItems.getSlots(), i -> ItemHandlerHelper.copyStackWithSize((ItemStack)this.getRequestedCraftItem((int)i), (int)1), this::isGhostItem, s -> {
            NetworkItem item = (NetworkItem)this.networkItems.get(s);
            return item != null ? item.getLocations() : Collections.emptyList();
        }, CraftingTerminalTileEntity.onItemUnavailable(player), new Stack<ItemStack>(), ItemEquality.NBT);
        if (lowestAvailable > 0) {
            if (maxAmount < lowestAvailable) {
                lowestAvailable = maxAmount;
            }
            for (int i2 = 0; i2 < this.craftItems.getSlots(); ++i2) {
                ItemStack requested = this.getRequestedCraftItem(i2);
                if (requested.func_190926_b()) continue;
                requested = requested.func_77946_l();
                requested.func_190920_e(lowestAvailable);
                this.requestItemImpl(requested, CraftingTerminalTileEntity.onItemUnavailable(player));
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("info.prettypipes.sending_ingredients", new Object[]{lowestAvailable}).func_230530_a_(Style.field_240709_b_.func_240712_a_(TextFormatting.GREEN)), UUID.randomUUID());
        }
        network.endProfile();
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_218657_a("craft_items", (INBT)this.craftItems.serializeNBT());
        return super.func_189515_b(compound);
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        this.craftItems.deserializeNBT(compound.func_74775_l("craft_items"));
        super.func_230337_a_(state, compound);
    }

    @Override
    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent("container.prettypipes.crafting_terminal");
    }

    @Override
    @Nullable
    public Container createMenu(int window, PlayerInventory inv, PlayerEntity player) {
        return new CraftingTerminalContainer(Registry.craftingTerminalContainer, window, player, this.field_174879_c);
    }

    @Override
    public ItemStack insertItem(BlockPos pipePos, Direction direction, ItemStack remain, boolean simulate) {
        BlockPos pos = pipePos.func_177972_a(direction);
        CraftingTerminalTileEntity tile = Utility.getTileEntity(CraftingTerminalTileEntity.class, (IBlockReader)this.field_145850_b, pos);
        if (tile != null) {
            remain = remain.func_77946_l();
            int lowestSlot = -1;
            do {
                for (int i = 0; i < tile.craftItems.getSlots(); ++i) {
                    int count;
                    ItemStack stack = tile.getRequestedCraftItem(i);
                    int n = count = tile.isGhostItem(i) ? 0 : stack.func_190916_E();
                    if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)remain) || !stack.func_77985_e() && count >= 1 || lowestSlot >= 0 && (tile.isGhostItem(lowestSlot) || count >= tile.getRequestedCraftItem(lowestSlot).func_190916_E())) continue;
                    lowestSlot = i;
                }
                if (lowestSlot < 0) continue;
                ItemStack copy = remain.func_77946_l();
                copy.func_190920_e(1);
                if (tile.craftItems.insertItem(lowestSlot, copy, simulate).func_190916_E() > 0) break;
                remain.func_190918_g(1);
                if (!remain.func_190926_b()) continue;
                return ItemStack.field_190927_a;
            } while (lowestSlot >= 0);
            return ItemHandlerHelper.insertItemStacked((IItemHandler)tile.items, (ItemStack)remain, (boolean)simulate);
        }
        return remain;
    }

    public static int getAvailableCrafts(PipeTileEntity tile, int slots, Function<Integer, ItemStack> inputFunction, Predicate<Integer> isGhost, Function<EquatableItemStack, Collection<NetworkLocation>> locationsFunction, Consumer<ItemStack> unavailableConsumer, Stack<ItemStack> dependencyChain, ItemEquality ... equalityTypes) {
        PipeNetwork network = PipeNetwork.get(tile.func_145831_w());
        int lowestAvailable = Integer.MAX_VALUE;
        HashMap<EquatableItemStack, MutableInt> requiredItems = new HashMap<EquatableItemStack, MutableInt>();
        for (int i = 0; i < slots; ++i) {
            ItemStack requested = inputFunction.apply(i);
            if (requested.func_190926_b()) continue;
            MutableInt amount = requiredItems.computeIfAbsent(new EquatableItemStack(requested, equalityTypes), s -> new MutableInt());
            amount.add(requested.func_190916_E());
            int fit = Math.max(requested.func_77976_d() - (isGhost.test(i) ? 0 : requested.func_190916_E()), 1);
            if (lowestAvailable <= fit) continue;
            lowestAvailable = fit;
        }
        for (Map.Entry entry : requiredItems.entrySet()) {
            int craftable;
            EquatableItemStack stack = (EquatableItemStack)entry.getKey();
            int available = 0;
            for (NetworkLocation location : locationsFunction.apply(stack)) {
                int amount = location.getItemAmount(tile.func_145831_w(), stack.stack, equalityTypes);
                if (amount <= 0) continue;
                available += (amount -= network.getLockedAmount(location.getPos(), stack.stack, null, equalityTypes));
            }
            if ((available /= ((MutableInt)entry.getValue()).intValue()) < lowestAvailable && (craftable = network.getCraftableAmount(tile.func_174877_v(), unavailableConsumer, stack.stack, dependencyChain, equalityTypes)) > 0) {
                available += craftable / ((MutableInt)entry.getValue()).intValue();
            }
            if (available < lowestAvailable) {
                lowestAvailable = available;
            }
            if (available > 0 || unavailableConsumer == null) continue;
            unavailableConsumer.accept(stack.stack);
        }
        return lowestAvailable;
    }
}

