/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class PacketNetworkItems {
    private List<ItemStack> items;
    private List<ItemStack> craftables;
    private List<ItemStack> currentlyCrafting;

    public PacketNetworkItems(List<ItemStack> items, List<ItemStack> craftables, List<ItemStack> currentlyCrafting) {
        this.items = items;
        this.craftables = craftables;
        this.currentlyCrafting = currentlyCrafting;
    }

    private PacketNetworkItems() {
    }

    public static PacketNetworkItems fromBytes(PacketBuffer buf) {
        int i;
        PacketNetworkItems client = new PacketNetworkItems();
        client.items = new ArrayList<ItemStack>();
        for (i = buf.func_150792_a(); i > 0; --i) {
            ItemStack stack = buf.func_150791_c();
            stack.func_190920_e(buf.func_150792_a());
            client.items.add(stack);
        }
        client.craftables = new ArrayList<ItemStack>();
        for (i = buf.func_150792_a(); i > 0; --i) {
            client.craftables.add(buf.func_150791_c());
        }
        client.currentlyCrafting = new ArrayList<ItemStack>();
        for (i = buf.func_150792_a(); i > 0; --i) {
            client.currentlyCrafting.add(buf.func_150791_c());
        }
        return client;
    }

    public static void toBytes(PacketNetworkItems packet, PacketBuffer buf) {
        buf.func_150787_b(packet.items.size());
        for (ItemStack stack : packet.items) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            buf.func_150788_a(copy);
            buf.func_150787_b(stack.func_190916_E());
        }
        buf.func_150787_b(packet.craftables.size());
        for (ItemStack stack : packet.craftables) {
            buf.func_150788_a(stack);
        }
        buf.func_150787_b(packet.currentlyCrafting.size());
        for (ItemStack stack : packet.currentlyCrafting) {
            buf.func_150788_a(stack);
        }
    }

    public static void onMessage(final PacketNetworkItems message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                Minecraft mc = Minecraft.func_71410_x();
                if (mc.field_71462_r instanceof ItemTerminalGui) {
                    ((ItemTerminalGui)mc.field_71462_r).updateItemList(message.items, message.craftables, message.currentlyCrafting);
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

