/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class PacketCraftingModuleTransfer {
    private List<ItemStack> inputs;
    private List<ItemStack> outputs;

    public PacketCraftingModuleTransfer(List<ItemStack> inputs, List<ItemStack> outputs) {
        this.inputs = inputs;
        this.outputs = outputs;
    }

    private PacketCraftingModuleTransfer() {
    }

    public static PacketCraftingModuleTransfer fromBytes(PacketBuffer buf) {
        int i;
        PacketCraftingModuleTransfer packet = new PacketCraftingModuleTransfer();
        packet.inputs = new ArrayList<ItemStack>();
        for (i = buf.readInt(); i > 0; --i) {
            packet.inputs.add(buf.func_150791_c());
        }
        packet.outputs = new ArrayList<ItemStack>();
        for (i = buf.readInt(); i > 0; --i) {
            packet.outputs.add(buf.func_150791_c());
        }
        return packet;
    }

    public static void toBytes(PacketCraftingModuleTransfer packet, PacketBuffer buf) {
        buf.writeInt(packet.inputs.size());
        for (ItemStack stack : packet.inputs) {
            buf.func_150788_a(stack);
        }
        buf.writeInt(packet.outputs.size());
        for (ItemStack stack : packet.outputs) {
            buf.func_150788_a(stack);
        }
    }

    public static void onMessage(final PacketCraftingModuleTransfer message, final Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(new Runnable(){

            @Override
            public void run() {
                ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
                if (player.field_71070_bA instanceof CraftingModuleContainer) {
                    CraftingModuleContainer container = (CraftingModuleContainer)player.field_71070_bA;
                    PacketCraftingModuleTransfer.copy(container.input, message.inputs);
                    PacketCraftingModuleTransfer.copy(container.output, message.outputs);
                    container.modified = true;
                    container.func_75142_b();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }

    private static void copy(ItemStackHandler container, List<ItemStack> contents) {
        for (int i = 0; i < container.getSlots(); ++i) {
            container.setStackInSlot(i, ItemStack.field_190927_a);
        }
        for (ItemStack stack : contents) {
            ItemHandlerHelper.insertItem((IItemHandler)container, (ItemStack)stack, (boolean)false);
        }
    }
}

