/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Streams;
import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.network.NetworkEdge;
import de.ellpeck.prettypipes.network.NetworkLocation;
import de.ellpeck.prettypipes.network.NetworkLock;
import de.ellpeck.prettypipes.network.PipeItem;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.packets.PacketItemEnterPipe;
import de.ellpeck.prettypipes.pipe.ConnectionType;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Stack;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import org.apache.commons.lang3.tuple.Pair;
import org.jgrapht.GraphPath;
import org.jgrapht.ListenableGraph;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.alg.shortestpath.DijkstraShortestPath;
import org.jgrapht.event.GraphEdgeChangeEvent;
import org.jgrapht.event.GraphListener;
import org.jgrapht.event.GraphVertexChangeEvent;
import org.jgrapht.graph.DefaultListenableGraph;
import org.jgrapht.graph.SimpleWeightedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;

public class PipeNetwork
implements ICapabilitySerializable<CompoundNBT>,
GraphListener<BlockPos, NetworkEdge> {
    public final ListenableGraph<BlockPos, NetworkEdge> graph;
    private final DijkstraShortestPath<BlockPos, NetworkEdge> dijkstra;
    private final Map<BlockPos, List<BlockPos>> nodeToConnectedNodes = new HashMap<BlockPos, List<BlockPos>>();
    private final Map<BlockPos, PipeTileEntity> tileCache = new HashMap<BlockPos, PipeTileEntity>();
    private final ListMultimap<BlockPos, IPipeItem> pipeItems = ArrayListMultimap.create();
    private final ListMultimap<BlockPos, NetworkLock> networkLocks = ArrayListMultimap.create();
    private final World world;
    private final LazyOptional<PipeNetwork> lazyThis = LazyOptional.of(() -> this);

    public PipeNetwork(World world) {
        this.world = world;
        this.graph = new DefaultListenableGraph<BlockPos, NetworkEdge>(new SimpleWeightedGraph(NetworkEdge.class));
        this.graph.addGraphListener(this);
        this.dijkstra = new DijkstraShortestPath<BlockPos, NetworkEdge>(this.graph);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == Registry.pipeNetworkCapability ? this.lazyThis.cast() : LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        ListNBT nodes = new ListNBT();
        for (BlockPos node : this.graph.vertexSet()) {
            nodes.add((Object)NBTUtil.func_186859_a((BlockPos)node));
        }
        nbt.func_218657_a("nodes", (INBT)nodes);
        ListNBT edges = new ListNBT();
        for (NetworkEdge edge : this.graph.edgeSet()) {
            edges.add((Object)edge.serializeNBT());
        }
        nbt.func_218657_a("edges", (INBT)edges);
        nbt.func_218657_a("items", (INBT)Utility.serializeAll(this.pipeItems.values()));
        nbt.func_218657_a("locks", (INBT)Utility.serializeAll(this.networkLocks.values()));
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.graph.removeAllVertices(new ArrayList(this.graph.vertexSet()));
        this.pipeItems.clear();
        this.networkLocks.clear();
        ListNBT nodes = nbt.func_150295_c("nodes", 10);
        for (int i = 0; i < nodes.size(); ++i) {
            this.graph.addVertex(NBTUtil.func_186861_c((CompoundNBT)nodes.func_150305_b(i)));
        }
        ListNBT edges = nbt.func_150295_c("edges", 10);
        for (int i = 0; i < edges.size(); ++i) {
            this.addEdge(new NetworkEdge(edges.func_150305_b(i)));
        }
        for (IPipeItem item : Utility.deserializeAll(nbt.func_150295_c("items", 10), IPipeItem::load)) {
            this.pipeItems.put((Object)item.getCurrentPipe(), (Object)item);
        }
        for (NetworkLock lock : Utility.deserializeAll(nbt.func_150295_c("locks", 10), NetworkLock::new)) {
            this.createNetworkLock(lock);
        }
    }

    public void addNode(BlockPos pos, BlockState state) {
        if (!this.isNode(pos)) {
            this.graph.addVertex(pos);
            this.refreshNode(pos, state);
        }
    }

    public void removeNode(BlockPos pos) {
        if (this.isNode(pos)) {
            this.graph.removeVertex(pos);
        }
    }

    public boolean isNode(BlockPos pos) {
        return this.graph.containsVertex(pos);
    }

    public void onPipeChanged(BlockPos pos, BlockState state) {
        List<NetworkEdge> neighbors = this.createAllEdges(pos, state, true);
        if (neighbors.size() <= 1 && !this.isNode(pos)) {
            return;
        }
        for (NetworkEdge edge : neighbors) {
            BlockPos end = edge.getEndPipe();
            this.refreshNode(end, this.world.func_180495_p(end));
        }
    }

    public ItemStack routeItem(BlockPos startPipePos, BlockPos startInventory, ItemStack stack, boolean preventOversending) {
        return this.routeItem(startPipePos, startInventory, stack, PipeItem::new, preventOversending);
    }

    public ItemStack routeItem(BlockPos startPipePos, BlockPos startInventory, ItemStack stack, BiFunction<ItemStack, Float, IPipeItem> itemSupplier, boolean preventOversending) {
        if (!this.isNode(startPipePos)) {
            return stack;
        }
        if (!this.world.func_175667_e(startPipePos)) {
            return stack;
        }
        PipeTileEntity startPipe = this.getPipe(startPipePos);
        if (startPipe == null) {
            return stack;
        }
        this.startProfile("find_destination");
        List<BlockPos> nodes = this.getOrderedNetworkNodes(startPipePos);
        for (int i = 0; i < nodes.size(); ++i) {
            PipeTileEntity pipe;
            Pair<BlockPos, ItemStack> dest;
            BlockPos pipePos = nodes.get(startPipe.getNextNode(nodes, i));
            if (!this.world.func_175667_e(pipePos) || (dest = (pipe = this.getPipe(pipePos)).getAvailableDestination(stack, false, preventOversending)) == null || ((BlockPos)dest.getLeft()).equals((Object)startInventory)) continue;
            Function<Float, IPipeItem> sup = speed -> (IPipeItem)itemSupplier.apply((ItemStack)dest.getRight(), (Float)speed);
            if (!this.routeItemToLocation(startPipePos, startInventory, pipe.func_174877_v(), (BlockPos)dest.getLeft(), (ItemStack)dest.getRight(), sup)) continue;
            ItemStack remain = stack.func_77946_l();
            remain.func_190918_g(((ItemStack)dest.getRight()).func_190916_E());
            this.endProfile();
            return remain;
        }
        this.endProfile();
        return stack;
    }

    public boolean routeItemToLocation(BlockPos startPipePos, BlockPos startInventory, BlockPos destPipePos, BlockPos destInventory, ItemStack stack, Function<Float, IPipeItem> itemSupplier) {
        if (!this.isNode(startPipePos) || !this.isNode(destPipePos)) {
            return false;
        }
        if (!this.world.func_175667_e(startPipePos) || !this.world.func_175667_e(destPipePos)) {
            return false;
        }
        PipeTileEntity startPipe = this.getPipe(startPipePos);
        if (startPipe == null) {
            return false;
        }
        this.startProfile("get_path");
        GraphPath<BlockPos, NetworkEdge> path = this.dijkstra.getPath(startPipePos, destPipePos);
        this.endProfile();
        if (path == null) {
            return false;
        }
        IPipeItem item = itemSupplier.apply(Float.valueOf(startPipe.getItemSpeed(stack)));
        item.setDestination(startInventory, destInventory, path);
        startPipe.addNewItem(item);
        PacketHandler.sendToAllLoaded(this.world, startPipePos, new PacketItemEnterPipe(startPipePos, item));
        return true;
    }

    public ItemStack requestItem(BlockPos destPipe, BlockPos destInventory, ItemStack stack, ItemEquality ... equalityTypes) {
        ItemStack remain = stack.func_77946_l();
        for (NetworkLocation location : this.getOrderedNetworkItems(destPipe)) {
            remain = this.requestExistingItem(location, destPipe, destInventory, null, remain, equalityTypes);
            if (!remain.func_190926_b()) continue;
            return remain;
        }
        return this.requestCraftedItem(destPipe, null, remain, new Stack<ItemStack>(), equalityTypes);
    }

    public ItemStack requestCraftedItem(BlockPos destPipe, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain, ItemEquality ... equalityTypes) {
        PipeTileEntity pipe;
        Pair<BlockPos, ItemStack> craftable;
        Iterator<Pair<BlockPos, ItemStack>> iterator = this.getAllCraftables(destPipe).iterator();
        while (!(!iterator.hasNext() || ItemEquality.compareItems(stack, (ItemStack)(craftable = iterator.next()).getRight(), equalityTypes) && (pipe = this.getPipe((BlockPos)craftable.getLeft())) != null && (stack = pipe.craft(destPipe, unavailableConsumer, stack, dependencyChain)).func_190926_b())) {
        }
        return stack;
    }

    public ItemStack requestExistingItem(NetworkLocation location, BlockPos destPipe, BlockPos destInventory, NetworkLock ignoredLock, ItemStack stack, ItemEquality ... equalityTypes) {
        return this.requestExistingItem(location, destPipe, destInventory, ignoredLock, PipeItem::new, stack, equalityTypes);
    }

    public ItemStack requestExistingItem(NetworkLocation location, BlockPos destPipe, BlockPos destInventory, NetworkLock ignoredLock, BiFunction<ItemStack, Float, IPipeItem> itemSupplier, ItemStack stack, ItemEquality ... equalityTypes) {
        if (location.getPos().equals((Object)destInventory)) {
            return stack;
        }
        int amount = location.getItemAmount(this.world, stack, equalityTypes);
        if (amount <= 0) {
            return stack;
        }
        if ((amount -= this.getLockedAmount(location.getPos(), stack, ignoredLock, equalityTypes)) <= 0) {
            return stack;
        }
        ItemStack remain = stack.func_77946_l();
        if (remain.func_190916_E() < amount) {
            amount = remain.func_190916_E();
        }
        remain.func_190918_g(amount);
        for (int slot : location.getStackSlots(this.world, stack, equalityTypes)) {
            IItemHandler handler = location.getItemHandler(this.world);
            ItemStack extracted = handler.extractItem(slot, amount, true);
            if (!this.routeItemToLocation(location.pipePos, location.getPos(), destPipe, destInventory, extracted, speed -> (IPipeItem)itemSupplier.apply(extracted, (Float)speed))) continue;
            handler.extractItem(slot, extracted.func_190916_E(), false);
            if ((amount -= extracted.func_190916_E()) > 0) continue;
            break;
        }
        return remain;
    }

    public PipeTileEntity getPipe(BlockPos pos) {
        PipeTileEntity tile = this.tileCache.get(pos);
        if (tile == null || tile.func_145837_r()) {
            tile = Utility.getTileEntity(PipeTileEntity.class, (IBlockReader)this.world, pos);
            this.tileCache.put(pos, tile);
        }
        return tile;
    }

    public void uncachePipe(BlockPos pos) {
        this.tileCache.remove(pos);
    }

    public List<Pair<BlockPos, ItemStack>> getCurrentlyCrafting(BlockPos node, ItemEquality ... equalityTypes) {
        this.startProfile("get_currently_crafting");
        ArrayList<Pair<BlockPos, ItemStack>> items = new ArrayList<Pair<BlockPos, ItemStack>>();
        Iterator craftingPipes = this.getAllCraftables(node).stream().map(c -> this.getPipe((BlockPos)c.getLeft())).distinct().iterator();
        while (craftingPipes.hasNext()) {
            PipeTileEntity pipe = (PipeTileEntity)craftingPipes.next();
            for (Pair<BlockPos, ItemStack> request : pipe.craftResultRequests) {
                BlockPos dest = (BlockPos)request.getLeft();
                ItemStack stack = (ItemStack)request.getRight();
                Optional<Pair> existing = items.stream().filter(s -> ((BlockPos)s.getLeft()).equals((Object)dest) && ItemEquality.compareItems((ItemStack)s.getRight(), stack, equalityTypes)).findFirst();
                if (existing.isPresent()) {
                    ((ItemStack)existing.get().getRight()).func_190917_f(stack.func_190916_E());
                    continue;
                }
                items.add((Pair<BlockPos, ItemStack>)Pair.of((Object)dest, (Object)stack.func_77946_l()));
            }
        }
        this.endProfile();
        return items;
    }

    public int getCurrentlyCraftingAmount(BlockPos destNode, ItemStack stack, ItemEquality ... equalityTypes) {
        return this.getCurrentlyCrafting(destNode, new ItemEquality[0]).stream().filter(p -> ((BlockPos)p.getLeft()).equals((Object)destNode) && ItemEquality.compareItems((ItemStack)p.getRight(), stack, equalityTypes)).mapToInt(p -> ((ItemStack)p.getRight()).func_190916_E()).sum();
    }

    public List<Pair<BlockPos, ItemStack>> getAllCraftables(BlockPos node) {
        if (!this.isNode(node)) {
            return Collections.emptyList();
        }
        this.startProfile("get_all_craftables");
        ArrayList<Pair<BlockPos, ItemStack>> craftables = new ArrayList<Pair<BlockPos, ItemStack>>();
        for (BlockPos dest : this.getOrderedNetworkNodes(node)) {
            if (!this.world.func_175667_e(dest)) continue;
            PipeTileEntity pipe = this.getPipe(dest);
            for (ItemStack stack : pipe.getAllCraftables()) {
                craftables.add((Pair<BlockPos, ItemStack>)Pair.of((Object)pipe.func_174877_v(), (Object)stack));
            }
        }
        this.endProfile();
        return craftables;
    }

    public int getCraftableAmount(BlockPos node, Consumer<ItemStack> unavailableConsumer, ItemStack stack, Stack<ItemStack> dependencyChain, ItemEquality ... equalityTypes) {
        int total = 0;
        for (Pair<BlockPos, ItemStack> pair : this.getAllCraftables(node)) {
            PipeTileEntity pipe;
            if (!ItemEquality.compareItems((ItemStack)pair.getRight(), stack, equalityTypes) || !this.world.func_175667_e((BlockPos)pair.getLeft()) || (pipe = this.getPipe((BlockPos)pair.getLeft())) == null) continue;
            total += pipe.getCraftableAmount(unavailableConsumer, stack, dependencyChain);
        }
        return total;
    }

    public List<NetworkLocation> getOrderedNetworkItems(BlockPos node) {
        if (!this.isNode(node)) {
            return Collections.emptyList();
        }
        this.startProfile("get_network_items");
        ArrayList<NetworkLocation> info = new ArrayList<NetworkLocation>();
        for (BlockPos dest : this.getOrderedNetworkNodes(node)) {
            PipeTileEntity pipe;
            if (!this.world.func_175667_e(dest) || !(pipe = this.getPipe(dest)).canNetworkSee()) continue;
            for (Direction dir : Direction.values()) {
                NetworkLocation location;
                IItemHandler handler = pipe.getItemHandler(dir);
                if (handler == null || info.stream().anyMatch(l -> handler.equals(l.getItemHandler(this.world))) || (location = new NetworkLocation(dest, dir)).isEmpty(this.world)) continue;
                info.add(location);
            }
        }
        this.endProfile();
        return info;
    }

    public void createNetworkLock(NetworkLock lock) {
        this.networkLocks.put((Object)lock.location.getPos(), (Object)lock);
    }

    public void resolveNetworkLock(NetworkLock lock) {
        this.networkLocks.remove((Object)lock.location.getPos(), (Object)lock);
    }

    public List<NetworkLock> getNetworkLocks(BlockPos pos) {
        return this.networkLocks.get((Object)pos);
    }

    public int getLockedAmount(BlockPos pos, ItemStack stack, NetworkLock ignoredLock, ItemEquality ... equalityTypes) {
        return this.getNetworkLocks(pos).stream().filter(l -> !l.equals(ignoredLock) && ItemEquality.compareItems(l.stack, stack, equalityTypes)).mapToInt(l -> l.stack.func_190916_E()).sum();
    }

    private void refreshNode(BlockPos pos, BlockState state) {
        this.startProfile("refresh_node");
        this.graph.removeAllEdges(new ArrayList(this.graph.edgesOf(pos)));
        for (NetworkEdge edge : this.createAllEdges(pos, state, false)) {
            this.addEdge(edge);
        }
        this.endProfile();
    }

    private void addEdge(NetworkEdge edge) {
        this.graph.addEdge(edge.getStartPipe(), edge.getEndPipe(), edge);
        this.graph.setEdgeWeight(edge, edge.pipes.size() - 1);
    }

    public BlockPos getNodeFromPipe(BlockPos pos) {
        if (this.isNode(pos)) {
            return pos;
        }
        BlockState state = this.world.func_180495_p(pos);
        if (!(state.func_177230_c() instanceof PipeBlock)) {
            return null;
        }
        for (Direction dir : Direction.values()) {
            NetworkEdge edge = this.createEdge(pos, state, dir, false);
            if (edge == null) continue;
            return edge.getEndPipe();
        }
        return null;
    }

    private List<NetworkEdge> createAllEdges(BlockPos pos, BlockState state, boolean ignoreCurrBlocked) {
        this.startProfile("create_all_edges");
        ArrayList<NetworkEdge> edges = new ArrayList<NetworkEdge>();
        for (Direction dir : Direction.values()) {
            NetworkEdge edge = this.createEdge(pos, state, dir, ignoreCurrBlocked);
            if (edge == null) continue;
            edges.add(edge);
        }
        this.endProfile();
        return edges;
    }

    private NetworkEdge createEdge(BlockPos pos, BlockState state, Direction dir, boolean ignoreCurrBlocked) {
        boolean found;
        if (!ignoreCurrBlocked && !((ConnectionType)((Object)state.func_177229_b((Property)PipeBlock.DIRECTIONS.get(dir)))).isConnected()) {
            return null;
        }
        BlockPos currPos = pos.func_177972_a(dir);
        BlockState currState = this.world.func_180495_p(currPos);
        if (!(currState.func_177230_c() instanceof PipeBlock)) {
            return null;
        }
        this.startProfile("create_edge");
        NetworkEdge edge = new NetworkEdge();
        edge.pipes.add(pos);
        edge.pipes.add(currPos);
        block0: do {
            if (this.isNode(currPos)) {
                this.endProfile();
                return edge;
            }
            found = false;
            for (Direction nextDir : Direction.values()) {
                BlockPos offset;
                BlockState offState;
                if (!((ConnectionType)((Object)currState.func_177229_b((Property)PipeBlock.DIRECTIONS.get(nextDir)))).isConnected() || !((offState = this.world.func_180495_p(offset = currPos.func_177972_a(nextDir))).func_177230_c() instanceof PipeBlock) || edge.pipes.contains(offset)) continue;
                edge.pipes.add(offset);
                currPos = offset;
                currState = offState;
                found = true;
                continue block0;
            }
        } while (found);
        this.endProfile();
        return null;
    }

    public List<BlockPos> getOrderedNetworkNodes(BlockPos node) {
        if (!this.isNode(node)) {
            return Collections.emptyList();
        }
        List<Object> ret = this.nodeToConnectedNodes.get(node);
        if (ret == null) {
            this.startProfile("compile_connected_nodes");
            ShortestPathAlgorithm.SingleSourcePaths<BlockPos, NetworkEdge> paths = this.dijkstra.getPaths(node);
            ret = Streams.stream(new BreadthFirstIterator<BlockPos, NetworkEdge>(this.graph, node)).filter(p -> this.getPipe((BlockPos)p) != null).sorted(Comparator.comparingInt(p -> this.getPipe((BlockPos)p).getPriority()).reversed().thenComparing(paths::getWeight)).collect(Collectors.toList());
            this.nodeToConnectedNodes.put(node, ret);
            this.endProfile();
        }
        return ret;
    }

    public void clearDestinationCache(BlockPos ... nodes) {
        this.startProfile("clear_node_cache");
        for (BlockPos node : nodes) {
            this.nodeToConnectedNodes.keySet().remove(node);
        }
        this.nodeToConnectedNodes.values().removeIf(cached -> Arrays.stream(nodes).anyMatch(cached::contains));
        this.endProfile();
    }

    public List<IPipeItem> getItemsInPipe(BlockPos pos) {
        return this.pipeItems.get((Object)pos);
    }

    public Stream<IPipeItem> getPipeItemsOnTheWay(BlockPos goalInv) {
        this.startProfile("get_pipe_items_on_the_way");
        Stream<IPipeItem> ret = this.pipeItems.values().stream().filter(i -> i.getDestInventory().equals((Object)goalInv));
        this.endProfile();
        return ret;
    }

    public int getItemsOnTheWay(BlockPos goalInv, ItemStack type, ItemEquality ... equalityTypes) {
        return this.getPipeItemsOnTheWay(goalInv).filter(i -> type == null || ItemEquality.compareItems(i.getContent(), type, equalityTypes)).mapToInt(i -> i.getItemsOnTheWay(goalInv)).sum();
    }

    @Override
    public void edgeAdded(GraphEdgeChangeEvent<BlockPos, NetworkEdge> e) {
        this.clearDestinationCache(e.getEdgeSource(), e.getEdgeTarget());
    }

    @Override
    public void edgeRemoved(GraphEdgeChangeEvent<BlockPos, NetworkEdge> e) {
        this.clearDestinationCache(e.getEdgeSource(), e.getEdgeTarget());
    }

    @Override
    public void vertexAdded(GraphVertexChangeEvent<BlockPos> e) {
    }

    @Override
    public void vertexRemoved(GraphVertexChangeEvent<BlockPos> e) {
    }

    public void startProfile(String name) {
        this.world.func_217381_Z().func_194340_a(() -> "prettypipes:pipe_network_" + name);
    }

    public void endProfile() {
        this.world.func_217381_Z().func_76319_b();
    }

    public static PipeNetwork get(World world) {
        return (PipeNetwork)world.getCapability(Registry.pipeNetworkCapability).orElse(null);
    }
}

