/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.network;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.network.NetworkEdge;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.IPipeItem;
import de.ellpeck.prettypipes.pipe.PipeTileEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jgrapht.Graph;
import org.jgrapht.GraphPath;

public class PipeItem
implements IPipeItem {
    public static final ResourceLocation TYPE = new ResourceLocation("prettypipes", "pipe_item");
    public ItemStack stack;
    public float speed;
    public float x;
    public float y;
    public float z;
    public float lastX;
    public float lastY;
    public float lastZ;
    protected List<BlockPos> path;
    protected BlockPos startInventory;
    protected BlockPos destInventory;
    protected BlockPos currGoalPos;
    protected int currentTile;
    protected boolean retryOnObstruction;
    protected long lastWorldTick;
    protected ResourceLocation type;

    public PipeItem(ResourceLocation type, ItemStack stack, float speed) {
        this.type = type;
        this.stack = stack;
        this.speed = speed;
    }

    public PipeItem(ItemStack stack, float speed) {
        this(TYPE, stack, speed);
    }

    public PipeItem(ResourceLocation type, CompoundNBT nbt) {
        this.type = type;
        this.path = new ArrayList<BlockPos>();
        this.deserializeNBT(nbt);
    }

    @Override
    public ItemStack getContent() {
        return this.stack;
    }

    @Override
    public void setDestination(BlockPos startInventory, BlockPos destInventory, GraphPath<BlockPos, NetworkEdge> path) {
        this.startInventory = startInventory;
        this.destInventory = destInventory;
        this.path = PipeItem.compilePath(path);
        this.currGoalPos = this.getStartPipe();
        this.currentTile = 0;
        if (this.x == 0.0f && this.y == 0.0f && this.z == 0.0f) {
            this.x = MathHelper.func_219799_g((float)0.5f, (float)startInventory.func_177958_n(), (float)this.currGoalPos.func_177958_n()) + 0.5f;
            this.y = MathHelper.func_219799_g((float)0.5f, (float)startInventory.func_177956_o(), (float)this.currGoalPos.func_177956_o()) + 0.5f;
            this.z = MathHelper.func_219799_g((float)0.5f, (float)startInventory.func_177952_p(), (float)this.currGoalPos.func_177952_p()) + 0.5f;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void updateInPipe(PipeTileEntity currPipe) {
        long worldTick = currPipe.func_145831_w().func_82737_E();
        if (this.lastWorldTick == worldTick) {
            return;
        }
        this.lastWorldTick = worldTick;
        float motionLeft = this.speed;
        while (motionLeft > 0.0f) {
            float currSpeed = Math.min(0.25f, motionLeft);
            motionLeft -= currSpeed;
            BlockPos myPos = new BlockPos((double)this.x, (double)this.y, (double)this.z);
            if (!(myPos.equals((Object)currPipe.func_174877_v()) || !currPipe.func_174877_v().equals((Object)this.getDestPipe()) && myPos.equals((Object)this.startInventory))) {
                currPipe.getItems().remove(this);
                PipeTileEntity next = this.getNextTile(currPipe, true);
                if (next == null) {
                    if (currPipe.func_145831_w().field_72995_K) return;
                    if (currPipe.func_174877_v().equals((Object)this.getDestPipe())) {
                        this.stack = this.store(currPipe);
                        if (this.stack.func_190926_b()) return;
                        this.onPathObstructed(currPipe, true);
                        return;
                    }
                    this.onPathObstructed(currPipe, false);
                    return;
                }
                next.getItems().add(this);
                currPipe = next;
            } else {
                double dist = Vector3d.func_237491_b_((Vector3i)this.currGoalPos).func_186679_c((double)(this.x - 0.5f), (double)(this.y - 0.5f), (double)(this.z - 0.5f));
                if (dist < (double)(currSpeed * currSpeed)) {
                    BlockPos nextPos;
                    PipeTileEntity next = this.getNextTile(currPipe, false);
                    if (next == null || next == currPipe) {
                        if (!currPipe.func_174877_v().equals((Object)this.getDestPipe())) {
                            currPipe.getItems().remove(this);
                            if (currPipe.func_145831_w().field_72995_K) return;
                            this.onPathObstructed(currPipe, false);
                            return;
                        }
                        nextPos = this.destInventory;
                    } else {
                        nextPos = next.func_174877_v();
                    }
                    float tolerance = 0.001f;
                    if (dist >= (double)(tolerance * tolerance)) {
                        Vector3d motion = new Vector3d((double)(this.x - this.lastX), (double)(this.y - this.lastY), (double)(this.z - this.lastZ));
                        Vector3d diff = new Vector3d((double)((float)nextPos.func_177958_n() + 0.5f - this.x), (double)((float)nextPos.func_177956_o() + 0.5f - this.y), (double)((float)nextPos.func_177952_p() + 0.5f - this.z));
                        if (motion.func_72431_c(diff).func_72433_c() >= (double)tolerance) {
                            currSpeed = (float)Math.sqrt(dist);
                        } else {
                            this.currGoalPos = nextPos;
                        }
                    } else {
                        this.currGoalPos = nextPos;
                    }
                }
            }
            this.lastX = this.x;
            this.lastY = this.y;
            this.lastZ = this.z;
            Vector3d dist = new Vector3d((double)((float)this.currGoalPos.func_177958_n() + 0.5f - this.x), (double)((float)this.currGoalPos.func_177956_o() + 0.5f - this.y), (double)((float)this.currGoalPos.func_177952_p() + 0.5f - this.z));
            dist = dist.func_72432_b();
            this.x = (float)((double)this.x + dist.field_72450_a * (double)currSpeed);
            this.y = (float)((double)this.y + dist.field_72448_b * (double)currSpeed);
            this.z = (float)((double)this.z + dist.field_72449_c * (double)currSpeed);
        }
    }

    protected void onPathObstructed(PipeTileEntity currPipe, boolean tryReturn) {
        if (currPipe.func_145831_w().field_72995_K) {
            return;
        }
        PipeNetwork network = PipeNetwork.get(currPipe.func_145831_w());
        if (tryReturn) {
            if (!this.retryOnObstruction && network.routeItemToLocation(currPipe.func_174877_v(), this.destInventory, this.getStartPipe(), this.startInventory, this.stack, speed -> this)) {
                this.retryOnObstruction = true;
                return;
            }
            ItemStack remain = network.routeItem(currPipe.func_174877_v(), this.destInventory, this.stack, (stack, speed) -> this, false);
            if (!remain.func_190926_b()) {
                this.drop(currPipe.func_145831_w(), remain.func_77946_l());
            }
        } else {
            this.drop(currPipe.func_145831_w(), this.stack);
        }
    }

    @Override
    public void drop(World world, ItemStack stack) {
        ItemEntity item = new ItemEntity(world, (double)this.x, (double)this.y, (double)this.z, stack.func_77946_l());
        item.field_70170_p.func_217376_c((Entity)item);
    }

    protected ItemStack store(PipeTileEntity currPipe) {
        Direction dir = Utility.getDirectionFromOffset(this.destInventory, this.getDestPipe());
        IPipeConnectable connectable = currPipe.getPipeConnectable(dir);
        if (connectable != null) {
            return connectable.insertItem(currPipe.func_174877_v(), dir, this.stack, false);
        }
        IItemHandler handler = currPipe.getItemHandler(dir);
        if (handler != null) {
            return ItemHandlerHelper.insertItemStacked((IItemHandler)handler, (ItemStack)this.stack, (boolean)false);
        }
        return this.stack;
    }

    protected PipeTileEntity getNextTile(PipeTileEntity currPipe, boolean progress) {
        if (this.path.size() <= this.currentTile + 1) {
            return null;
        }
        BlockPos pos = this.path.get(this.currentTile + 1);
        if (progress) {
            ++this.currentTile;
        }
        PipeNetwork network = PipeNetwork.get(currPipe.func_145831_w());
        return network.getPipe(pos);
    }

    protected BlockPos getStartPipe() {
        return this.path.get(0);
    }

    @Override
    public BlockPos getDestPipe() {
        return this.path.get(this.path.size() - 1);
    }

    @Override
    public BlockPos getCurrentPipe() {
        return this.path.get(this.currentTile);
    }

    @Override
    public BlockPos getDestInventory() {
        return this.destInventory;
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74778_a("type", this.type.toString());
        nbt.func_218657_a("stack", (INBT)this.stack.serializeNBT());
        nbt.func_74776_a("speed", this.speed);
        nbt.func_218657_a("start_inv", (INBT)NBTUtil.func_186859_a((BlockPos)this.startInventory));
        nbt.func_218657_a("dest_inv", (INBT)NBTUtil.func_186859_a((BlockPos)this.destInventory));
        nbt.func_218657_a("curr_goal", (INBT)NBTUtil.func_186859_a((BlockPos)this.currGoalPos));
        nbt.func_74757_a("drop_on_obstruction", this.retryOnObstruction);
        nbt.func_74768_a("tile", this.currentTile);
        nbt.func_74776_a("x", this.x);
        nbt.func_74776_a("y", this.y);
        nbt.func_74776_a("z", this.z);
        ListNBT list = new ListNBT();
        for (BlockPos pos : this.path) {
            list.add((Object)NBTUtil.func_186859_a((BlockPos)pos));
        }
        nbt.func_218657_a("path", (INBT)list);
        return nbt;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.stack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("stack"));
        this.speed = nbt.func_74760_g("speed");
        this.startInventory = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("start_inv"));
        this.destInventory = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("dest_inv"));
        this.currGoalPos = NBTUtil.func_186861_c((CompoundNBT)nbt.func_74775_l("curr_goal"));
        this.retryOnObstruction = nbt.func_74767_n("drop_on_obstruction");
        this.currentTile = nbt.func_74762_e("tile");
        this.x = nbt.func_74760_g("x");
        this.y = nbt.func_74760_g("y");
        this.z = nbt.func_74760_g("z");
        this.path.clear();
        ListNBT list = nbt.func_150295_c("path", 10);
        for (int i = 0; i < list.size(); ++i) {
            this.path.add(NBTUtil.func_186861_c((CompoundNBT)list.func_150305_b(i)));
        }
    }

    @Override
    public int getItemsOnTheWay(BlockPos goalInv) {
        return this.stack.func_190916_E();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(PipeTileEntity tile, MatrixStack matrixStack, Random random, float partialTicks, int light, int overlay, IRenderTypeBuffer buffer) {
        float scale;
        matrixStack.func_227861_a_((double)MathHelper.func_219799_g((float)partialTicks, (float)this.lastX, (float)this.x), (double)MathHelper.func_219799_g((float)partialTicks, (float)this.lastY, (float)this.y), (double)MathHelper.func_219799_g((float)partialTicks, (float)this.lastZ, (float)this.z));
        if (this.stack.func_77973_b() instanceof BlockItem) {
            scale = 0.7f;
            matrixStack.func_227862_a_(scale, scale, scale);
            matrixStack.func_227861_a_(0.0, (double)-0.2f, 0.0);
        } else {
            scale = 0.45f;
            matrixStack.func_227862_a_(scale, scale, scale);
            matrixStack.func_227861_a_(0.0, (double)-0.1f, 0.0);
        }
        random.setSeed(Item.func_150891_b((Item)this.stack.func_77973_b()) + this.stack.func_77952_i());
        int amount = this.getModelCount();
        for (int i = 0; i < amount; ++i) {
            matrixStack.func_227860_a_();
            if (amount > 1) {
                matrixStack.func_227861_a_((double)((random.nextFloat() * 2.0f - 1.0f) * 0.25f * 0.5f), (double)((random.nextFloat() * 2.0f - 1.0f) * 0.25f * 0.5f), (double)((random.nextFloat() * 2.0f - 1.0f) * 0.25f * 0.5f));
            }
            Minecraft.func_71410_x().func_175599_af().func_229110_a_(this.stack, ItemCameraTransforms.TransformType.GROUND, light, overlay, matrixStack, buffer);
            matrixStack.func_227865_b_();
        }
    }

    protected int getModelCount() {
        int i = 1;
        if (this.stack.func_190916_E() > 48) {
            i = 5;
        } else if (this.stack.func_190916_E() > 32) {
            i = 4;
        } else if (this.stack.func_190916_E() > 16) {
            i = 3;
        } else if (this.stack.func_190916_E() > 1) {
            i = 2;
        }
        return i;
    }

    protected static List<BlockPos> compilePath(GraphPath<BlockPos, NetworkEdge> path) {
        Graph<BlockPos, NetworkEdge> graph = path.getGraph();
        ArrayList<BlockPos> ret = new ArrayList<BlockPos>();
        List<BlockPos> nodes = path.getVertexList();
        if (nodes.size() == 1) {
            for (int i = 0; i < 2; ++i) {
                ret.add(nodes.get(0));
            }
            return ret;
        }
        for (int i = 0; i < nodes.size() - 1; ++i) {
            int j2;
            BlockPos first = nodes.get(i);
            BlockPos second = nodes.get(i + 1);
            NetworkEdge edge = graph.getEdge(first, second);
            Consumer<Integer> add = j -> {
                BlockPos pos = edge.pipes.get((int)j);
                if (!ret.contains(pos)) {
                    ret.add(pos);
                }
            };
            if (!graph.getEdgeSource(edge).equals((Object)first)) {
                for (j2 = edge.pipes.size() - 1; j2 >= 0; --j2) {
                    add.accept(j2);
                }
                continue;
            }
            for (j2 = 0; j2 < edge.pipes.size(); ++j2) {
                add.accept(j2);
            }
        }
        return ret;
    }
}

