/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.kubejs.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.latvian.kubejs.KubeJS;
import dev.latvian.kubejs.client.KubeJSClient;
import dev.latvian.kubejs.ui.widget.Panorama;
import dev.latvian.kubejs.ui.widget.UI;
import dev.latvian.kubejs.ui.widget.Widget;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.shader.ShaderInstance;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public final class ScreenKubeJSUI
extends Screen {
    public final String screenId;
    public final Screen original;
    public final Consumer<UI> consumer;
    public final int forcedScale;
    public final UI ui;
    public final Map<ResourceLocation, Optional<ShaderInstance>> shaders;

    public ScreenKubeJSUI(String i, Screen o, Consumer<UI> c, int fs) {
        super(o.func_231171_q_());
        this.screenId = i;
        this.original = o;
        this.consumer = c;
        this.forcedScale = fs;
        this.ui = new UI(this);
        this.shaders = new HashMap<ResourceLocation, Optional<ShaderInstance>>();
    }

    public void func_231158_b_(Minecraft mc, int w, int h) {
        this.original.func_231158_b_(mc, w, h);
        super.func_231158_b_(mc, w, h);
    }

    public void func_231160_c_() {
        this.ui.children.clear();
        this.ui.allWidgets.clear();
        this.consumer.accept(this.ui);
        this.ui.collectWidgets(this.ui.allWidgets);
        for (Widget w : this.ui.allWidgets) {
            w.actualX = w.getX();
            w.actualY = w.getY();
        }
    }

    public FontRenderer getUiFont() {
        return this.field_230712_o_;
    }

    public boolean func_231178_ax__() {
        return this.original.func_231178_ax__() || this.screenId.startsWith("$");
    }

    public boolean func_231177_au__() {
        return this.original.func_231177_au__();
    }

    public void clearCaches() {
        for (Optional<ShaderInstance> instance : this.shaders.values()) {
            try {
                instance.ifPresent(ShaderInstance::close);
            }
            catch (Exception exception) {}
        }
        this.shaders.clear();
    }

    public void func_231164_f_() {
        this.clearCaches();
        super.func_231164_f_();
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.original.func_230446_a_(matrixStack);
        this.ui.mouse.x = mouseX;
        this.ui.mouse.y = mouseY;
        this.ui.time = System.currentTimeMillis() - UI.startTime;
        for (Widget w : this.ui.allWidgets) {
            boolean b = w.isMouseOver;
            boolean bl = w.isMouseOver = mouseX >= w.actualX && mouseY >= w.actualY && mouseX < w.actualX + w.getWidth() && mouseY < w.actualY + w.getHeight();
            if (b == w.isMouseOver) continue;
            if (w.isMouseOver) {
                if (w.mouseEnter == null) continue;
                w.mouseEnter.run();
                continue;
            }
            if (w.mouseExit == null) continue;
            w.mouseExit.run();
        }
        this.ui.renderBackground(matrixStack, partialTicks);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.ui.renderForeground(matrixStack, partialTicks);
        ArrayList<ITextComponent> list = new ArrayList<ITextComponent>();
        this.ui.appendHoverText(list);
        if (!list.isEmpty()) {
            this.func_243308_b(matrixStack, list, mouseX, mouseY);
        }
    }

    public boolean func_231044_a_(double x, double y, int button) {
        if (this.ui.mousePressed()) {
            return true;
        }
        return super.func_231044_a_(x, y, button);
    }

    public boolean func_231048_c_(double x, double y, int button) {
        this.ui.mouseReleased();
        return super.func_231048_c_(x, y, button);
    }

    public boolean func_231046_a_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 294) {
            this.ui.tick = 0;
            if ((modifiers & 2) != 0) {
                KubeJSClient.reloadClientScripts();
                this.field_230706_i_.func_147108_a((Screen)this);
            } else {
                UI.startTime = System.currentTimeMillis();
                this.ui.time = 0L;
                Panorama.panoramaTime = 0.0f;
            }
            return true;
        }
        return super.func_231046_a_(keyCode, scanCode, modifiers);
    }

    public Optional<ShaderInstance> loadShader(ResourceLocation id) {
        Optional<Object> instance = this.shaders.get(id);
        if (instance != null) {
            return instance;
        }
        try {
            instance = Optional.of(new ShaderInstance(Minecraft.func_71410_x().func_195551_G(), id.toString()));
        }
        catch (Exception ex) {
            instance = Optional.empty();
            KubeJS.LOGGER.error("Failed to load shader " + id + ":");
            ex.printStackTrace();
        }
        this.shaders.put(id, instance);
        return instance;
    }

    public void func_231023_e_() {
        super.func_231023_e_();
        ++this.ui.tick;
    }

    public Minecraft getMinecraft() {
        return this.field_230706_i_;
    }
}

