/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.IHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIHerdPanic;
import com.github.alexthe666.alexsmobs.entity.ai.AnimalAIWanderRanged;
import com.github.alexthe666.alexsmobs.item.AMItemRegistry;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.monster.AbstractSkeletonEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityEmu
extends AnimalEntity
implements IAnimatedEntity,
IHerdPanic {
    public static final Animation ANIMATION_DODGE_LEFT = Animation.create((int)10);
    public static final Animation ANIMATION_DODGE_RIGHT = Animation.create((int)10);
    public static final Animation ANIMATION_PECK_GROUND = Animation.create((int)25);
    public static final Animation ANIMATION_SCRATCH = Animation.create((int)20);
    public static final Animation ANIMATION_PUZZLED = Animation.create((int)30);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(EntityEmu.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int animationTick;
    private Animation currentAnimation;
    private int revengeCooldown = 0;
    private boolean emuAttackedDirectly = false;
    public int timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;

    protected EntityEmu(EntityType type, World world) {
        super(type, world);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233821_d_, (double)0.35f).func_233815_a_(Attributes.field_233823_f_, 3.0);
    }

    public static <T extends MobEntity> boolean canEmuSpawn(EntityType<? extends AnimalEntity> animal, IWorld worldIn, SpawnReason reason, BlockPos pos, Random random) {
        boolean spawnBlock = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.EMU_SPAWNS).func_230235_a_((Object)worldIn.func_180495_p(pos.func_177977_b()).func_177230_c());
        return spawnBlock && worldIn.func_226659_b_(pos, 0) > 8;
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.emuSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.EMU_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.EMU_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.EMU_HURT;
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int variant) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)variant);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.3, true){

            protected double func_179512_a(LivingEntity attackTarget) {
                return super.func_179512_a(attackTarget) + 2.5;
            }

            public boolean func_75250_a() {
                return super.func_75250_a() && EntityEmu.this.revengeCooldown <= 0;
            }

            public boolean func_75253_b() {
                return super.func_75253_b() && EntityEmu.this.revengeCooldown <= 0;
            }
        });
        this.field_70714_bg.func_75776_a(2, (Goal)new AnimalAIHerdPanic((CreatureEntity)this, 1.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O}), false));
        this.field_70714_bg.func_75776_a(5, (Goal)new AnimalAIWanderRanged((CreatureEntity)this, 110, 1.0, 10, 7));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 15.0f));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal());
        if (AMConfig.emuTargetSkeletons) {
            this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AbstractSkeletonEntity.class, false));
            this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PillagerEntity.class, false));
        }
    }

    public boolean func_213336_c(LivingEntity target) {
        return !this.func_70631_g_() && super.func_213336_c(target);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        boolean prev = super.func_70097_a(source, amount);
        if (prev) {
            int fleeTime;
            double range = 15.0;
            this.revengeCooldown = fleeTime = 100 + this.func_70681_au().nextInt(5);
            List list = this.field_70170_p.func_217357_a(this.getClass(), this.func_174813_aQ().func_72314_b(range, range / 2.0, range));
            for (EntityEmu emu : list) {
                emu.revengeCooldown = fleeTime;
                if (!emu.func_70631_g_() || this.field_70146_Z.nextInt(2) != 0) continue;
                emu.emuAttackedDirectly = this.func_70643_av() != null;
                emu.revengeCooldown = emu.emuAttackedDirectly ? 10 + this.func_70681_au().nextInt(30) : fleeTime;
            }
            this.emuAttackedDirectly = this.func_70643_av() != null;
            this.revengeCooldown = this.emuAttackedDirectly ? 10 + this.func_70681_au().nextInt(30) : this.revengeCooldown;
        }
        return prev;
    }

    public void func_213352_e(Vector3d travelVector) {
        this.func_70659_e((float)this.func_233637_b_(Attributes.field_233821_d_) * (this.getAnimation() == ANIMATION_PECK_GROUND || this.getAnimation() == ANIMATION_PUZZLED ? 0.15f : 1.0f) * (this.func_180799_ab() ? 0.2f : 1.0f));
        super.func_213352_e(travelVector);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.func_70643_av() == null && this.func_70638_az() == null && this.func_213322_ci().func_189985_c() < 0.03 && this.func_70681_au().nextInt(190) == 0 && this.getAnimation() == NO_ANIMATION) {
                if (this.func_70681_au().nextInt(3) == 0) {
                    this.setAnimation(ANIMATION_PUZZLED);
                } else if (this.field_70122_E) {
                    this.setAnimation(ANIMATION_PECK_GROUND);
                }
            }
            if (this.revengeCooldown > 0) {
                --this.revengeCooldown;
            }
            if (this.revengeCooldown <= 0 && this.func_70643_av() != null && !this.emuAttackedDirectly) {
                this.func_70604_c(null);
                this.revengeCooldown = 0;
            }
            if (this.func_70638_az() != null && this.getAnimation() == ANIMATION_SCRATCH && this.func_70032_d((Entity)this.func_70638_az()) < 4.0f && (this.getAnimationTick() == 8 || this.getAnimationTick() == 15)) {
                float f1 = this.field_70177_z * ((float)Math.PI / 180);
                this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)f1) * 0.02f), 0.0, (double)(MathHelper.func_76134_b((float)f1) * 0.02f)));
                this.func_70638_az().func_233627_a_(0.4f, this.func_70638_az().func_226277_ct_() - this.func_226277_ct_(), this.func_70638_az().func_226281_cx_() - this.func_226281_cx_());
                this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_70631_g_() && --this.timeUntilNextEgg <= 0) {
            this.func_184185_a(SoundEvents.field_187665_Y, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            this.func_199703_a((IItemProvider)AMItemRegistry.EMU_EGG);
            this.timeUntilNextEgg = this.field_70146_Z.nextInt(6000) + 6000;
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_DODGE_LEFT, ANIMATION_DODGE_RIGHT, ANIMATION_PECK_GROUND, ANIMATION_SCRATCH, ANIMATION_PUZZLED};
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        EntityEmu emu = (EntityEmu)AMEntityRegistry.EMU.func_200721_a((World)serverWorld);
        emu.setVariant(this.getVariant());
        return emu;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_SCRATCH);
        }
        return true;
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        if (compound.func_74764_b("EggLayTime")) {
            this.timeUntilNextEgg = compound.func_74762_e("EggLayTime");
        }
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74768_a("EggLayTime", this.timeUntilNextEgg);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.setVariant(2);
        } else if (this.field_70146_Z.nextInt(3) == 0) {
            this.setVariant(1);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void onPanic() {
    }

    @Override
    public boolean canPanic() {
        return true;
    }

    class HurtByTargetGoal
    extends net.minecraft.entity.ai.goal.HurtByTargetGoal {
        public HurtByTargetGoal() {
            super((CreatureEntity)EntityEmu.this, new Class[0]);
        }

        public void func_75249_e() {
            if (EntityEmu.this.func_70631_g_() || !EntityEmu.this.emuAttackedDirectly) {
                this.func_190105_f();
                this.func_75251_c();
            } else {
                super.func_75249_e();
            }
        }

        protected void func_220793_a(MobEntity mobIn, LivingEntity targetIn) {
            if (mobIn instanceof EntityEmu && !mobIn.func_70631_g_() && !EntityEmu.this.emuAttackedDirectly && ((EntityEmu)mobIn).revengeCooldown <= 0) {
                super.func_220793_a(mobIn, targetIn);
            }
        }
    }
}

