/*
 * Decompiled with CFR 0.152.
 */
package com.valkyrieofnight.enviroenergyapi.impl.storage;

import com.valkyrieofnight.enviroenergyapi.api.Energy;
import com.valkyrieofnight.enviroenergyapi.api.storage.IEEPotentialStorage;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundNBT;

public class DynamicPotentialStorage
implements IEEPotentialStorage {
    protected long potential = 0L;
    protected long potentialCapacity;
    protected long maxExtract;
    protected long maxReceive;

    public DynamicPotentialStorage(long potentialCapacity) {
        this(potentialCapacity, Long.MAX_VALUE, Long.MAX_VALUE);
    }

    public DynamicPotentialStorage(long potentialCapacity, long maxTransfer) {
        this(potentialCapacity, maxTransfer, maxTransfer);
    }

    public DynamicPotentialStorage(long potentialCapacity, long maxExtract, long maxReceive) {
        this.potentialCapacity = potentialCapacity;
        this.maxExtract = maxExtract;
        this.maxReceive = maxReceive;
    }

    public void setPotentialCapacity(long newCapacity) {
        this.potentialCapacity = newCapacity;
        if (this.potential > this.potentialCapacity) {
            this.potential = this.potentialCapacity;
        }
    }

    public void setMaxReceive(long maxReceive) {
        this.maxReceive = maxReceive;
    }

    public void setMaxExtract(long maxExtract) {
        this.maxExtract = maxExtract;
    }

    public void setMaxTransfer(long maxTransfer) {
        this.maxExtract = maxTransfer;
        this.maxReceive = maxTransfer;
    }

    @Override
    public Energy extractEnergy(@Nonnull Energy requested, boolean sim) {
        long extractable = Math.min(this.potential, Math.min(this.maxExtract, requested.getPotential()));
        if (extractable < requested.getPotential()) {
            extractable -= extractable % (long)requested.getVoltage();
        }
        if (!sim) {
            this.potential -= extractable;
        }
        return Energy.fromPotential(requested.getVoltage(), extractable);
    }

    @Override
    public Energy receiveEnergy(@Nonnull Energy provided, boolean sim) {
        long receivable = Math.min(this.getPotentialRoom(), Math.min(this.maxReceive, provided.getPotential()));
        if (receivable < provided.getPotential()) {
            receivable -= receivable % (long)provided.getVoltage();
        }
        if (!sim) {
            this.potential += receivable;
        }
        return Energy.fromPotential(provided.getVoltage(), receivable);
    }

    @Override
    public boolean canReceive() {
        return this.maxReceive > 0L;
    }

    @Override
    public long extractPotential(long requested, boolean sim) {
        long extractable = Math.min(this.potential, Math.min(this.maxExtract, requested));
        if (!sim) {
            this.potential -= extractable;
        }
        return extractable;
    }

    @Override
    public long getMaxExtract() {
        return this.maxExtract;
    }

    @Override
    public boolean canExtract() {
        return this.maxExtract > 0L;
    }

    @Override
    public long receivePotential(long provided, boolean sim) {
        long received = Math.min(this.getPotentialRoom(), Math.min(this.maxReceive, provided));
        if (!sim) {
            this.potential += received;
        }
        return received;
    }

    @Override
    public long getMaxReceive() {
        return this.maxReceive;
    }

    @Override
    public long getPotentialStored() {
        return this.potential;
    }

    @Override
    public long getPotentialCapacity() {
        return this.potentialCapacity;
    }

    @Override
    public CompoundNBT serializeNBT() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74772_a("potential", this.potential);
        nbt.func_74772_a("capacity", this.potentialCapacity);
        nbt.func_74772_a("max_extract", this.maxExtract);
        nbt.func_74772_a("max_receive", this.maxReceive);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundNBT nbt) {
        if (nbt.func_74764_b("potential")) {
            this.potential = nbt.func_74763_f("potential");
        }
        if (nbt.func_74764_b("capacity")) {
            this.potentialCapacity = nbt.func_74763_f("capacity");
        }
        if (nbt.func_74764_b("max_extract")) {
            this.maxExtract = nbt.func_74763_f("max_extract");
        }
        if (nbt.func_74764_b("max_receive")) {
            this.maxReceive = nbt.func_74763_f("max_receive");
        }
    }
}

