/*
 * Decompiled with CFR 0.152.
 */
package owmii.krate.item;

import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import owmii.krate.block.KrateTile;
import owmii.krate.block.Tier;
import owmii.lib.item.ItemBase;
import owmii.lib.logistics.inventory.Inventory;

public class KrateUpgradeItem
extends ItemBase {
    private final Tier tier;

    public KrateUpgradeItem(Item.Properties properties, Tier tier) {
        super(properties);
        this.tier = tier;
    }

    public ActionResultType onItemUseFirst(ItemStack stack, World world, BlockPos pos, PlayerEntity player, Hand hand, Direction side, Vector3d hit) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof KrateTile) {
            KrateTile krate = (KrateTile)tile;
            Tier tier = (Tier)krate.getVariant();
            if (this.tier.ordinal() - 1 == tier.ordinal()) {
                Inventory inv = new Inventory(krate.getInventory().getSlots());
                inv.deserializeNBT(krate.getInventory().serializeNBT());
                krate.getInventory().clear();
                world.func_180501_a(pos, (BlockState)this.tier.getBlock().func_176223_P().func_206870_a((Property)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false)), 3);
                TileEntity tile2 = world.func_175625_s(pos);
                if (tile2 instanceof KrateTile) {
                    KrateTile krate2 = (KrateTile)tile2;
                    Inventory inv2 = krate2.getInventory();
                    if (!world.field_72995_K) {
                        for (int i = 0; i < tier.getInvSize(); ++i) {
                            inv2.setStackInSlot(i, inv.getStackInSlot(i));
                        }
                        int j = 0;
                        for (int i = tier.getInvSize(); i < inv.getSlots(); ++i) {
                            inv2.setStackInSlot(j + this.tier.getInvSize(), inv.getStackInSlot(i));
                            ++j;
                        }
                        krate2.copy(krate);
                        if (!player.func_184812_l_()) {
                            player.func_184586_b(hand).func_190918_g(1);
                        }
                    } else {
                        player.func_184185_a(SoundEvents.field_232858_y_, 1.0f, 1.0f);
                    }
                }
                return ActionResultType.SUCCESS;
            }
            player.func_146105_b((ITextComponent)new TranslationTextComponent("chat.krate.upgrade.not.applicable").func_240699_a_(TextFormatting.RED).func_230529_a_((ITextComponent)new ItemStack((IItemProvider)Tier.values()[this.tier.ordinal() - 1].getBlock()).func_200301_q().func_230531_f_().func_240699_a_(TextFormatting.GRAY)), true);
            return ActionResultType.FAIL;
        }
        return super.onItemUseFirst(stack, world, pos, player, hand, side, hit);
    }

    public Rarity func_77613_e(ItemStack stack) {
        return Rarity.UNCOMMON;
    }
}

