/*
 * Decompiled with CFR 0.152.
 */
package owmii.krate.block;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.IWaterLoggable;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import owmii.krate.block.KrateTile;
import owmii.krate.block.Tier;
import owmii.krate.inventory.KrateContainer;
import owmii.lib.block.AbstractBlock;
import owmii.lib.block.AbstractTileEntity;
import owmii.lib.logistics.inventory.AbstractContainer;
import owmii.lib.logistics.inventory.Inventory;
import owmii.lib.registry.IVariant;

public class KrateBlock
extends AbstractBlock<Tier, KrateBlock>
implements IWaterLoggable {
    private static final VoxelShape TOP = Block.func_208617_a((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape MID = Block.func_208617_a((double)0.5, (double)0.5, (double)0.5, (double)15.5, (double)15.5, (double)15.5);
    private static final VoxelShape BOTTOM = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    private static final VoxelShape SHAPE = VoxelShapes.func_216384_a((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{MID, BOTTOM});

    public KrateBlock(AbstractBlock.Properties properties, Tier variant) {
        super(properties, (IVariant)variant);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new KrateTile((Tier)this.variant);
    }

    @Nullable
    public <T extends AbstractTileEntity> AbstractContainer getContainer(int id, PlayerInventory inventory, AbstractTileEntity te, BlockRayTraceResult result) {
        if (te instanceof KrateTile) {
            return new KrateContainer(id, inventory, (KrateTile)te);
        }
        return null;
    }

    protected AbstractBlock.Facing getFacing() {
        return AbstractBlock.Facing.HORIZONTAL;
    }

    protected boolean isPlacerFacing() {
        return true;
    }

    public boolean func_149740_M(BlockState state) {
        return true;
    }

    public int func_180641_l(BlockState state, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof KrateTile) {
            return Inventory.calcRedstone((IItemHandler)((KrateTile)tile).getInventory());
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderByItem(ItemStack stack, MatrixStack matrix, IRenderTypeBuffer rtb, int light, int ov) {
        KrateTile invTe = new KrateTile((Tier)this.getVariant());
        TileEntityRendererDispatcher.field_147556_a.func_228852_a_((TileEntity)invTe, matrix, rtb, light, ov);
    }
}

