/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogethergui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;

public class ScreenHelpers {
    public static Widget findButton(String buttonString, List<Widget> widgetList) {
        if (widgetList != null && !widgetList.isEmpty()) {
            for (Widget widget : widgetList) {
                if (!widget.func_230458_i_().getString().equalsIgnoreCase(I18n.func_135052_a((String)buttonString, (Object[])new Object[0]))) continue;
                return widget;
            }
        }
        return null;
    }

    public static Widget removeButton(String buttonString, List<Widget> widgetList) {
        Widget widget = ScreenHelpers.findButton(buttonString, widgetList);
        if (widget != null) {
            widget.field_230694_p_ = false;
            widget.field_230693_o_ = false;
            return widget;
        }
        return null;
    }

    public static void drawLogo(MatrixStack matrixStack, FontRenderer fontRendererObj, int containerWidth, int containerHeight, int containerX, int containerY, float scale) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float adjust = 1.0f / scale;
        int width = (int)((float)containerWidth * adjust);
        int height = (int)((float)containerHeight * adjust);
        int x = (int)((float)containerX * adjust);
        int y = (int)((float)containerY * adjust);
        ResourceLocation resourceLocationCreeperLogo = new ResourceLocation("minetogether", "textures/creeperhost_logo_1-25.png");
        ResourceLocation resourceLocationMineTogetherLogo = new ResourceLocation("minetogether", "textures/minetogether25.png");
        RenderSystem.pushMatrix();
        RenderSystem.scaled((double)scale, (double)scale, (double)scale);
        int mtHeight = 127;
        int mtWidth = 139;
        int creeperHeight = 22;
        int creeperWidth = 80;
        int totalHeight = mtHeight + creeperHeight;
        int totalWidth = mtWidth + creeperWidth;
        totalHeight = (int)((float)totalHeight * adjust);
        totalWidth = (int)((float)totalWidth * adjust);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocationMineTogetherLogo);
        RenderSystem.enableBlend();
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + (width / 2 - mtWidth / 2)), (int)(y + (height / 2 - totalHeight / 2)), (float)0.0f, (float)0.0f, (int)mtWidth, (int)mtHeight, (int)mtWidth, (int)mtHeight);
        String created = "Created by";
        int stringWidth = fontRendererObj.func_78256_a(created);
        int creeperTotalWidth = creeperWidth + stringWidth;
        fontRendererObj.func_238405_a_(matrixStack, created, (float)(x + (width / 2 - creeperTotalWidth / 2)), (float)(y + (height / 2 - totalHeight / 2 + mtHeight + 7)), 0x40FFFFFF);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocationCreeperLogo);
        RenderSystem.enableBlend();
        AbstractGui.func_238463_a_((MatrixStack)matrixStack, (int)(x + (width / 2 - creeperTotalWidth / 2 + stringWidth)), (int)(y + (height / 2 - totalHeight / 2 + mtHeight)), (float)0.0f, (float)0.0f, (int)creeperWidth, (int)creeperHeight, (int)creeperWidth, (int)creeperHeight);
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }

    public void renderHead(MatrixStack poseStack, int x, int y) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("textures/entity/steve.png"));
        AbstractGui.func_238466_a_((MatrixStack)poseStack, (int)x, (int)(y - 2), (int)9, (int)9, (float)8.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        RenderSystem.enableBlend();
        AbstractGui.func_238466_a_((MatrixStack)poseStack, (int)x, (int)(y - 2), (int)9, (int)9, (float)40.0f, (float)8.0f, (int)8, (int)8, (int)64, (int)64);
        RenderSystem.disableBlend();
    }

    public static void loadingSpin(float partialTicks, int ticks, int x, int y, ItemStack stack) {
        int rotateTickMax = 30;
        int throbTickMax = 20;
        int rotateTicks = ticks % rotateTickMax;
        int throbTicks = ticks % throbTickMax;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)x, (double)y, (double)0.0);
        float scale = 1.0f + (throbTicks >= throbTickMax / 2 ? (float)throbTickMax - ((float)throbTicks + partialTicks) : (float)throbTicks + partialTicks) * (2.0f / (float)throbTickMax);
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        RenderSystem.rotatef((float)(((float)rotateTicks + partialTicks) * (360.0f / (float)rotateTickMax)), (float)0.0f, (float)0.0f, (float)1.0f);
        ItemRenderer itemRenderer = Minecraft.func_71410_x().func_175599_af();
        itemRenderer.func_175042_a(stack, -8, -8);
        RenderSystem.popMatrix();
    }

    public static void drawModalRectWithCustomSizedTextureFloat(Matrix4f matrix, float x, float y, float u, float v, int width, int height, float textureWidth, float textureHeight) {
        float f = 1.0f / textureWidth;
        float f1 = 1.0f / textureHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_227888_a_(matrix, x, y + (float)height, 0.0f).func_225583_a_(u * f, (v + (float)height) * f1).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x + (float)width, y + (float)height, 0.0f).func_225583_a_((u + (float)width) * f, (v + (float)height) * f1).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x + (float)width, y, 0.0f).func_225583_a_((u + (float)width) * f, v * f1).func_181675_d();
        bufferbuilder.func_227888_a_(matrix, x, y, 0.0f).func_225583_a_(u * f, v * f1).func_181675_d();
        bufferbuilder.func_178977_d();
        RenderSystem.enableAlphaTest();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferbuilder);
    }

    public static void drawContinuousTexturedBox(MatrixStack matrixStack, int x, int y, int u, int v, int width, int height, int textureWidth, int textureHeight, int topBorder, int bottomBorder, int leftBorder, int rightBorder, float zLevel) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        int fillerWidth = textureWidth - leftBorder - rightBorder;
        int fillerHeight = textureHeight - topBorder - bottomBorder;
        int canvasWidth = width - leftBorder - rightBorder;
        int canvasHeight = height - topBorder - bottomBorder;
        int xPasses = canvasWidth / fillerWidth;
        int remainderWidth = canvasWidth % fillerWidth;
        int yPasses = canvasHeight / fillerHeight;
        int remainderHeight = canvasHeight % fillerHeight;
        ScreenHelpers.drawTexturedModalRect(matrixStack, x, y, u, v, leftBorder, topBorder, zLevel);
        ScreenHelpers.drawTexturedModalRect(matrixStack, x + leftBorder + canvasWidth, y, u + leftBorder + fillerWidth, v, rightBorder, topBorder, zLevel);
        ScreenHelpers.drawTexturedModalRect(matrixStack, x, y + topBorder + canvasHeight, u, v + topBorder + fillerHeight, leftBorder, bottomBorder, zLevel);
        ScreenHelpers.drawTexturedModalRect(matrixStack, x + leftBorder + canvasWidth, y + topBorder + canvasHeight, u + leftBorder + fillerWidth, v + topBorder + fillerHeight, rightBorder, bottomBorder, zLevel);
        for (int i = 0; i < xPasses + (remainderWidth > 0 ? 1 : 0); ++i) {
            ScreenHelpers.drawTexturedModalRect(matrixStack, x + leftBorder + i * fillerWidth, y, u + leftBorder, v, i == xPasses ? remainderWidth : fillerWidth, topBorder, zLevel);
            ScreenHelpers.drawTexturedModalRect(matrixStack, x + leftBorder + i * fillerWidth, y + topBorder + canvasHeight, u + leftBorder, v + topBorder + fillerHeight, i == xPasses ? remainderWidth : fillerWidth, bottomBorder, zLevel);
            for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
                ScreenHelpers.drawTexturedModalRect(matrixStack, x + leftBorder + i * fillerWidth, y + topBorder + j * fillerHeight, u + leftBorder, v + topBorder, i == xPasses ? remainderWidth : fillerWidth, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            }
        }
        for (int j = 0; j < yPasses + (remainderHeight > 0 ? 1 : 0); ++j) {
            ScreenHelpers.drawTexturedModalRect(matrixStack, x, y + topBorder + j * fillerHeight, u, v + topBorder, leftBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
            ScreenHelpers.drawTexturedModalRect(matrixStack, x + leftBorder + canvasWidth, y + topBorder + j * fillerHeight, u + leftBorder + fillerWidth, v + topBorder, rightBorder, j == yPasses ? remainderHeight : fillerHeight, zLevel);
        }
    }

    public static void drawTexturedModalRect(MatrixStack matrixStack, int x, int y, int u, int v, int width, int height, float zLevel) {
        float uScale = 0.00390625f;
        float vScale = 0.00390625f;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder wr = tessellator.func_178180_c();
        wr.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        wr.func_227888_a_(matrix, (float)x, (float)(y + height), zLevel).func_225583_a_((float)u * 0.00390625f, (float)(v + height) * 0.00390625f).func_181675_d();
        wr.func_227888_a_(matrix, (float)(x + width), (float)(y + height), zLevel).func_225583_a_((float)(u + width) * 0.00390625f, (float)(v + height) * 0.00390625f).func_181675_d();
        wr.func_227888_a_(matrix, (float)(x + width), (float)y, zLevel).func_225583_a_((float)(u + width) * 0.00390625f, (float)v * 0.00390625f).func_181675_d();
        wr.func_227888_a_(matrix, (float)x, (float)y, zLevel).func_225583_a_((float)u * 0.00390625f, (float)v * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawScaledCustomSizeModalRect(int x, int y, float u, float v, int uWidth, int vHeight, int width, int height, float tileWidth, float tileHeight) {
        float f = 1.0f / tileWidth;
        float f1 = 1.0f / tileHeight;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)x, (double)(y + height), 0.0).func_225583_a_(u * f, (v + (float)vHeight) * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_((u + (float)uWidth) * f, (v + (float)vHeight) * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + width), (double)y, 0.0).func_225583_a_((u + (float)uWidth) * f, v * f1).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, 0.0).func_225583_a_(u * f, v * f1).func_181675_d();
        tessellator.func_78381_a();
    }
}

