/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.serverorder.widget;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.creeperhost.minetogether.lib.serverorder.DefferedValidation;
import net.creeperhost.minetogether.lib.serverorder.IOrderValidation;
import net.creeperhost.minetogether.lib.serverorder.Pair;
import net.creeperhost.minetogether.module.serverorder.screen.PersonalDetailsScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class TextFieldDetails
extends TextFieldWidget {
    private final PersonalDetailsScreen gui;
    private final String displayString;
    private final boolean canBeFocused;
    private final int ourID;
    public boolean isValidated;
    public String validationError = "";
    private String censorText = "";
    private boolean isChangeValidated = false;
    private final String acceptString = new String(Character.toChars(10004));
    private final String denyString = new String(Character.toChars(10006));
    private final ArrayList<IOrderValidation> validators;
    private boolean doNotValidate = false;
    private DefferedValidation pendingValidation = null;

    public TextFieldDetails(PersonalDetailsScreen gui, int id, String displayString, String def, int x, int y, int width, int height, ArrayList<IOrderValidation> validators, boolean canBeFocused) {
        super(Minecraft.func_71410_x().field_71466_p, x, y, width, height, (ITextComponent)new TranslationTextComponent(""));
        this.ourID = id;
        this.validators = validators;
        this.gui = gui;
        this.canBeFocused = canBeFocused;
        this.displayString = displayString;
        this.func_146180_a(def);
        this.func_230996_d_(true);
        this.func_230996_d_(false);
        this.func_146203_f(64);
    }

    public TextFieldDetails(PersonalDetailsScreen gui, int id, String displayString, String def, int x, int y, int width, int height, ArrayList<IOrderValidation> validators, String censorText) {
        this(gui, id, displayString, def, x, y, width, height, validators);
        this.censorText = censorText;
    }

    public TextFieldDetails(PersonalDetailsScreen gui, int id, String displayString, String def, int x, int y, int width, int height, ArrayList<IOrderValidation> validators) {
        this(gui, id, displayString, def, x, y, width, height, validators, true);
    }

    public void checkPendingValidations() {
        if (this.pendingValidation != null && this.pendingValidation.isDone()) {
            this.gui.validationChangedDeferred(this, this.pendingValidation);
            this.isValidated = this.pendingValidation.isValid("");
            this.validationError = this.pendingValidation.getValidationMessage();
            this.pendingValidation.reset();
            this.pendingValidation = null;
        }
    }

    public int getId() {
        return this.ourID;
    }

    public void func_230430_a_(MatrixStack matrixStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        if (!this.censorText.isEmpty()) {
            String text = this.func_146179_b();
            double censorLength = this.censorText.length();
            double mainLength = text.length();
            double timesRaw = mainLength / censorLength;
            int times = (int)Math.ceil(timesRaw);
            String obscure = new String(new char[times]).replace("\u0000", this.censorText).substring(0, (int)mainLength);
            boolean oldNotValidate = this.doNotValidate;
            this.doNotValidate = true;
            this.func_146180_a(obscure);
            super.func_230430_a_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
            this.func_146180_a(text);
            this.doNotValidate = oldNotValidate;
        } else {
            super.func_230430_a_(matrixStack, p_render_1_, p_render_2_, p_render_3_);
        }
        int startX = (this.field_230690_l_ + this.field_230688_j_ + 3) / 2;
        int startY = (this.field_230691_m_ + 4) / 2;
        RenderSystem.scalef((float)2.0f, (float)2.0f, (float)2.0f);
        if (this.isValidated) {
            TextFieldDetails.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)this.acceptString, (int)startX, (int)startY, (int)65280);
        } else {
            TextFieldDetails.func_238476_c_((MatrixStack)matrixStack, (FontRenderer)Minecraft.func_71410_x().field_71466_p, (String)this.denyString, (int)startX, (int)startY, (int)0xFF0000);
        }
        GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
        if (!this.func_230999_j_() && this.func_146179_b().trim().isEmpty()) {
            int x = this.field_230690_l_ + 4;
            int y = this.field_230691_m_ + (this.field_230689_k_ - 8) / 2;
            Minecraft.func_71410_x().field_71466_p.func_238405_a_(matrixStack, "\u00a7o" + this.displayString, (float)x, (float)y, 0xE0E0E0);
        }
    }

    public boolean canBeFocused() {
        return this.canBeFocused;
    }

    private Pair<Boolean, IOrderValidation> validateAtPhase(IOrderValidation.ValidationPhase phase, String string, boolean ignoreAsync) {
        if (this.pendingValidation != null || this.doNotValidate) {
            return new Pair<Boolean, Object>(false, null);
        }
        boolean validatorsExist = false;
        for (IOrderValidation validator : this.validators) {
            if (!validatorsExist && !this.isChangeValidated && phase.equals((Object)IOrderValidation.ValidationPhase.FOCUSLOST)) {
                return new Pair<Boolean, Object>(false, null);
            }
            if (!validator.validationCheckAtPhase(phase)) continue;
            if (validator.isAsync()) {
                if (ignoreAsync) continue;
                this.pendingValidation = (DefferedValidation)validator;
                this.pendingValidation.setPhase(phase);
                this.pendingValidation.doAsync(string);
            }
            validatorsExist = true;
            if (validator.isValid(string)) continue;
            this.gui.validationChanged(this, false, validator, phase);
            return new Pair<Boolean, IOrderValidation>(true, validator);
        }
        if (validatorsExist) {
            this.gui.validationChanged(this, true, null, phase);
        }
        return new Pair<Boolean, Object>(validatorsExist, null);
    }

    private Pair<Boolean, IOrderValidation> validateAtPhase(IOrderValidation.ValidationPhase phase, String string) {
        return this.validateAtPhase(phase, string, false);
    }

    public void func_230996_d_(boolean focused) {
        Pair<Boolean, IOrderValidation> validatorPair;
        if (focused) {
            this.gui.focusedField = this;
            if (!this.canBeFocused) {
                return;
            }
        } else if (this.func_230999_j_() && (validatorPair = this.validateAtPhase(IOrderValidation.ValidationPhase.FOCUSLOST, this.func_146179_b())).getLeft().booleanValue()) {
            IOrderValidation validator = validatorPair.getRight();
            if (validator != null) {
                this.validationError = validator.getValidationMessage();
                this.isValidated = false;
            } else {
                this.validationError = "This is fine";
                this.isValidated = true;
            }
        }
        super.func_230996_d_(focused);
    }

    public void func_146191_b(String string) {
        super.func_146191_b(string);
        Pair<Boolean, IOrderValidation> validatorPair = this.validateAtPhase(IOrderValidation.ValidationPhase.CHANGED, this.func_146179_b());
        if (validatorPair.getLeft().booleanValue()) {
            IOrderValidation validator = validatorPair.getRight();
            if (validator != null) {
                this.validationError = validator.getValidationMessage();
                this.isValidated = false;
                this.isChangeValidated = false;
            } else {
                this.validationError = "This is fine";
                this.isValidated = true;
                this.isChangeValidated = true;
            }
        }
    }

    public void func_146180_a(String string) {
        super.func_146180_a(string);
        Pair<Boolean, IOrderValidation> validatorPair = this.validateAtPhase(IOrderValidation.ValidationPhase.CHANGED, this.func_146179_b());
        if (validatorPair.getLeft().booleanValue()) {
            IOrderValidation validator = validatorPair.getRight();
            if (validator != null) {
                this.validationError = validator.getValidationMessage();
                this.isValidated = false;
                this.isChangeValidated = false;
            } else {
                this.validationError = "This is fine";
                this.isValidated = true;
                this.isChangeValidated = true;
            }
        }
    }
}

