/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.serverorder.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.Order;
import net.creeperhost.minetogether.lib.serverorder.OrderSummary;
import net.creeperhost.minetogether.lib.serverorder.ServerOrderCallbacks;
import net.creeperhost.minetogether.module.serverorder.screen.OrderServerScreen;
import net.creeperhost.minetogethergui.ScreenHelpers;
import net.creeperhost.minetogethergui.widgets.ScreenWell;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class QuoteScreen
extends OrderServerScreen {
    public OrderSummary summary;
    private ScreenWell wellLeft;
    private ScreenWell wellRight;
    private ScreenWell wellBottom;
    private boolean refreshing;
    private int ticks;

    public QuoteScreen(int stepId, Order order) {
        super(stepId, order);
    }

    @Override
    public void func_231160_c_() {
        int start = this.field_230708_k_ / 2 + 10;
        int end = this.field_230708_k_;
        int middle = (end - start) / 2;
        super.func_231160_c_();
        this.wellLeft = new ScreenWell(this.field_230706_i_, this.field_230708_k_ / 2 - 10, 67, this.field_230709_l_ - 88, I18n.func_135052_a((String)"minetogether.quote.vpsfeatures", (Object[])new Object[0]), new ArrayList<String>(), true, 0);
        this.wellRight = new ScreenWell(this.field_230706_i_, this.field_230708_k_, 67, this.field_230709_l_ - 88, I18n.func_135052_a((String)"minetogether.quote.vpsincluded", (Object[])new Object[0]), new ArrayList<String>(), true, this.field_230708_k_ / 2 + 10);
        this.wellBottom = new ScreenWell(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_ - 83, this.field_230709_l_ - 36, "", new ArrayList<String>(), true, 0);
        String name = ServerOrderCallbacks.getCountries().get(this.order.country);
        if (name == null || name.isEmpty()) {
            name = "Failed to load";
        }
        if (this.summary == null && !this.refreshing) {
            this.updateSummary();
        }
        this.buttonNext.func_238482_a_((ITextComponent)new TranslationTextComponent("minetogether.button.order"));
    }

    @Override
    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.func_231165_f_(1);
        QuoteScreen.func_238467_a_((MatrixStack)poseStack, (int)0, (int)(this.field_230709_l_ - 20), (int)this.field_230708_k_, (int)20, (int)-1728053248);
        if (!this.refreshing) {
            if (!this.summary.summaryError.isEmpty()) {
                super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
                QuoteScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"quote.error", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)50, (int)-1);
                QuoteScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)this.summary.summaryError, (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)60, (int)-1);
                return;
            }
            this.wellBottom.render(poseStack);
            this.wellLeft.render(poseStack);
            this.wellRight.render(poseStack);
            QuoteScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)(I18n.func_135052_a((String)"minetogether.quote.requirements", (Object[])new Object[0]) + " " + this.summary.serverHostName.toLowerCase() + " package"), (int)(this.field_230708_k_ / 2), (int)50, (int)-1);
            String formatString = this.summary.prefix + "%1$.2f " + this.summary.suffix;
            String subTotalString = I18n.func_135052_a((String)"minetogether.quote.subtotal", (Object[])new Object[0]) + ":  ";
            int subTotalWidth = this.field_230712_o_.func_78256_a(subTotalString);
            String discountString = I18n.func_135052_a((String)"minetogether.quote.discount", (Object[])new Object[0]) + ":  ";
            int discountWidth = this.field_230712_o_.func_78256_a(discountString);
            String taxString = I18n.func_135052_a((String)"minetogether.quote.tax", (Object[])new Object[0]) + ":  ";
            int taxWidth = this.field_230712_o_.func_78256_a(taxString);
            String totalString = I18n.func_135052_a((String)"minetogether.quote.total", (Object[])new Object[0]) + ":  ";
            int totalWidth = this.field_230712_o_.func_78256_a(totalString);
            int headerSize = Math.max(subTotalWidth, Math.max(taxWidth, Math.max(totalWidth, discountWidth)));
            int subTotalValueWidth = this.field_230712_o_.func_78256_a(String.format(formatString, this.summary.subTotal));
            int discountValueWidth = this.field_230712_o_.func_78256_a(String.format(formatString, this.summary.discount));
            int taxValueWidth = this.field_230712_o_.func_78256_a(String.format(formatString, this.summary.tax));
            int totalValueWidth = this.field_230712_o_.func_78256_a(String.format(formatString, this.summary.tax));
            int maxStringSize = headerSize + Math.max(subTotalValueWidth, Math.max(discountValueWidth, Math.max(taxValueWidth, totalValueWidth)));
            int offset = maxStringSize / 2;
            int otherOffset = (this.field_230708_k_ / 2 - 10) / 2 - offset;
            QuoteScreen.func_238476_c_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)subTotalString, (int)otherOffset, (int)(this.field_230709_l_ - 80), (int)0xFFFFFF);
            QuoteScreen.func_238476_c_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)String.format(formatString, this.summary.preDiscount), (int)(otherOffset + headerSize), (int)(this.field_230709_l_ - 80), (int)0xFFFFFF);
            QuoteScreen.func_238476_c_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)discountString, (int)otherOffset, (int)(this.field_230709_l_ - 70), (int)0xFFFFFF);
            QuoteScreen.func_238476_c_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)String.format(formatString, this.summary.discount), (int)(otherOffset + headerSize), (int)(this.field_230709_l_ - 70), (int)0xFFFFFF);
            QuoteScreen.func_238476_c_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)taxString, (int)otherOffset, (int)(this.field_230709_l_ - 60), (int)0xFFFFFF);
            QuoteScreen.func_238476_c_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)String.format(formatString, this.summary.tax), (int)(otherOffset + headerSize), (int)(this.field_230709_l_ - 60), (int)0xFFFFFF);
            QuoteScreen.func_238476_c_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)totalString, (int)otherOffset, (int)(this.field_230709_l_ - 50), (int)0xFFFFFF);
            QuoteScreen.func_238476_c_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)String.format(formatString, this.summary.total), (int)(otherOffset + headerSize), (int)(this.field_230709_l_ - 50), (int)0xFFFFFF);
            int start = this.field_230708_k_ / 2 + 10;
            int end = this.field_230708_k_;
            int middle = (end - start) / 2;
            int stringStart = this.field_230712_o_.func_78256_a(I18n.func_135052_a((String)"minetogether.quote.figures", (Object[])new Object[0])) / 2;
            QuoteScreen.func_238476_c_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.quote.figures", (Object[])new Object[0]), (int)(start + middle - stringStart), (int)(this.field_230709_l_ - 80), (int)0xFFFFFF);
            QuoteScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)(TextFormatting.BOLD + I18n.func_135052_a((String)ServerOrderCallbacks.getCountries().get(this.order.country), (Object[])new Object[0])), (int)(start + middle), (int)(this.field_230709_l_ - 65), (int)0xFFFFFF);
        } else {
            QuoteScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.quote.refreshing", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)50, (int)-1);
            ScreenHelpers.loadingSpin(partialTicks, this.ticks, this.field_230708_k_ / 2, this.field_230709_l_ / 2, new ItemStack((IItemProvider)Items.field_151082_bd));
        }
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
    }

    public void func_231023_e_() {
        ++this.ticks;
        super.func_231023_e_();
    }

    @Override
    public String getStepName() {
        return I18n.func_135052_a((String)"minetogether.order.screen.generalinfo.quote", (Object[])new Object[0]);
    }

    private void updateSummary() {
        this.refreshing = true;
        this.summary = null;
        Order order = this.order;
        CompletableFuture.runAsync(() -> {
            this.summary = ServerOrderCallbacks.getSummary(order, Config.getInstance().getVersion(), Config.getInstance().getPromo());
            order.productID = this.summary.productID;
            order.currency = this.summary.currency;
            this.wellLeft.lines = this.summary.serverFeatures;
            this.wellRight.lines = this.summary.serverIncluded;
            this.refreshing = false;
        });
    }
}

