/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.serverorder.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.net.URI;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.Order;
import net.creeperhost.minetogether.lib.serverorder.ServerOrderCallbacks;
import net.creeperhost.minetogether.module.serverorder.screen.OrderServerScreen;
import net.creeperhost.minetogethergui.ScreenHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.RenderComponentsUtil;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.ServerList;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.TranslationTextComponent;

public class OrderDetailsScreen
extends OrderServerScreen {
    private boolean placingOrder = false;
    private boolean placedOrder = false;
    private boolean creatingAccount = false;
    private boolean createdAccount = false;
    private String createdAccountError = "";
    private int orderNumber;
    private String invoiceID;
    private String placedOrderError = "";
    private Button buttonInvoice;
    private boolean serverAdded;
    private int ticks = 0;

    public OrderDetailsScreen(int stepId, Order order) {
        super(stepId, order);
        if (order.clientID != null && !order.clientID.isEmpty()) {
            this.creatingAccount = false;
            this.createdAccount = true;
        }
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        this.buttonNext.func_238482_a_((ITextComponent)new TranslationTextComponent("minetogether.button.finish"));
        this.buttonNext.field_230694_p_ = false;
        this.buttonCancel.func_238482_a_((ITextComponent)new TranslationTextComponent("minetogether.order.ordercancel"));
        this.buttonCancel.field_230693_o_ = false;
        this.buttonPrev.field_230693_o_ = false;
        this.buttonPrev.field_230694_p_ = false;
        this.buttonInvoice = (Button)this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 40, this.field_230709_l_ / 2 + 30, 80, 20, (ITextComponent)new TranslationTextComponent("minetogether.button.invoice"), p -> {
            try {
                Util.func_110647_a().func_195642_a(new URI(ServerOrderCallbacks.getPaymentLink(this.invoiceID)));
            }
            catch (Throwable throwable) {
                MineTogether.logger.error("Couldn't open link", throwable);
            }
        }));
        this.buttonNext.field_230694_p_ = true;
        this.buttonNext.field_230693_o_ = true;
        this.buttonInvoice.field_230694_p_ = false;
    }

    public void func_231023_e_() {
        ++this.ticks;
        super.func_231023_e_();
        if (!this.createdAccount && !this.creatingAccount) {
            if (!this.createdAccountError.isEmpty()) {
                this.buttonCancel.field_230693_o_ = true;
                return;
            }
            this.creatingAccount = true;
            CompletableFuture.runAsync(() -> {
                String result = ServerOrderCallbacks.createAccount(this.order, Config.instance.getVersion());
                String[] resultSplit = result.split(":");
                if (resultSplit[0].equals("success")) {
                    this.order.currency = resultSplit[1] != null ? resultSplit[1] : "1";
                    this.order.clientID = resultSplit[2] != null ? resultSplit[2] : "0";
                } else {
                    this.createdAccountError = result;
                    this.createdAccount = true;
                }
                this.creatingAccount = false;
                this.createdAccount = true;
            });
        } else {
            if (this.creatingAccount) {
                return;
            }
            if (!this.createdAccountError.isEmpty()) {
                this.buttonCancel.field_230693_o_ = true;
                return;
            }
            if (!this.placingOrder && !this.placedOrder) {
                this.placingOrder = true;
                this.buttonNext.field_230693_o_ = false;
                Runnable runnable = () -> {
                    String result = ServerOrderCallbacks.createOrder(this.order, Config.getInstance().getVersion(), String.valueOf(Config.getInstance().getPregenDiameter()));
                    String[] resultSplit = result.split(":");
                    if (resultSplit[0].equals("success")) {
                        this.invoiceID = resultSplit[1] != null ? resultSplit[1] : "0";
                        this.orderNumber = Integer.parseInt(resultSplit[2]);
                    } else {
                        this.placedOrderError = result;
                    }
                    this.placedOrder = true;
                    this.placingOrder = false;
                };
                Thread thread = new Thread(runnable);
                thread.start();
                this.buttonCancel.field_230693_o_ = false;
            } else {
                if (this.placingOrder) {
                    return;
                }
                if (this.placedOrderError.isEmpty()) {
                    if (!this.serverAdded) {
                        this.serverAdded = this.addServerEntry();
                    }
                    this.buttonInvoice.field_230694_p_ = true;
                    this.buttonNext.field_230694_p_ = true;
                    this.buttonCancel.field_230693_o_ = false;
                    this.buttonNext.field_230693_o_ = true;
                } else {
                    this.buttonNext.field_230693_o_ = true;
                }
            }
        }
        this.buttonCancel.field_230693_o_ = this.placedOrder;
    }

    public boolean addServerEntry() {
        ServerList savedServerList = new ServerList(this.field_230706_i_);
        savedServerList.func_78853_a();
        savedServerList.func_78849_a(this.getServerEntry(this.order));
        savedServerList.func_78855_b();
        return true;
    }

    public ServerData getServerEntry(Order order) {
        return new ServerData(order.name + ".PlayAt.CH", order.name + ".playat.ch", false);
    }

    @Override
    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_231165_f_(0);
        OrderDetailsScreen.func_238467_a_((MatrixStack)matrixStack, (int)0, (int)(this.field_230709_l_ - 20), (int)this.field_230708_k_, (int)20, (int)-1728053248);
        if (this.creatingAccount) {
            OrderDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.order.accountcreating", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)0xFFFFFF);
        } else if (!this.createdAccountError.isEmpty()) {
            OrderDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.order.accounterror", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)0xFFFFFF);
            List list = RenderComponentsUtil.func_238505_a_((ITextProperties)new TranslationTextComponent(this.createdAccountError), (int)(this.field_230708_k_ - 30), (FontRenderer)this.field_230712_o_);
            int offset = 10;
            for (IReorderingProcessor str : list) {
                this.drawCenteredString(matrixStack, str, this.field_230708_k_ / 2, this.field_230709_l_ / 2 + offset, 0xFFFFFF);
                offset += 10;
            }
            OrderDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.order.accounterrorgoback", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + offset), (int)0xFFFFFF);
        } else if (this.placingOrder) {
            OrderDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.order.orderplacing", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)0xFFFFFF);
            ScreenHelpers.loadingSpin(partialTicks, this.ticks, this.field_230708_k_ / 2, this.field_230709_l_ / 2 + 20, new ItemStack((IItemProvider)Items.field_151082_bd));
        } else if (!this.placedOrderError.isEmpty()) {
            OrderDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.order.ordererror", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)0xFFFFFF);
            List list = RenderComponentsUtil.func_238505_a_((ITextProperties)new TranslationTextComponent(this.placedOrderError), (int)(this.field_230708_k_ - 30), (FontRenderer)this.field_230712_o_);
            int offset = 10;
            for (IReorderingProcessor str : list) {
                this.drawCenteredString(matrixStack, str, this.field_230708_k_ / 2, this.field_230709_l_ / 2 + offset, 0xFFFFFF);
                offset += 10;
            }
            OrderDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.order.ordererrorsupport", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 + offset), (int)0xFFFFFF);
        } else {
            OrderDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.order.ordersuccess", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)0xFFFFFF);
            OrderDetailsScreen.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)I18n.func_135052_a((String)"minetogether.order.ordermodpack", (Object[])new Object[0]), (int)(this.field_230708_k_ / 2 + 10), (int)(this.field_230709_l_ / 2 + 10), (int)0xFFFFFF);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void drawCenteredString(MatrixStack matrixStack, IReorderingProcessor text, int x, int y, int color) {
        Minecraft.func_71410_x().field_71466_p.func_238407_a_(matrixStack, text, (float)(x - Minecraft.func_71410_x().field_71466_p.func_243245_a(text) / 2), (float)y, color);
    }

    @Override
    public void cancelOrder() {
        ServerOrderCallbacks.cancelOrder(this.orderNumber);
        super.cancelOrder();
    }

    @Override
    public String getStepName() {
        return I18n.func_135052_a((String)"minetogether.screen.order", (Object[])new Object[0]);
    }
}

