/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.serverorder.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Locale;
import java.util.Map;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.lib.Order;
import net.creeperhost.minetogether.lib.serverorder.ServerOrderCallbacks;
import net.creeperhost.minetogether.module.serverorder.screen.OrderServerScreen;
import net.creeperhost.minetogether.module.serverorder.widget.ButtonMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;

public class MapScreen
extends OrderServerScreen {
    private final ResourceLocation siv = new ResourceLocation("minetogether", "textures/guisiv.png");
    private Button currentFocus;
    private Map<String, String> regions;
    private Map<String, String> dataCenters;
    private String distance = "";

    public MapScreen(int stepId, Order order) {
        super(stepId, order);
    }

    @Override
    public void func_231160_c_() {
        super.func_231160_c_();
        int y = this.field_230709_l_ / 2 + 20;
        this.regions = ServerOrderCallbacks.getRegionMap();
        this.dataCenters = ServerOrderCallbacks.getDataCentres();
        if (this.order.country == null || this.order.country.isEmpty()) {
            this.order.country = ServerOrderCallbacks.getUserCountry();
        }
        if (this.order.serverLocation == null || this.order.serverLocation.isEmpty()) {
            this.order.serverLocation = ServerOrderCallbacks.getRecommendedLocation();
        }
        float scalingFactor = 8.0f;
        int nawestX = 413;
        int nawestY = 398;
        int nasouthX = 422;
        int nasouthY = 266;
        int naeastX = 420;
        int naeastY = 416;
        int southamericaX = 492;
        int southamericaY = 768;
        int greenlandX = 407;
        int greenlandY = 194;
        int euwestX = 422;
        int euwestY = 354;
        int eumiddleeastX = 567;
        int eumiddleeastY = 547;
        int russiaX = 1150;
        int russiaY = 540;
        int asiaX = 687;
        int asiaY = 602;
        int australiaX = 673;
        int australiaY = 511;
        int subsaharanafricaX = 664;
        int subsaharanafricaY = 518;
        int northafricaX = 669;
        int northafricaY = 288;
        float halfWidth = (float)this.field_230708_k_ / 2.0f;
        this.func_230480_a_((Widget)new ButtonMap(halfWidth - 228.0f, (float)y - 94.0f, (int)((float)nawestX / scalingFactor), (int)((float)nawestY / scalingFactor), (int)(1024.0f / scalingFactor), (int)(1024.0f / scalingFactor), "na-west", false, this::updateSelected));
        this.func_230480_a_((Widget)new ButtonMap(halfWidth - 207.0f, (float)y - 44.8f, (int)((float)nasouthX / scalingFactor), (int)((float)nasouthY / scalingFactor), (int)(1024.0f / scalingFactor), (int)(1024.0f / scalingFactor), "na-south", false, this::updateSelected));
        this.func_230480_a_((Widget)new ButtonMap(halfWidth - 176.5f, (float)y - 96.5f, (int)((float)naeastX / scalingFactor), (int)((float)naeastY / scalingFactor), (int)(1024.0f / scalingFactor), (int)(1024.0f / scalingFactor), "na-east", false, this::updateSelected));
        this.func_230480_a_((Widget)new ButtonMap(halfWidth - 171.8f, (float)y - 19.5f, (int)((float)southamericaX / scalingFactor), (int)((float)southamericaY / scalingFactor), (int)(1024.0f / scalingFactor), (int)(1024.0f / scalingFactor), "south-america", false, this::updateSelected));
        this.func_230480_a_((Widget)new ButtonMap(halfWidth - 115.0f, (float)y - 122.0f, (int)((float)greenlandX / scalingFactor), (int)((float)greenlandY / scalingFactor), (int)(1024.0f / scalingFactor), (int)(1024.0f / scalingFactor), "greenland", false, this::updateSelected));
        this.func_230480_a_((Widget)new ButtonMap(halfWidth - 30.8f, (float)y - 101.2f, (int)((float)euwestX / scalingFactor), (int)((float)euwestY / scalingFactor), (int)(1024.0f / scalingFactor), (int)(1024.0f / scalingFactor), "eu-west", false, this::updateSelected));
        this.func_230480_a_((Widget)new ButtonMap(halfWidth - 0.5f, (float)y - 95.0f, (int)((float)eumiddleeastX / scalingFactor), (int)((float)eumiddleeastY / scalingFactor), (int)(1024.0f / scalingFactor), (int)(1024.0f / scalingFactor), "eu-middle-east", false, this::updateSelected));
        this.func_230480_a_((Widget)new ButtonMap(halfWidth + 24.0f, (float)y - 114.0f, (int)((float)russiaX / scalingFactor), (int)((float)russiaY / scalingFactor), (int)(2048.0f / scalingFactor), (int)(2048.0f / scalingFactor), "russia", false, this::updateSelected));
        this.func_230480_a_((Widget)new ButtonMap(halfWidth + 64.5f, (float)y - 69.0f, (int)((float)asiaX / scalingFactor), (int)((float)asiaY / scalingFactor), (int)(1024.0f / scalingFactor), (int)(1024.0f / scalingFactor), "asia", false, this::updateSelected));
        this.func_230480_a_((Widget)new ButtonMap(halfWidth + 119.5f, (float)y - 5.5f, (int)((float)australiaX / scalingFactor), (int)((float)australiaY / scalingFactor), (int)(1024.0f / scalingFactor), (int)(1024.0f / scalingFactor), "australia", false, this::updateSelected));
        this.func_230480_a_((Widget)new ButtonMap(halfWidth - 35.8f, (float)y - 23.2f, (int)((float)subsaharanafricaX / scalingFactor), (int)((float)subsaharanafricaY / scalingFactor), (int)(1024.0f / scalingFactor), (int)(1024.0f / scalingFactor), "sub-saharan-africa", false, this::updateSelected));
        this.func_230480_a_((Widget)new ButtonMap(halfWidth - 41.4f, (float)y - 57.7f, (int)((float)northafricaX / scalingFactor), (int)((float)northafricaY / scalingFactor), (int)(1024.0f / scalingFactor), (int)(1024.0f / scalingFactor), "north-africa", false, this::updateSelected));
        if (this.regions != null && !this.regions.isEmpty()) {
            try {
                this.regions.forEach((s2, s22) -> this.field_230710_m_.forEach(widget -> {
                    if (widget.func_230458_i_().getString().equalsIgnoreCase((String)s2)) {
                        widget.field_230693_o_ = true;
                    }
                    if (this.order.serverLocation != null && (widget.func_230458_i_().getString().equalsIgnoreCase(this.datacentreToRegion(this.order.serverLocation)) || widget.func_230458_i_().getString().equalsIgnoreCase(this.order.serverLocation))) {
                        this.updateSelected((Button)widget);
                        if (this.dataCenters != null && this.distance.isEmpty()) {
                            this.distance = this.dataCenters.get(this.order.serverLocation);
                        }
                    }
                }));
            }
            catch (Exception ignored) {
                MineTogether.logger.error("Failed to get region map data");
            }
        }
    }

    private void updateSelected(Button button) {
        try {
            if (this.currentFocus != null) {
                this.currentFocus.func_231049_c__(false);
            }
            this.currentFocus = button;
            button.func_231049_c__(true);
            if (this.dataCenters != null && !this.dataCenters.isEmpty()) {
                this.distance = this.dataCenters.get(this.regionToDataCentre(this.currentFocus.func_230458_i_().getString()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void func_230430_a_(MatrixStack poseStack, int p_render_1_, int p_render_2_, float p_render_3_) {
        this.func_231165_f_(1);
        MapScreen.func_238467_a_((MatrixStack)poseStack, (int)0, (int)(this.field_230709_l_ - 20), (int)this.field_230708_k_, (int)20, (int)-1728053248);
        super.func_230430_a_(poseStack, p_render_1_, p_render_2_, p_render_3_);
        if (this.currentFocus != null) {
            this.field_230706_i_.func_110434_K().func_110577_a(this.siv);
            int x = this.field_230712_o_.func_78256_a(MapScreen.ttl(this.currentFocus.func_230458_i_().getString()));
            int bufferLeft = 20;
            this.func_238474_b_(poseStack, this.field_230708_k_ - bufferLeft - x - 5, 20, 0, 0, x + bufferLeft, 20);
            MapScreen.func_238476_c_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)MapScreen.ttl(this.currentFocus.func_230458_i_().getString()), (int)(this.field_230708_k_ - x - bufferLeft), (int)26, (int)-1);
            Minecraft.func_71410_x().func_110434_K().func_110577_a(field_230665_h_);
            if (this.distance != null && !this.distance.isEmpty()) {
                Screen.func_238466_a_((MatrixStack)poseStack, (int)(this.field_230708_k_ - 18), (int)26, (int)8, (int)8, (float)0.0f, (float)this.distanceConvert(Integer.parseInt(this.distance)), (int)8, (int)8, (int)256, (int)256);
            }
        }
    }

    public static String ttl(String input) {
        String key = "minetogether.region." + input.toLowerCase(Locale.ROOT);
        if (I18n.func_188566_a((String)key)) {
            return I18n.func_135052_a((String)key, (Object[])new Object[0]);
        }
        return input;
    }

    public int distanceConvert(int distance) {
        if (distance < 1000) {
            return 16;
        }
        if (distance > 1000 && distance < 5000) {
            return 32;
        }
        if (distance > 5000 && distance < 6000) {
            return 40;
        }
        return 48;
    }

    public String datacentreToRegion(String centre) {
        switch (centre) {
            case "grantham": {
                return "eu-west";
            }
            case "buffalo": {
                return "na-east";
            }
            case "chicago": {
                return "na-east";
            }
            case "miami": {
                return "na-south";
            }
            case "dallas": {
                return "na-south";
            }
            case "seattle": {
                return "na-west";
            }
            case "losangeles": {
                return "na-west";
            }
            case "johannesburg": {
                return "sub-saharan-africa";
            }
            case "tokyo": {
                return "asia";
            }
            case "saopaulo": {
                return "south-america";
            }
            case "hongkong": {
                return "asia";
            }
            case "sydney": {
                return "australia";
            }
            case "bucharest": {
                return "eu-middle-east";
            }
        }
        return "";
    }

    public String regionToDataCentre(String region) {
        switch (region) {
            case "eu-west": {
                return "grantham";
            }
            case "na-east": {
                return "buffalo";
            }
            case "na-west": {
                return "losangeles";
            }
            case "na-south": {
                return "dallas";
            }
            case "sub-saharan-africa": {
                return "johannesburg";
            }
            case "south-america": {
                return "saopaulo";
            }
            case "asia": {
                return "hongkong";
            }
            case "australia": {
                return "sydney";
            }
            case "eu-middle-east": {
                return "bucharest";
            }
        }
        return "";
    }

    @Override
    public String getStepName() {
        return I18n.func_135052_a((String)"minetogether.screen.server_location", (Object[])new Object[0]);
    }
}

