/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.connect;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.LifecycleEvent;
import me.shedaniel.architectury.hooks.ScreenHooks;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.module.connect.ConnectHandler;
import net.creeperhost.minetogether.module.connect.ConnectHelper;
import net.creeperhost.minetogether.module.connect.GuiShareToFriends;
import net.creeperhost.minetogethergui.ScreenHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.ConfirmOpenLinkScreen;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.integrated.IntegratedServer;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class ConnectModule {
    public static Executor connectExecutor = Executors.newSingleThreadExecutor();
    public static boolean isInitted = false;

    public static void init() {
        CompletableFuture.runAsync(ConnectHandler::connectToProc, connectExecutor);
        isInitted = true;
        Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("minetogether-connect-%d").build());
        GuiEvent.INIT_POST.register(ConnectModule::onScreenOpen);
        LifecycleEvent.SERVER_STOPPING.register(ConnectModule::onServerStopping);
    }

    public static void onServerStopping(MinecraftServer server) {
        if (ConnectHelper.isShared(server)) {
            ConnectHandler.close();
        }
    }

    private static void onScreenOpen(Screen screen, List<Widget> abstractWidgets, List<IGuiEventListener> guiEventListeners) {
        IntegratedServer integratedServer;
        if (screen instanceof IngameMenuScreen && (integratedServer = Minecraft.func_71410_x().func_71401_C()) != null) {
            Widget feedBack = ScreenHelpers.removeButton("menu.sendFeedback", abstractWidgets);
            Widget bugs = ScreenHelpers.removeButton("menu.reportBugs", abstractWidgets);
            Widget openToLan = ScreenHelpers.findButton("menu.shareToLan", abstractWidgets);
            Widget options = ScreenHelpers.findButton("menu.options", abstractWidgets);
            if (openToLan != null && feedBack != null) {
                openToLan.field_230691_m_ = feedBack.field_230691_m_;
            }
            Button guiButton = new Button(screen.field_230708_k_ / 2 - 100, screen.field_230709_l_ / 4 + 72 + -16, 98, 20, (ITextComponent)new TranslationTextComponent("minetogether.connect.open"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new GuiShareToFriends(screen)));
            guiButton.field_230693_o_ = !integratedServer.func_71344_c();
            ScreenHooks.addButton((Screen)screen, (Widget)guiButton);
            if (bugs == null || feedBack == null) {
                return;
            }
            Button ourFeedback = new Button(bugs.field_230690_l_, options.field_230691_m_, feedBack.func_230998_h_(), 20, (ITextComponent)new TranslationTextComponent("menu.reportBugs"), button -> {
                String s2 = Config.getInstance().getIssueTrackerUrl();
                Minecraft.func_71410_x().func_147108_a((Screen)new ConfirmOpenLinkScreen(p_213069_2_ -> {
                    if (p_213069_2_) {
                        Util.func_110647_a().func_195640_a(s2);
                    }
                    Minecraft.func_71410_x().func_147108_a(screen);
                }, s2, true));
            });
            ScreenHooks.addButton((Screen)screen, (Widget)ourFeedback);
        }
    }
}

