/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat.screen.social;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.handler.ToastHandler;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.module.chat.screen.social.MineTogetherSocialChatScreen;
import net.creeperhost.minetogether.module.chat.screen.social.MineTogetherSocialInteractionsScreen;
import net.creeperhost.minetogethergui.widgets.ButtonString;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.client.gui.widget.list.AbstractOptionList;
import net.minecraft.util.ColorHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class ProfileEntry
extends AbstractOptionList.Entry<ProfileEntry> {
    private final Profile profile;
    private final List<IGuiEventListener> children;
    private final Minecraft minecraft = Minecraft.func_71410_x();
    private final Button removeButton;
    private final Button addToPartyButton;
    private final Button muteButton;
    private final Button openDMButton;
    private final MineTogetherSocialInteractionsScreen mineTogetherSocialinteractionsScreen;

    public ProfileEntry(Profile profile, MineTogetherSocialInteractionsScreen mineTogetherSocialinteractionsScreen) {
        this.profile = profile;
        this.mineTogetherSocialinteractionsScreen = mineTogetherSocialinteractionsScreen;
        this.removeButton = new ButtonString(0, 0, 10, 10, (ITextComponent)new TranslationTextComponent(TextFormatting.RED + new String(Character.toChars(10006))), button -> {
            switch (this.mineTogetherSocialinteractionsScreen.getPage()) {
                case BLOCKED: {
                    ChatModule.unmuteUser(profile.getLongHash());
                    this.refreshPage();
                    break;
                }
                case FRIENDS: {
                    ChatCallbacks.removeFriend(profile.getFriendCode(), MineTogetherClient.getPlayerHash());
                    profile.setFriend(false);
                    KnownUsers.update(profile);
                    this.refreshPage();
                    break;
                }
                case PARTY: {
                    profile.setPartyMember(false);
                    KnownUsers.update(profile);
                    this.refreshPage();
                }
            }
        });
        this.addToPartyButton = new ButtonString(0, 0, 10, 10, (ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + new String(Character.toChars(10010))), button -> {
            switch (this.mineTogetherSocialinteractionsScreen.getPage()) {
                case FRIENDS: {
                    String name;
                    String string = name = profile.isFriend() ? profile.getFriendName() : profile.getUserDisplay();
                    if (profile.isOnline()) {
                        MineTogetherClient.toastHandler.displayToast((ITextComponent)new TranslationTextComponent("Adding " + name + " to Party"), mineTogetherSocialinteractionsScreen.field_230708_k_ - 160, 0, 5000, ToastHandler.EnumToastType.DEFAULT, null);
                        ChatHandler.sendPartyInvite(profile.getMediumHash(), MineTogetherChat.profile.get().getMediumHash());
                    } else {
                        MineTogetherClient.toastHandler.displayToast((ITextComponent)new TranslationTextComponent("Unable to send invite      " + name + " is offline"), mineTogetherSocialinteractionsScreen.field_230708_k_ - 160, 0, 5000, ToastHandler.EnumToastType.WARNING, null);
                    }
                    this.refreshPage();
                }
            }
        });
        this.muteButton = new ImageButton(0, 0, 20, 20, 20, 38, 20, Constants.SOCIAL_INTERACTIONS_LOCATION, 256, 256, button -> {
            ChatModule.muteUser(profile.getLongHash());
            this.refreshPage();
        });
        this.openDMButton = new ImageButton(0, 0, 20, 20, 0, 38, 20, Constants.SOCIAL_INTERACTIONS_LOCATION, 256, 256, button -> {
            if (profile != null) {
                if (profile.isOnline()) {
                    Minecraft.func_71410_x().func_147108_a((Screen)new MineTogetherSocialChatScreen((Screen)mineTogetherSocialinteractionsScreen, profile));
                } else {
                    MineTogetherClient.toastHandler.displayToast((ITextComponent)new TranslationTextComponent("User is offline"), 1000, ToastHandler.EnumToastType.WARNING, null);
                }
            }
        });
        this.children = ImmutableList.of(this.removeButton, this.addToPartyButton, this.muteButton, this.openDMButton);
    }

    public void refreshPage() {
        this.mineTogetherSocialinteractionsScreen.showPage(this.mineTogetherSocialinteractionsScreen.getPage());
    }

    public void func_230432_a_(MatrixStack poseStack, int i, int j, int k, int l, int m3, int n, int o, boolean bl, float f) {
        int t;
        int p = k + 4;
        int q = j + (m3 - 24) / 2;
        int r = p + 24 + 4;
        TranslationTextComponent component = new TranslationTextComponent(this.profile.getUserDisplay());
        if (component.equals(StringTextComponent.field_240750_d_)) {
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)k, (int)j, (int)(k + l), (int)(j + m3), (int)ColorHelper.PackedColor.func_233006_a_((int)255, (int)74, (int)74, (int)74));
            t = j + (m3 - 9) / 2;
        } else {
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)k, (int)j, (int)(k + l), (int)(j + m3), (int)ColorHelper.PackedColor.func_233006_a_((int)255, (int)48, (int)48, (int)48));
            t = j + (m3 - 18) / 2;
            this.minecraft.field_71466_p.func_243248_b(poseStack, (ITextComponent)component, (float)p, (float)(t + 12), ColorHelper.PackedColor.func_233006_a_((int)140, (int)255, (int)255, (int)255));
        }
        this.minecraft.field_71466_p.func_238421_b_(poseStack, this.profile.isFriend() ? this.profile.getFriendName() : this.profile.getUserDisplay(), (float)p, (float)t, ColorHelper.PackedColor.func_233006_a_((int)255, (int)255, (int)255, (int)255));
        if (this.mineTogetherSocialinteractionsScreen.getPage() == MineTogetherSocialInteractionsScreen.Page.FRIENDS) {
            this.addToPartyButton.field_230690_l_ = k + (l - this.addToPartyButton.func_230998_h_() - 4);
            this.addToPartyButton.field_230691_m_ = j + ((m3 - this.addToPartyButton.func_238483_d_()) / 2 + 10);
            this.addToPartyButton.func_230430_a_(poseStack, n, o, f);
            this.addToPartyButton.field_230693_o_ = true;
        } else {
            this.addToPartyButton.field_230690_l_ = 0;
            this.addToPartyButton.field_230691_m_ = 0;
        }
        if (this.removeButton != null && this.mineTogetherSocialinteractionsScreen.getPage() != MineTogetherSocialInteractionsScreen.Page.ALL) {
            this.removeButton.field_230690_l_ = k + (l - this.removeButton.func_230998_h_() - 4);
            this.removeButton.field_230691_m_ = j + ((m3 - this.removeButton.func_238483_d_()) / 2 - 10);
            this.removeButton.func_230430_a_(poseStack, n, o, f);
            this.openDMButton.field_230690_l_ = k + (l - this.openDMButton.func_230998_h_() - 4 - 15);
            this.openDMButton.field_230691_m_ = j + (m3 - this.openDMButton.func_238483_d_()) / 2;
            this.openDMButton.func_230430_a_(poseStack, n, o, f);
        } else {
            if (this.removeButton != null) {
                this.removeButton.field_230690_l_ = 0;
                this.removeButton.field_230691_m_ = 0;
            }
            if (this.openDMButton != null && this.muteButton != null) {
                this.muteButton.field_230690_l_ = k + (l - this.muteButton.func_230998_h_() - 4) - 20;
                this.muteButton.field_230691_m_ = j + (m3 - this.muteButton.func_238483_d_()) / 2;
                if (this.profile.isMuted()) {
                    this.muteButton.field_230693_o_ = false;
                }
                this.muteButton.func_230430_a_(poseStack, n, o, f);
                this.openDMButton.field_230690_l_ = k + (l - this.openDMButton.func_230998_h_() - 4);
                this.openDMButton.field_230691_m_ = j + (m3 - this.openDMButton.func_238483_d_()) / 2;
                this.openDMButton.func_230430_a_(poseStack, n, o, f);
            }
        }
    }

    public void renderTooltips(MatrixStack poseStack, int mouseX, int mouseY) {
        if (this.removeButton.func_230449_g_()) {
            TranslationTextComponent component1 = new TranslationTextComponent("");
            switch (this.mineTogetherSocialinteractionsScreen.getPage()) {
                case PARTY: {
                    component1 = new TranslationTextComponent("Remove from party");
                    break;
                }
                case FRIENDS: {
                    component1 = new TranslationTextComponent("Remove Friend");
                    break;
                }
                case BLOCKED: {
                    component1 = new TranslationTextComponent("Unblock");
                }
            }
            this.mineTogetherSocialinteractionsScreen.func_238652_a_(poseStack, (ITextComponent)component1, mouseX, mouseY);
        }
        if (this.addToPartyButton.func_230449_g_()) {
            this.mineTogetherSocialinteractionsScreen.func_238652_a_(poseStack, (ITextComponent)new TranslationTextComponent("Add to party"), mouseX, mouseY);
        }
        if (this.openDMButton.func_230449_g_()) {
            this.mineTogetherSocialinteractionsScreen.func_238652_a_(poseStack, (ITextComponent)new TranslationTextComponent("Direct messages"), mouseX, mouseY);
        }
        if (this.muteButton.func_230449_g_()) {
            this.mineTogetherSocialinteractionsScreen.func_238652_a_(poseStack, (ITextComponent)new TranslationTextComponent("Block"), mouseX, mouseY);
        }
    }

    public List<IGuiEventListener> getChildren() {
        return this.children;
    }

    public List<? extends IGuiEventListener> func_231039_at__() {
        return this.children;
    }

    public Profile getProfile() {
        return this.profile;
    }
}

