/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatConnectionStatus;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.lib.chat.irc.IrcHandler;
import net.creeperhost.minetogether.module.chat.ChatFormatter;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.module.chat.ScrollingChat;
import net.creeperhost.minetogether.module.chat.Target;
import net.creeperhost.minetogether.module.chat.screen.FriendRequestScreen;
import net.creeperhost.minetogether.module.chat.screen.FriendsListScreen;
import net.creeperhost.minetogether.screen.MineTogetherScreen;
import net.creeperhost.minetogether.screen.SettingsScreen;
import net.creeperhost.minetogethergui.widgets.ButtonMultiple;
import net.creeperhost.minetogethergui.widgets.ButtonNoBlend;
import net.creeperhost.minetogethergui.widgets.ButtonString;
import net.creeperhost.minetogethergui.widgets.DropdownButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import org.jetbrains.annotations.Nullable;

public class ChatScreen
extends MineTogetherScreen {
    private final Screen parent;
    private ScrollingChat chat;
    private TextFieldWidget send;
    private String currentTarget = ChatHandler.CHANNEL;
    private ButtonString connectionStatus;
    public DropdownButton<Target> targetDropdownButton;
    private DropdownButton<Menu> menuDropdownButton;
    private String activeDropdown;
    private Button newUserButton;
    private Button disableButton;
    private Button friendsList;

    public ChatScreen(Screen parent) {
        super((ITextComponent)new TranslationTextComponent("MineTogether Chat"));
        this.parent = parent;
    }

    public ChatScreen(Screen parent, String currentTarget) {
        super((ITextComponent)new TranslationTextComponent("MineTogether Chat"));
        this.parent = parent;
        this.currentTarget = currentTarget;
    }

    public void func_231160_c_() {
        this.field_230706_i_.field_195559_v.func_197967_a(true);
        this.chat = new ScrollingChat(this, this.field_230708_k_, this.field_230709_l_, 13);
        this.chat.func_230959_g_(10);
        this.chat.updateLines(this.currentTarget);
        this.send = new TextFieldWidget(this.field_230706_i_.field_71466_p, 11, this.field_230709_l_ - 48, this.field_230708_k_ - 22, 20, (ITextComponent)new TranslationTextComponent(""));
        this.send.func_146195_b(true);
        this.send.func_146203_f(256);
        this.addButtons();
        super.func_231160_c_();
    }

    public void addButtons() {
        this.targetDropdownButton = new DropdownButton<Target>(this.field_230708_k_ - 5 - 100, 5, 100, 20, (ITextComponent)new TranslationTextComponent("Chat: %s"), Target.getMainTarget(), true, p -> {
            if (!this.targetDropdownButton.dropdownOpen) {
                return;
            }
            if (!this.targetDropdownButton.getSelected().getInternalTarget().equals(this.currentTarget)) {
                this.currentTarget = this.targetDropdownButton.getSelected().getInternalTarget();
            }
            this.chat.updateLines(this.currentTarget);
            this.targetDropdownButton.wasJustClosed = false;
            this.targetDropdownButton.dropdownOpen = false;
        });
        this.func_230480_a_((Widget)this.targetDropdownButton);
        this.targetDropdownButton.setSelected(Target.getMainTarget());
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(I18n.func_135052_a((String)"minetogether.chat.button.mute", (Object[])new Object[0]));
        strings.add(I18n.func_135052_a((String)"minetogether.chat.button.addfriend", (Object[])new Object[0]));
        strings.add(I18n.func_135052_a((String)"minetogether.chat.button.mention", (Object[])new Object[0]));
        this.menuDropdownButton = new DropdownButton<Menu>(-1000, -1000, 100, 20, (ITextComponent)new TranslationTextComponent("Menu"), new Menu(strings), false, p -> {
            if (!this.menuDropdownButton.dropdownOpen) {
                return;
            }
            if (this.menuDropdownButton.getSelected().option.equalsIgnoreCase(I18n.func_135052_a((String)"minetogether.chat.button.mute", (Object[])new Object[0]))) {
                Profile profile = KnownUsers.findByDisplay(this.activeDropdown);
                if (profile != null) {
                    ChatModule.muteUser(KnownUsers.findByDisplay((String)this.activeDropdown).longHash);
                    KnownUsers.findByDisplay(this.activeDropdown).setMuted(true);
                    ChatHandler.addStatusMessage("Locally blocked " + this.activeDropdown);
                }
            } else if (this.menuDropdownButton.getSelected().option.equalsIgnoreCase(I18n.func_135052_a((String)"minetogether.chat.button.addfriend", (Object[])new Object[0]))) {
                this.field_230706_i_.func_147108_a((Screen)new FriendRequestScreen(new ChatScreen(this.parent), Minecraft.func_71410_x().func_110432_I().func_111285_a(), KnownUsers.findByDisplay(this.activeDropdown), ChatCallbacks.getFriendCode(MineTogetherClient.getPlayerHash()), "", false, false));
            } else if (this.menuDropdownButton.getSelected().option.equalsIgnoreCase(I18n.func_135052_a((String)"minetogether.chat.button.mention", (Object[])new Object[0]))) {
                this.send.func_146195_b(true);
                this.send.func_146180_a(this.send.func_146179_b() + " " + this.activeDropdown + " ");
            }
            this.menuDropdownButton.field_230691_m_ = -10000;
            this.menuDropdownButton.field_230690_l_ = -10000;
            this.menuDropdownButton.wasJustClosed = false;
            this.menuDropdownButton.dropdownOpen = false;
        }, false);
        this.func_230480_a_((Widget)this.menuDropdownButton);
        this.friendsList = new Button(5, 5, 100, 20, (ITextComponent)new TranslationTextComponent("Friends list"), p -> this.field_230706_i_.func_147108_a((Screen)new FriendsListScreen(this)));
        this.func_230480_a_((Widget)this.friendsList);
        this.func_230480_a_((Widget)new ButtonMultiple(this.field_230708_k_ - 124, 5, 3, Constants.WIDGETS_LOCATION, p -> this.field_230706_i_.func_147108_a((Screen)new SettingsScreen(this))));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ - 100 - 5, this.field_230709_l_ - 5 - 20, 100, 20, (ITextComponent)new TranslationTextComponent("Cancel"), p -> this.field_230706_i_.func_147108_a(this.parent)));
        this.connectionStatus = new ButtonString(8, this.field_230709_l_ - 20, 70, 20, () -> {
            ChatConnectionStatus status = ChatHandler.connectionStatus;
            return new TranslationTextComponent(TextFormatting.func_96300_b((String)status.colour) + "\u2022 " + TextFormatting.WHITE + status.display);
        }, ButtonString.RenderPlace.EXACT, button -> {
            if (ChatHandler.connectionStatus == ChatConnectionStatus.BANNED) {
                ConfirmScreen confirmScreen = new ConfirmScreen(t -> {
                    if (t) {
                        try {
                            Util.func_110647_a().func_195639_a(new URL("https://minetogether.io/profile/standing"));
                        }
                        catch (MalformedURLException e) {
                            e.printStackTrace();
                        }
                    }
                    this.field_230706_i_.func_147108_a((Screen)this);
                }, (ITextComponent)new TranslationTextComponent("minetogether.bannedscreen.line1"), (ITextComponent)new TranslationTextComponent("minetogether.bannedscreen.line2"));
                this.field_230706_i_.func_147108_a((Screen)confirmScreen);
            }
        });
        this.func_230480_a_((Widget)this.connectionStatus);
        if (Config.getInstance().getFirstConnect()) {
            ChatCallbacks.updateOnlineCount();
            this.newUserButton = new ButtonNoBlend(this.field_230708_k_ / 2 - 150, 75 + this.field_230709_l_ / 4, 300, 20, (ITextComponent)new TranslationTextComponent("Join " + ChatCallbacks.onlineCount + " online users now!"), p -> {
                IrcHandler.sendCTCPMessage("Freddy", "ACTIVE", "");
                Config.getInstance().setFirstConnect(false);
                Config.saveConfigToFile(MineTogether.configFile.toFile());
                this.newUserButton.field_230694_p_ = false;
                this.disableButton.field_230694_p_ = false;
                this.field_230706_i_.func_147108_a((Screen)this);
            });
            this.func_230480_a_((Widget)this.newUserButton);
            this.disableButton = new ButtonNoBlend(this.field_230708_k_ / 2 - 150, 95 + this.field_230709_l_ / 4, 300, 20, (ITextComponent)new TranslationTextComponent("Don't ask me again"), p -> {
                Config.getInstance().setChatEnabled(false);
                Config.saveConfigToFile(MineTogether.configFile.toFile());
                this.disableButton.field_230694_p_ = false;
                this.newUserButton.field_230694_p_ = false;
                IrcHandler.stop(true);
                this.field_230710_m_.clear();
                this.field_230706_i_.func_147108_a(this.parent);
            });
            this.func_230480_a_((Widget)this.disableButton);
        }
        IrcHandler.sendCTCPMessage("Freddy", "ACTIVE", "");
    }

    @Override
    public void func_230430_a_(MatrixStack poseStack, int mouseX, int mouseY, float partialTicks) {
        this.func_231165_f_(1);
        this.renderConnectionStatus();
        this.chat.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        this.menuDropdownButton.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        this.send.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
        ChatScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.func_231171_q_(), (int)(this.field_230708_k_ / 2), (int)5, (int)0xFFFFFF);
        if (Config.getInstance().getFirstConnect()) {
            ChatScreen.func_238467_a_((MatrixStack)poseStack, (int)10, (int)this.chat.getTop(), (int)(this.field_230708_k_ - 10), (int)this.chat.getHeight(), (int)-1728053248);
            ChatScreen.func_238467_a_((MatrixStack)poseStack, (int)10, (int)this.chat.getTop(), (int)(this.field_230708_k_ - 10), (int)this.chat.getHeight(), (int)-1728053248);
            RenderSystem.blendColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ChatScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)"Welcome to MineTogether", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 4 + 25), (int)0xFFFFFF);
            ChatScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)"MineTogether is a multiplayer enhancement mod that provides", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 4 + 35), (int)0xFFFFFF);
            ChatScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)"a multitude of features like chat, friends list, server listing", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 4 + 45), (int)0xFFFFFF);
            ChatScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)("and more. Join " + ChatCallbacks.userCount + " unique users."), (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 4 + 55), (int)0xFFFFFF);
        }
        super.func_230430_a_(poseStack, mouseX, mouseY, partialTicks);
    }

    public void renderConnectionStatus() {
        ChatConnectionStatus chatConnectionStatus = ChatHandler.connectionStatus;
        TranslationTextComponent comp = new TranslationTextComponent(TextFormatting.func_96300_b((String)chatConnectionStatus.colour) + "\u2022 " + TextFormatting.WHITE + chatConnectionStatus.display);
        this.connectionStatus.func_238482_a_((ITextComponent)comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_231023_e_() {
        this.chat.tick();
        String buttonTarget = this.targetDropdownButton.getSelected().getInternalTarget();
        if (!buttonTarget.equals(this.currentTarget)) {
            this.currentTarget = buttonTarget;
        }
        this.friendsList.field_230693_o_ = !Config.getInstance().getFirstConnect();
        this.targetDropdownButton.field_230693_o_ = !Config.getInstance().getFirstConnect();
        this.send.field_230693_o_ = ChatHandler.connectionStatus == ChatConnectionStatus.VERIFIED;
        this.send.func_146184_c(ChatHandler.connectionStatus == ChatConnectionStatus.VERIFIED);
        if (this.send.func_230999_j_() && ChatHandler.connectionStatus != ChatConnectionStatus.VERIFIED) {
            this.send.func_146195_b(false);
        }
        switch (ChatHandler.connectionStatus) {
            case VERIFYING: {
                this.send.func_195612_c(I18n.func_135052_a((String)"minetogether.chat.message.unverified", (Object[])new Object[0]));
                break;
            }
            case BANNED: {
                this.send.func_195612_c(I18n.func_135052_a((String)"minetogether.chat.message.banned", (Object[])new Object[0]));
                break;
            }
            case DISCONNECTED: {
                this.send.func_195612_c(I18n.func_135052_a((String)"minetogether.chat.message.disconnect", (Object[])new Object[0]));
                break;
            }
            case CONNECTING: {
                this.send.func_195612_c(I18n.func_135052_a((String)"minetogether.chat.message.connecting", (Object[])new Object[0]));
                break;
            }
            case VERIFIED: {
                this.send.func_195612_c("");
            }
        }
        Object object = ChatHandler.ircLock;
        synchronized (object) {
            if (ChatHandler.hasNewMessages(this.currentTarget)) {
                this.chat.updateLines(this.currentTarget);
                ChatHandler.setMessagesRead(this.currentTarget);
            }
        }
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int mouseButton) {
        if (super.func_231044_a_(mouseX, mouseY, mouseButton)) {
            return true;
        }
        if (this.send.func_231044_a_(mouseX, mouseY, mouseButton)) {
            this.menuDropdownButton.field_230691_m_ = -10000;
            this.menuDropdownButton.field_230690_l_ = -10000;
            this.menuDropdownButton.wasJustClosed = false;
            this.menuDropdownButton.dropdownOpen = false;
            return true;
        }
        if (this.menuDropdownButton.wasJustClosed && !this.menuDropdownButton.dropdownOpen) {
            this.menuDropdownButton.field_230691_m_ = -10000;
            this.menuDropdownButton.field_230690_l_ = -10000;
            this.menuDropdownButton.wasJustClosed = false;
        }
        this.chat.func_231044_a_(mouseX, mouseY, mouseButton);
        return false;
    }

    public boolean func_231045_a_(double d, double e, int i, double f, double g2) {
        this.chat.func_231045_a_(d, e, i, f, g2);
        return super.func_231045_a_(d, e, i, f, g2);
    }

    public boolean func_231043_a_(double d, double e, double f) {
        this.chat.func_231043_a_(d, e, f);
        return super.func_231043_a_(d, e, f);
    }

    @Deprecated
    public void rebuildChat() {
        double scroll = this.chat.func_230966_l_();
        this.chat.updateLines(this.currentTarget);
        this.chat.func_230932_a_(scroll);
    }

    public boolean func_231046_a_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (!(p_keyPressed_1_ != 257 && p_keyPressed_1_ != 335 || this.send.func_146179_b().trim().isEmpty())) {
            ChatHandler.sendMessage(this.currentTarget, ChatFormatter.getStringForSending(this.send.func_146179_b()));
            this.send.func_146180_a("");
        }
        this.send.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
        return super.func_231046_a_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean func_231042_a_(char c, int i) {
        this.send.func_231042_a_(c, i);
        return super.func_231042_a_(c, i);
    }

    @Override
    public boolean handleComponentClicked(@Nullable Style style, double mouseX, double mouseY) {
        if (this.newUserButton != null && this.newUserButton.field_230694_p_) {
            return false;
        }
        if (style == null) {
            return false;
        }
        if (style.func_150235_h() == null) {
            return false;
        }
        ClickEvent event = style.func_150235_h();
        if (event == null) {
            return false;
        }
        if (event.func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND) {
            String eventValue = event.func_150668_b();
            if (eventValue.contains(":")) {
                String[] split = eventValue.split(":");
                if (split.length < 3) {
                    return false;
                }
                String chatInternalName = split[1];
                String friendCode = split[2];
                StringBuilder builder = new StringBuilder();
                for (int i = 3; i < split.length; ++i) {
                    builder.append(split[i]).append(" ");
                }
                String friendName = builder.toString().trim();
                Profile targetProfile = KnownUsers.findByNick(chatInternalName);
                if (targetProfile == null) {
                    targetProfile = KnownUsers.add(chatInternalName);
                }
                Minecraft.func_71410_x().func_147108_a((Screen)new FriendRequestScreen(this, Minecraft.func_71410_x().func_110432_I().func_111285_a(), targetProfile, friendCode, friendName, true, false));
                return true;
            }
            this.menuDropdownButton.field_230690_l_ = (int)mouseX;
            this.menuDropdownButton.field_230691_m_ = (int)mouseY;
            boolean bl = this.menuDropdownButton.flipped = mouseY > 150.0;
            if (!this.menuDropdownButton.flipped) {
                this.menuDropdownButton.field_230691_m_ -= this.menuDropdownButton.func_238483_d_() - 1;
                ++this.menuDropdownButton.field_230690_l_;
            }
            this.menuDropdownButton.dropdownOpen = true;
            this.activeDropdown = event.func_150668_b();
            return true;
        }
        if (event.func_150669_a() == ClickEvent.Action.OPEN_URL) {
            this.func_230455_a_(style);
        }
        return false;
    }

    public static class Menu
    implements DropdownButton.IDropdownOption {
        List<DropdownButton.IDropdownOption> possibleValsCache;
        public String option;

        public Menu(List<String> options) {
            this.possibleValsCache = new ArrayList<DropdownButton.IDropdownOption>();
            this.possibleValsCache.add(this);
            this.option = options.get(0);
            options.remove(0);
            for (String option : options) {
                this.possibleValsCache.add(new Menu(this.possibleValsCache, option));
            }
        }

        public Menu(List<DropdownButton.IDropdownOption> vals, String option) {
            this.possibleValsCache = vals;
            this.option = option;
        }

        @Override
        public String getTranslate(DropdownButton.IDropdownOption current, boolean dropdownOpen) {
            return this.option;
        }

        @Override
        public List<DropdownButton.IDropdownOption> getPossibleVals() {
            return this.possibleValsCache;
        }
    }
}

