/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogethergui.widgets.DropdownButton;
import net.minecraft.util.text.Color;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;

public class Target
implements DropdownButton.IDropdownOption {
    private final String targetName;
    private static ArrayList<Target> possibleValsCache = new ArrayList();
    private static boolean updating = false;
    private final String internalTarget;
    private static Map<String, String> oldFriends;
    private static int oldMessagesSize;
    private final boolean isChannel;
    public static Target privateChannel;

    private Target(String targetName, String internalTarget, boolean isChannel) {
        this.internalTarget = internalTarget;
        this.targetName = targetName;
        this.isChannel = isChannel;
    }

    private Target(String targetName, String internalTarget) {
        this(targetName, internalTarget, false);
    }

    @Override
    public String getTranslate(DropdownButton.IDropdownOption currentDO, boolean dropdownOpen) {
        Target current = (Target)currentDO;
        boolean newMessages = false;
        if (current == this) {
            for (DropdownButton.IDropdownOption targetObj : this.getPossibleVals()) {
                Target target = (Target)targetObj;
                if (!ChatHandler.hasNewMessages(target.getInternalTarget()) || dropdownOpen) continue;
                newMessages = true;
                break;
            }
        } else {
            newMessages = ChatHandler.hasNewMessages(this.getInternalTarget());
        }
        if (newMessages) {
            TranslationTextComponent str = new TranslationTextComponent(this.targetName);
            str.func_230532_e_().func_230529_a_((ITextComponent)new TranslationTextComponent(" \u2022")).func_150256_b().func_240718_a_(Color.func_240744_a_((TextFormatting)TextFormatting.RED));
            return str.getString();
        }
        return this.targetName;
    }

    @Override
    public void updateDynamic() {
        Target.updateCache(this);
    }

    public static void updateCache() {
        Target.updateCache(null);
    }

    public static void updateCache(Target current) {
        if (ChatHandler.messages == null) {
            return;
        }
        int chatSize = ChatHandler.messages.size();
        updating = true;
        ArrayList<Target> oldVals = possibleValsCache;
        LinkedHashSet<Target> tempSet = new LinkedHashSet<Target>();
        if (current != null && current.targetName.equals("Main") && !current.internalTarget.equals(ChatHandler.CHANNEL)) {
            current = new Target("Main", ChatHandler.CHANNEL, true);
        }
        possibleValsCache = new ArrayList();
        tempSet.add(new Target("Main", ChatHandler.CHANNEL, true));
        if (current != null && !tempSet.contains(current)) {
            tempSet.add(current);
        }
        block0: for (String chat : ChatHandler.messages.keySet()) {
            if (chat.equals(ChatHandler.CHANNEL)) continue;
            for (Target target : oldVals) {
                if (!target.getInternalTarget().equals(chat) || target.targetName.equals("Group Chat") && (ChatHandler.currentParty.isEmpty() || !ChatHandler.currentParty.equals(target.internalTarget))) continue;
                tempSet.add(target);
                continue block0;
            }
        }
        if (ChatHandler.hasParty) {
            Target target;
            privateChannel = target = new Target("Group Chat", ChatHandler.currentParty, true);
            tempSet.add(target);
        }
        possibleValsCache = new ArrayList(tempSet);
        updating = false;
        oldFriends = ChatHandler.friends;
        oldMessagesSize = chatSize;
    }

    public static Target getMainTarget() {
        Target.updateCache();
        for (Target defTar : possibleValsCache) {
            if (!defTar.getInternalTarget().equals(ChatHandler.CHANNEL)) continue;
            return defTar;
        }
        return possibleValsCache.size() > 0 ? possibleValsCache.get(0) : new Target("Main", ChatHandler.CHANNEL, true);
    }

    public static Target getTargetFromString(String targetName) {
        Target.updateCache();
        for (Target defTar : possibleValsCache) {
            if (!defTar.getInternalTarget().equals(targetName)) continue;
            return defTar;
        }
        return null;
    }

    @Override
    public List<DropdownButton.IDropdownOption> getPossibleVals() {
        return possibleValsCache;
    }

    public String getInternalTarget() {
        return this.internalTarget;
    }

    public boolean equals(Object obj) {
        return obj instanceof Target && ((Target)obj).internalTarget.equals(this.internalTarget) && ((Target)obj).targetName.equals(this.targetName);
    }

    public static Target getPrivateChannel() {
        return privateChannel;
    }

    public int hashCode() {
        return this.internalTarget.hashCode() + this.targetName.hashCode();
    }

    public boolean isChannel() {
        return this.isChannel;
    }
}

