/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.module.chat;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import me.shedaniel.architectury.hooks.ScreenHooks;
import me.shedaniel.architectury.platform.Platform;
import net.creeperhost.minetogether.Constants;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.mixin.ChatComponentInvoker;
import net.creeperhost.minetogether.module.chat.ClientChatTarget;
import net.creeperhost.minetogether.module.chat.screen.ChatListener;
import net.creeperhost.minetogether.module.chat.screen.ChatScreen;
import net.creeperhost.minetogether.module.chat.screen.FriendsListScreen;
import net.creeperhost.minetogether.screen.SettingsScreen;
import net.creeperhost.minetogether.threads.FriendUpdateThread;
import net.creeperhost.minetogether.verification.ModPackVerifier;
import net.creeperhost.minetogether.verification.SignatureVerifier;
import net.creeperhost.minetogethergui.widgets.ButtonMultiple;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.IngameMenuScreen;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.io.FileUtils;

public class ChatModule {
    public static ClientChatTarget clientChatTarget = ClientChatTarget.DEFAULT;
    public static ClientChatTarget lastSelected = ClientChatTarget.DEFAULT;
    public static boolean hasNewMessage = true;
    public static ArrayList<String> mutedUsers = new ArrayList();
    public static Path mutedUsersPath = Platform.getGameFolder().resolve("local/minetogether/mutedusers.json");
    private static MineTogetherChat mineTogetherChat;

    public static void init() {
        String ourNick = "MT" + ChatCallbacks.getPlayerHash(MineTogetherClient.getUUID()).substring(0, 28);
        FriendUpdateThread.init();
        ChatModule.buildChat(ourNick);
        ChatModule.loadMutedList();
    }

    public static void buildChat(String ourNick) {
        MineTogether.logger.info("Building MineTogether chat");
        boolean online = MineTogetherClient.isOnlineUUID;
        String realName = new ModPackVerifier().verify();
        String signature = new SignatureVerifier().verify();
        String serverID = MineTogetherClient.getServerIDAndVerify();
        mineTogetherChat = new MineTogetherChat(ourNick, MineTogetherClient.getPlayerHash(), online, realName, signature, serverID, ChatListener.INSTANCE);
        mineTogetherChat.startChat();
    }

    public static void onScreenOpen(Screen screen, List<Widget> abstractWidgets, List<IGuiEventListener> guiEventListeners) {
        Button friendsButton = new Button(screen.field_230708_k_ - 105, 5, 100, 20, (ITextComponent)new TranslationTextComponent("minetogether.multiplayer.friends"), p -> Minecraft.func_71410_x().func_147108_a((Screen)new FriendsListScreen(screen)));
        ButtonMultiple chatButton = new ButtonMultiple(screen.field_230708_k_ - 125, 5, Config.getInstance().isChatEnabled() ? 1 : 3, Constants.WIDGETS_LOCATION, p -> Minecraft.func_71410_x().func_147108_a((Screen)(Config.getInstance().isChatEnabled() ? new ChatScreen(screen) : new SettingsScreen(screen))));
        if (screen instanceof MainMenuScreen && Config.getInstance().isEnableMainMenuFriends() && Config.instance.isMainMenuEnabled()) {
            ScreenHooks.addButton((Screen)screen, (Widget)friendsButton);
            ScreenHooks.addButton((Screen)screen, (Widget)chatButton);
            boolean bl = friendsButton.field_230693_o_ = !Config.getInstance().getFirstConnect();
        }
        if (screen instanceof IngameMenuScreen) {
            ScreenHooks.addButton((Screen)screen, (Widget)friendsButton);
            ScreenHooks.addButton((Screen)screen, (Widget)chatButton);
            friendsButton.field_230693_o_ = !Config.getInstance().getFirstConnect();
        }
    }

    public static void sendMessage(String channel, ITextComponent component) {
        if (clientChatTarget != ClientChatTarget.DEFAULT) {
            ClientChatTarget current = clientChatTarget;
            if (channel.equals(ChatHandler.CHANNEL)) {
                clientChatTarget = ClientChatTarget.MINETOGETHER;
                ((ChatComponentInvoker)Minecraft.func_71410_x().field_71456_v.func_146158_b()).invokeAddMessage(component, 0, Minecraft.func_71410_x().field_71456_v.func_73834_c(), false);
            }
            if (ChatHandler.hasParty && channel.equals(ChatHandler.currentParty)) {
                clientChatTarget = ClientChatTarget.PARTY;
                ((ChatComponentInvoker)Minecraft.func_71410_x().field_71456_v.func_146158_b()).invokeAddMessage(component, 0, Minecraft.func_71410_x().field_71456_v.func_73834_c(), false);
            }
            clientChatTarget = current;
        }
    }

    public static void muteUser(String user) {
        if (mutedUsers.contains(user)) {
            return;
        }
        mutedUsers.add(user);
        CompletableFuture.runAsync(() -> {
            Profile profile = KnownUsers.findByHash(user);
            if (profile == null) {
                profile = KnownUsers.add(user);
            }
            profile.loadProfile();
            profile.setMuted(true);
            KnownUsers.update(profile);
        }, MineTogetherChat.profileExecutor);
        Gson gson = new Gson();
        try {
            if (!mutedUsersPath.getParent().toFile().exists()) {
                mutedUsersPath.getParent().toFile().mkdirs();
            }
            FileUtils.writeStringToFile((File)mutedUsersPath.toFile(), (String)gson.toJson(mutedUsers), (Charset)Charset.defaultCharset());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void unmuteUser(String longhash) {
        try {
            mutedUsers.remove(longhash);
            CompletableFuture.runAsync(() -> {
                Profile profile = KnownUsers.findByHash(longhash);
                if (profile == null) {
                    profile = KnownUsers.add(longhash);
                }
                profile.loadProfile();
                profile.setMuted(false);
                KnownUsers.update(profile);
            }, MineTogetherChat.profileExecutor);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Gson gson = new GsonBuilder().disableHtmlEscaping().setPrettyPrinting().create();
        try {
            if (!mutedUsersPath.getParent().toFile().exists()) {
                mutedUsersPath.getParent().toFile().mkdirs();
            }
            FileUtils.writeStringToFile((File)mutedUsersPath.toFile(), (String)gson.toJson(mutedUsers), (Charset)Charset.defaultCharset());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void loadMutedList() {
        Gson gson = new Gson();
        try {
            FileReader fileReader = new FileReader(mutedUsersPath.toFile());
            mutedUsers = gson.fromJson((Reader)fileReader, ArrayList.class);
            for (String s2 : mutedUsers) {
                CompletableFuture.runAsync(() -> {
                    Profile profile = KnownUsers.findByHash(s2);
                    if (profile == null) {
                        profile = KnownUsers.add(s2);
                    }
                    profile.loadProfile();
                    profile.setMuted(true);
                    KnownUsers.update(profile);
                }, MineTogetherChat.profileExecutor);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static MineTogetherChat getMineTogetherChat() {
        return mineTogetherChat;
    }
}

