/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import net.creeperhost.minetogether.MineTogetherClient;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatConnectionStatus;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.lib.chat.irc.IrcHandler;
import net.creeperhost.minetogether.lib.util.MathHelper;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.module.chat.ClientChatTarget;
import net.creeperhost.minetogether.module.chat.screen.ChatScreen;
import net.creeperhost.minetogether.module.chat.screen.FriendRequestScreen;
import net.creeperhost.minetogether.module.chat.screen.widgets.GuiButtonPair;
import net.creeperhost.minetogether.util.ComponentUtils;
import net.creeperhost.minetogethergui.gif.AnimatedGif;
import net.creeperhost.minetogethergui.widgets.ButtonNoBlend;
import net.creeperhost.minetogethergui.widgets.DropdownButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.CommandSuggestionHelper;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChatScreen.class})
public abstract class MixinChatScreen
extends Screen {
    @Shadow
    protected TextFieldWidget field_146415_a;
    @Shadow
    private CommandSuggestionHelper field_228174_e_;
    @Shadow
    private String field_146409_v;
    private GuiButtonPair switchButton;
    private DropdownButton<ChatScreen.Menu> dropdownButton;
    private String currentDropdown;
    private int mouseX;
    private int mouseY;
    private Button newUserButton;
    private Button disableButton;
    private AnimatedGif gifImage;
    private AnimatedGif.GifPlayer gifPlayer;

    @Shadow
    public abstract void func_230430_a_(MatrixStack var1, int var2, int var3, float var4);

    protected MixinChatScreen(ITextComponent component) {
        super(component);
    }

    @Inject(at={@At(value="TAIL")}, method={"init()V"})
    public void init(CallbackInfo ci) {
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        if (ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER) {
            this.field_228174_e_.func_228124_a_(false);
        }
        if (this.field_146409_v.equalsIgnoreCase("/")) {
            if (ChatModule.clientChatTarget != ClientChatTarget.DEFAULT) {
                ChatModule.lastSelected = ChatModule.clientChatTarget;
            }
            ChatModule.clientChatTarget = ClientChatTarget.DEFAULT;
        } else if (ChatModule.lastSelected != ClientChatTarget.DEFAULT) {
            ChatModule.clientChatTarget = ChatModule.lastSelected;
        }
        int x = MathHelper.ceil(Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146228_f()) + 16 + 2;
        if (ChatHandler.hasParty) {
            this.switchButton = new GuiButtonPair(x, this.field_230709_l_ - 215, 234, 16, ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER ? 1 : 0, false, false, true, p -> {
                if (this.switchButton.activeButton == 2) {
                    ChatModule.clientChatTarget = ClientChatTarget.PARTY;
                    return;
                }
                ChatModule.clientChatTarget = this.switchButton.activeButton == 1 ? ClientChatTarget.MINETOGETHER : ClientChatTarget.DEFAULT;
            }, MixinChatScreen.isSinglePlayer() ? I18n.func_135052_a((String)"minetogether.ingame.chat.local", (Object[])new Object[0]) : I18n.func_135052_a((String)"minetogether.ingame.chat.server", (Object[])new Object[0]), I18n.func_135052_a((String)"minetogether.ingame.chat.global", (Object[])new Object[0]), I18n.func_135052_a((String)"minetogether.ingame.chat.party", (Object[])new Object[0]));
            this.func_230480_a_((Widget)this.switchButton);
        } else {
            this.switchButton = new GuiButtonPair(x, this.field_230709_l_ - 215, 234, 16, ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER ? 1 : 0, false, false, true, p -> {
                ClientChatTarget clientChatTarget = ChatModule.clientChatTarget = this.switchButton.activeButton == 1 ? ClientChatTarget.MINETOGETHER : ClientChatTarget.DEFAULT;
                if (this.switchButton.activeButton == 1) {
                    IrcHandler.sendCTCPMessage("Freddy", "ACTIVE", "");
                }
            }, MixinChatScreen.isSinglePlayer() ? I18n.func_135052_a((String)"minetogether.ingame.chat.local", (Object[])new Object[0]) : I18n.func_135052_a((String)"minetogether.ingame.chat.server", (Object[])new Object[0]), I18n.func_135052_a((String)"minetogether.ingame.chat.global", (Object[])new Object[0]));
            this.func_230480_a_((Widget)this.switchButton);
        }
        ArrayList<String> strings = new ArrayList<String>();
        strings.add(I18n.func_135052_a((String)"minetogether.chat.button.mute", (Object[])new Object[0]));
        strings.add(I18n.func_135052_a((String)"minetogether.chat.button.addfriend", (Object[])new Object[0]));
        strings.add(I18n.func_135052_a((String)"minetogether.chat.button.mention", (Object[])new Object[0]));
        this.dropdownButton = new DropdownButton<ChatScreen.Menu>(-1000, -1000, 100, 20, (ITextComponent)new TranslationTextComponent("Menu"), new ChatScreen.Menu(strings), true, p -> {
            if (this.dropdownButton.getSelected().option.equals(I18n.func_135052_a((String)"minetogether.chat.button.mute", (Object[])new Object[0]))) {
                ChatModule.muteUser(KnownUsers.findByDisplay(this.currentDropdown).getLongHash());
                KnownUsers.findByDisplay(this.currentDropdown).setMuted(true);
                ChatHandler.addStatusMessage("Locally blocked " + this.currentDropdown);
            } else if (this.dropdownButton.getSelected().option.equals(I18n.func_135052_a((String)"minetogether.chat.button.addfriend", (Object[])new Object[0]))) {
                Profile profile = KnownUsers.findByDisplay(this.currentDropdown);
                if (profile != null) {
                    this.field_230706_i_.func_147108_a((Screen)new FriendRequestScreen(this, this.field_230706_i_.func_110432_I().func_111285_a(), profile, ChatCallbacks.getFriendCode(MineTogetherClient.getPlayerHash()), "", false, false));
                }
            } else if (this.dropdownButton.getSelected().option.equals(I18n.func_135052_a((String)"minetogether.chat.button.mention", (Object[])new Object[0]))) {
                this.field_146415_a.func_146195_b(true);
                this.field_146415_a.func_146180_a(this.field_146415_a.func_146179_b() + " " + this.currentDropdown + " ");
            }
        }, false);
        this.func_230480_a_((Widget)this.dropdownButton);
        this.dropdownButton.flipped = true;
        if (Config.getInstance().getFirstConnect() && ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER) {
            ChatCallbacks.updateOnlineCount();
            this.newUserButton = new ButtonNoBlend(6, this.field_230709_l_ - (this.field_230706_i_.field_71456_v.func_146158_b().func_146246_g() + 80) / 2 + 45, this.field_230706_i_.field_71456_v.func_146158_b().func_146228_f() - 2, 20, (ITextComponent)new TranslationTextComponent("Join " + ChatCallbacks.onlineCount + " online users now!"), p -> {
                IrcHandler.sendCTCPMessage("Freddy", "ACTIVE", "");
                Config.getInstance().setFirstConnect(false);
                this.newUserButton.field_230694_p_ = false;
                this.disableButton.field_230694_p_ = false;
                this.field_230706_i_.func_147108_a(null);
            });
            this.func_230480_a_((Widget)this.newUserButton);
            this.disableButton = new ButtonNoBlend(6, this.field_230709_l_ - (this.field_230706_i_.field_71456_v.func_146158_b().func_146246_g() + 80) / 2 + 70, this.field_230706_i_.field_71456_v.func_146158_b().func_146228_f() - 2, 20, (ITextComponent)new TranslationTextComponent("Don't ask me again"), p -> {
                Config.getInstance().setChatEnabled(false);
                this.disableButton.field_230694_p_ = false;
                this.newUserButton.field_230694_p_ = false;
                IrcHandler.stop(true);
                this.field_230710_m_.clear();
            });
            this.func_230480_a_((Widget)this.disableButton);
        }
    }

    private static boolean isSinglePlayer() {
        Minecraft minecraft = Minecraft.func_71410_x();
        if (minecraft.func_71401_C() == null) {
            return false;
        }
        if (minecraft.func_71401_C().func_71344_c()) {
            return false;
        }
        return minecraft.func_71387_A();
    }

    @Inject(at={@At(value="HEAD")}, method={"render"}, cancellable=true)
    public void render(MatrixStack poseStack, int i, int j, float partialTicks, CallbackInfo ci) {
        Style style;
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        if (this.field_230706_i_ == null) {
            return;
        }
        this.mouseX = i;
        this.mouseY = j;
        this.func_231035_a_((IGuiEventListener)this.field_146415_a);
        this.field_146415_a.func_146195_b(true);
        MixinChatScreen.func_238467_a_((MatrixStack)poseStack, (int)2, (int)(this.field_230709_l_ - 14), (int)(this.field_230708_k_ - 2), (int)(this.field_230709_l_ - 2), (int)this.field_230706_i_.field_71474_y.func_216839_a(Integer.MIN_VALUE));
        this.field_146415_a.func_230430_a_(poseStack, i, j, partialTicks);
        if (ChatModule.clientChatTarget == ClientChatTarget.DEFAULT) {
            this.field_228174_e_.func_238500_a_(poseStack, i, j);
        }
        if ((style = this.field_230706_i_.field_71456_v.func_146158_b().func_238494_b_((double)i, (double)j)) != null && style.func_150210_i() != null) {
            if (style.func_150210_i().func_150701_a() == ComponentUtils.RENDER_GIF) {
                ITextComponent urlComponent = (ITextComponent)style.func_150210_i().func_240662_a_(ComponentUtils.RENDER_GIF);
                String url = urlComponent.getString();
                if (this.gifImage == null) {
                    try {
                        try {
                            this.gifImage = AnimatedGif.fromURL(new URL("https://ss.gigabit101.net/Colony_Survival.png"));
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                        if (this.gifImage != null && this.gifPlayer == null) {
                            this.gifPlayer = this.gifImage.makeGifPlayer();
                            this.gifPlayer.setLooping(true);
                            this.gifPlayer.setAutoplay(true);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (this.gifPlayer != null) {
                    this.gifPlayer.render(poseStack, this.mouseX + 5, this.mouseY + 5, 80, 60, partialTicks);
                }
            }
            this.func_238653_a_(poseStack, style, i, j);
        } else {
            this.gifImage = null;
            this.gifPlayer = null;
        }
        if (Config.getInstance().getFirstConnect() && ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER) {
            NewChatGui chatComponent;
            if (this.newUserButton != null) {
                this.newUserButton.field_230694_p_ = true;
            }
            if (this.disableButton != null) {
                this.disableButton.field_230694_p_ = true;
            }
            if ((chatComponent = this.field_230706_i_.field_71456_v.func_146158_b()) != null) {
                Objects.requireNonNull(this.field_230706_i_.field_71466_p);
                int y = this.field_230709_l_ - 43 - 9 * Math.max(Math.min(chatComponent.func_146238_c().size(), chatComponent.func_146232_i()), 20);
                MixinChatScreen.func_238467_a_((MatrixStack)poseStack, (int)0, (int)y, (int)(chatComponent.func_146228_f() + 6), (int)(chatComponent.func_146246_g() + 10 + y), (int)-1728053248);
                MixinChatScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)"Welcome to MineTogether", (int)(chatComponent.func_146228_f() / 2 + 3), (int)(this.field_230709_l_ - (chatComponent.func_146246_g() + 80) / 2), (int)0xFFFFFF);
                MixinChatScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)"MineTogether is a multiplayer enhancement mod that provides", (int)(chatComponent.func_146228_f() / 2 + 3), (int)(this.field_230709_l_ - (chatComponent.func_146246_g() + 80) / 2 + 10), (int)0xFFFFFF);
                MixinChatScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)"a multitude of features like chat, friends list, server listing", (int)(chatComponent.func_146228_f() / 2 + 3), (int)(this.field_230709_l_ - (chatComponent.func_146246_g() + 80) / 2 + 20), (int)0xFFFFFF);
                MixinChatScreen.func_238471_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (String)("and more. Join " + ChatCallbacks.userCount + " unique users."), (int)(chatComponent.func_146228_f() / 2 + 3), (int)(this.field_230709_l_ - (chatComponent.func_146246_g() + 80) / 2 + 30), (int)0xFFFFFF);
            }
        }
        super.func_230430_a_(poseStack, i, j, partialTicks);
        ci.cancel();
    }

    @Inject(at={@At(value="TAIL")}, method={"tick"})
    public void tick(CallbackInfo ci) {
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        switch (ChatModule.clientChatTarget) {
            case DEFAULT: {
                this.switchButton.getButtons().get(0).setActive(true);
                return;
            }
            case MINETOGETHER: {
                this.switchButton.getButtons().get(1).setActive(true);
                return;
            }
            case PARTY: {
                if (this.switchButton.getButtons().size() == 3) {
                    this.switchButton.getButtons().get(2).setActive(true);
                }
                return;
            }
        }
        if (this.gifPlayer != null) {
            this.gifPlayer.tick();
        }
        if (this.field_146415_a == null) {
            return;
        }
        if (ChatModule.clientChatTarget != ClientChatTarget.DEFAULT) {
            this.field_146415_a.field_230693_o_ = ChatHandler.connectionStatus == ChatConnectionStatus.VERIFIED;
            this.field_146415_a.func_146184_c(ChatHandler.connectionStatus == ChatConnectionStatus.VERIFIED);
            if (this.field_146415_a.func_230999_j_() && ChatHandler.connectionStatus != ChatConnectionStatus.VERIFIED) {
                this.field_146415_a.func_146195_b(false);
            }
            switch (ChatHandler.connectionStatus) {
                case VERIFYING: {
                    this.field_146415_a.func_195612_c(I18n.func_135052_a((String)"minetogether.chat.message.unverified", (Object[])new Object[0]));
                    break;
                }
                case BANNED: {
                    this.field_146415_a.func_195612_c(I18n.func_135052_a((String)"minetogether.chat.message.banned", (Object[])new Object[0]));
                    break;
                }
                case DISCONNECTED: {
                    this.field_146415_a.func_195612_c(I18n.func_135052_a((String)"minetogether.chat.message.disconnect", (Object[])new Object[0]));
                    break;
                }
                case CONNECTING: {
                    this.field_146415_a.func_195612_c(I18n.func_135052_a((String)"minetogether.chat.message.connecting", (Object[])new Object[0]));
                    break;
                }
                case VERIFIED: {
                    this.field_146415_a.func_195612_c("");
                }
            }
        } else {
            this.field_146415_a.field_230693_o_ = true;
            this.field_146415_a.func_146184_c(true);
            this.field_146415_a.func_195612_c("");
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"mouseClicked"}, cancellable=true)
    public void mouseClicked(double d, double e, int i, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        if (this.dropdownButton != null && this.dropdownButton.wasJustClosed && !this.dropdownButton.dropdownOpen) {
            this.dropdownButton.field_230691_m_ = -10000;
            this.dropdownButton.field_230690_l_ = -10000;
            this.dropdownButton.wasJustClosed = false;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"onEdited"}, cancellable=true)
    private void onEdited(String string, CallbackInfo ci) {
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        if (ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER) {
            ci.cancel();
        }
    }

    public void func_231161_c_(String string) {
        if (!Config.getInstance().isChatEnabled()) {
            super.func_231161_c_(string);
            return;
        }
        if (this.field_230706_i_ == null) {
            return;
        }
        if (ChatModule.clientChatTarget == ClientChatTarget.MINETOGETHER) {
            if (string.startsWith("/")) {
                ChatModule.clientChatTarget = ClientChatTarget.DEFAULT;
                super.func_231161_c_(string);
                return;
            }
            ChatHandler.sendMessage(ChatHandler.CHANNEL, string);
            return;
        }
        if (ChatModule.clientChatTarget == ClientChatTarget.PARTY) {
            ChatHandler.sendMessage(ChatHandler.currentParty, string);
            return;
        }
        super.func_231161_c_(string);
    }

    public boolean func_230455_a_(@Nullable Style style) {
        if (!Config.getInstance().isChatEnabled()) {
            return super.func_230455_a_(style);
        }
        if (this.field_230706_i_ == null) {
            return false;
        }
        if (ChatModule.clientChatTarget == ClientChatTarget.DEFAULT) {
            return super.func_230455_a_(style);
        }
        if (style == null) {
            return false;
        }
        if (style.func_150235_h() == null) {
            return false;
        }
        if (this.dropdownButton == null) {
            return false;
        }
        if (this.dropdownButton.dropdownOpen) {
            return false;
        }
        if (style.func_150235_h().func_150669_a() == ClickEvent.Action.OPEN_URL) {
            return super.func_230455_a_(style);
        }
        if (style.func_150235_h().func_150669_a() == ClickEvent.Action.SUGGEST_COMMAND) {
            this.dropdownButton.field_230690_l_ = this.mouseX;
            this.dropdownButton.field_230691_m_ = this.mouseY;
            this.dropdownButton.dropdownOpen = true;
            this.currentDropdown = style.func_150235_h().func_150668_b();
            return true;
        }
        return false;
    }
}

