/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.mixin;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.creeperhost.minetogether.config.Config;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.data.Message;
import net.creeperhost.minetogether.lib.util.LimitedSizeQueue;
import net.creeperhost.minetogether.lib.util.MathHelper;
import net.creeperhost.minetogether.module.chat.ChatFormatter;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.module.chat.ClientChatTarget;
import net.creeperhost.minetogethergui.ScreenHelpers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.NewChatGui;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={NewChatGui.class})
public abstract class MixinChatComponent {
    @Shadow
    @Final
    private List<ChatLine<IReorderingProcessor>> field_146253_i;
    @Shadow
    @Final
    private List<ChatLine<ITextComponent>> field_146252_h;
    @Shadow
    @Final
    private Minecraft field_146247_f;
    private final List<ChatLine<IReorderingProcessor>> mtChatMessages = new ArrayList<ChatLine<IReorderingProcessor>>();
    private final List<ChatLine<ITextComponent>> mtAllMessages = new ArrayList<ChatLine<ITextComponent>>();
    private final List<ChatLine<IReorderingProcessor>> partyChatMessages = new ArrayList<ChatLine<IReorderingProcessor>>();
    private final List<ChatLine<ITextComponent>> partyAllMessages = new ArrayList<ChatLine<ITextComponent>>();

    @Shadow
    public abstract int func_146228_f();

    @Shadow
    protected abstract void func_238493_a_(ITextComponent var1, int var2, int var3, boolean var4);

    @Shadow
    protected abstract boolean func_146241_e();

    @Shadow
    @Nullable
    public abstract Style func_238494_b_(double var1, double var3);

    @Inject(at={@At(value="RETURN")}, method={"processPendingMessages"}, cancellable=true)
    public void getProcessPendingMessages(CallbackInfo ci) {
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        if (ChatModule.clientChatTarget != ClientChatTarget.DEFAULT && ChatModule.hasNewMessage) {
            ChatModule.hasNewMessage = false;
            this.updateList();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"render"})
    public void render(MatrixStack poseStack, int i, CallbackInfo ci) {
        if (!Config.getInstance().isChatEnabled()) {
            return;
        }
        if (this.func_146241_e()) {
            NewChatGui chatComponent = Minecraft.func_71410_x().field_71456_v.func_146158_b();
            int n = chatComponent.func_146246_g() - 175;
            Objects.requireNonNull(this.field_146247_f.field_71466_p);
            int y = n - 9 * Math.max(Math.min(chatComponent.func_146238_c().size(), chatComponent.func_146232_i()), 20);
            AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)0, (int)y, (int)(chatComponent.func_146228_f() + 6), (int)(chatComponent.func_146246_g() + 10 + y), (int)this.field_146247_f.field_71474_y.func_216839_a(Integer.MIN_VALUE));
            int k = MathHelper.ceil((float)this.field_146247_f.field_71456_v.func_146158_b().func_146228_f() / (float)this.field_146247_f.field_71474_y.field_96691_E);
            int z = MathHelper.ceil((float)this.field_146247_f.field_71456_v.func_146158_b().func_146246_g() / (float)this.field_146247_f.field_71474_y.field_96691_E);
            if (ChatModule.clientChatTarget != ClientChatTarget.DEFAULT) {
                ScreenHelpers.drawLogo(poseStack, this.field_146247_f.field_71466_p, k + 6, z + 6, -2, this.field_146247_f.field_71456_v.func_146158_b().func_146246_g() - 340, 0.75f);
            }
        }
    }

    @Redirect(method={"render"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/components/ChatComponent;trimmedMessages:Ljava/util/List;", opcode=180))
    private List<ChatLine<IReorderingProcessor>> trimmedMessages(NewChatGui chatComponent) {
        if (!Config.getInstance().isChatEnabled()) {
            return this.field_146253_i;
        }
        switch (ChatModule.clientChatTarget) {
            case DEFAULT: {
                return this.field_146253_i;
            }
            case PARTY: {
                return this.partyChatMessages;
            }
            case MINETOGETHER: {
                return this.mtChatMessages;
            }
        }
        return this.field_146253_i;
    }

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/ChatComponent;fill(Lcom/mojang/blaze3d/vertex/PoseStack;IIIII)V"))
    private void fill(MatrixStack poseStack, int i, int j, int k, int l, int m3) {
        if (Config.getInstance().isChatEnabled()) {
            if (!this.func_146241_e()) {
                AbstractGui.func_238467_a_((MatrixStack)poseStack, (int)i, (int)j, (int)k, (int)l, (int)m3);
            }
        } else {
            NewChatGui.func_238467_a_((MatrixStack)poseStack, (int)i, (int)j, (int)k, (int)l, (int)m3);
        }
    }

    @Redirect(method={"addMessage(Lnet/minecraft/network/chat/Component;IIZ)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/components/ChatComponent;trimmedMessages:Ljava/util/List;", opcode=180))
    private List<ChatLine<IReorderingProcessor>> addMessage(NewChatGui chatComponent) {
        if (!Config.getInstance().isChatEnabled()) {
            return this.field_146253_i;
        }
        switch (ChatModule.clientChatTarget) {
            case DEFAULT: {
                return this.field_146253_i;
            }
            case PARTY: {
                return this.partyChatMessages;
            }
            case MINETOGETHER: {
                return this.mtChatMessages;
            }
        }
        return this.field_146253_i;
    }

    @Redirect(method={"addMessage(Lnet/minecraft/network/chat/Component;IIZ)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/components/ChatComponent;allMessages:Ljava/util/List;", opcode=180))
    private List<ChatLine<ITextComponent>> addMessageAll(NewChatGui chatComponent) {
        if (!Config.getInstance().isChatEnabled()) {
            return this.field_146252_h;
        }
        switch (ChatModule.clientChatTarget) {
            case DEFAULT: {
                return this.field_146252_h;
            }
            case MINETOGETHER: {
                return this.mtAllMessages;
            }
            case PARTY: {
                return this.partyAllMessages;
            }
        }
        return this.field_146252_h;
    }

    @Redirect(method={"scrollChat(D)V"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/components/ChatComponent;trimmedMessages:Ljava/util/List;", opcode=180))
    private List<ChatLine<IReorderingProcessor>> scrollChat(NewChatGui chatComponent) {
        if (!Config.getInstance().isChatEnabled()) {
            return this.field_146253_i;
        }
        switch (ChatModule.clientChatTarget) {
            case DEFAULT: {
                return this.field_146253_i;
            }
            case PARTY: {
                return this.partyChatMessages;
            }
            case MINETOGETHER: {
                return this.mtChatMessages;
            }
        }
        return this.field_146253_i;
    }

    @Redirect(method={"getClickedComponentStyleAt"}, at=@At(value="FIELD", target="Lnet/minecraft/client/gui/components/ChatComponent;trimmedMessages:Ljava/util/List;", opcode=180))
    private List<ChatLine<IReorderingProcessor>> getClickedComponentStyleAt(NewChatGui chatComponent) {
        if (!Config.getInstance().isChatEnabled()) {
            return this.field_146253_i;
        }
        switch (ChatModule.clientChatTarget) {
            case DEFAULT: {
                return this.field_146253_i;
            }
            case PARTY: {
                return this.partyChatMessages;
            }
            case MINETOGETHER: {
                return this.mtChatMessages;
            }
        }
        return this.field_146253_i;
    }

    public void updateList() {
        String channel = ChatHandler.CHANNEL;
        if (ChatModule.clientChatTarget == ClientChatTarget.PARTY) {
            channel = ChatHandler.currentParty;
        }
        try {
            LimitedSizeQueue<Message> temp = ChatHandler.messages.get(channel);
            for (Message message : temp) {
                ITextComponent component = ChatFormatter.formatLine(message);
                if (component == null) continue;
                this.func_238493_a_(component, 0, Minecraft.func_71410_x().field_71456_v.func_73834_c(), false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

