/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.covers1624.quack.collection.ColUtils;
import net.covers1624.quack.util.SneakyUtils;
import net.creeperhost.minetogether.lib.util.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    private static final Logger LOGGER = LogManager.getLogger();

    public static void fileFromZip(Path zip, Path dest, String fileName) throws IOException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(zip, null);){
            Path fileToExtract = fileSystem.getPath(fileName, new String[0]);
            Files.copy(fileToExtract, dest, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static void extractFromZip(Path zip, Path dest, String fileName, boolean relative) throws IOException {
        try (FileSystem fileSystem = FileSystems.newFileSystem(zip, null);){
            Path src = fileSystem.getPath(fileName, new String[0]);
            try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
                stream.forEach(source -> {
                    Path localPath = FileUtils.pathTransform(dest.getFileSystem(), source);
                    if (relative) {
                        if (localPath.getNameCount() == 1) {
                            return;
                        }
                        localPath = localPath.subpath(1, localPath.getNameCount());
                        if (Files.isDirectory(source, new LinkOption[0])) {
                            dest.resolve(localPath).toFile().mkdirs();
                            return;
                        }
                    }
                    FileUtils.copy(source, dest.resolve(localPath));
                });
            }
        }
    }

    private static Path pathTransform(FileSystem fs, Path path) {
        Path ret = fs.getPath(path.isAbsolute() ? fs.getSeparator() : "", new String[0]);
        for (Path component : path) {
            ret = ret.resolve(component.getFileName().toString());
        }
        return ret;
    }

    private static void copy(Path source, Path dest) {
        try {
            Files.copy(source, dest, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean copyDirectory(Path sourceDir, Path destinationDir) throws IOException {
        AtomicBoolean error = new AtomicBoolean(false);
        Files.walk(sourceDir, new FileVisitOption[0]).forEach(sourcePath -> {
            try {
                Path targetPath = destinationDir.resolve(sourceDir.relativize((Path)sourcePath));
                Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException ex) {
                LOGGER.error("File copy I/O error: ", (Throwable)ex);
                error.set(true);
            }
        });
        return !error.get();
    }

    public static HashMap<String, Exception> extractZip2ElectricBoogaloo(Path launcherFile, Path destination) {
        return FileUtils.extractZip2ElectricBoogaloo(launcherFile, destination, true);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static HashMap<String, Exception> extractZip2ElectricBoogaloo(Path launcherFile, Path destination, boolean continueOnError) {
        HashMap<String, Exception> errors = new HashMap<String, Exception>();
        try (ZipFile zipFile = new ZipFile(launcherFile.toFile());){
            for (ZipEntry zipEntry : ColUtils.toIterable(zipFile.entries())) {
                LOGGER.debug("Extracting '{}'...", (Object)zipEntry.getName());
                try {
                    Path dest = destination.resolve(zipEntry.getName());
                    if (zipEntry.isDirectory()) continue;
                    FileUtils.createDirectories(dest.getParent());
                    LOGGER.debug("Writing to {}", (Object)dest);
                    Files.copy(zipFile.getInputStream(zipEntry), dest, StandardCopyOption.REPLACE_EXISTING);
                }
                catch (IOException e) {
                    LOGGER.debug("Failed extracting file {}", (Object)zipEntry.getName(), (Object)e);
                    errors.put(zipEntry.getName(), e);
                    if (continueOnError) continue;
                    HashMap<String, Exception> hashMap = errors;
                    zipFile.close();
                    return hashMap;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error extracting zip file {}", (Object)launcherFile.toAbsolutePath(), (Object)e);
        }
        return errors;
    }

    public static void deleteDirectory(Path file) {
        if (Files.notExists(file, new LinkOption[0])) {
            return;
        }
        try {
            Files.walk(file, new FileVisitOption[0]).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).sorted(Comparator.reverseOrder()).forEach(SneakyUtils.sneak(Files::delete));
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete directory. {}", (Object)file, (Object)e);
        }
    }

    @Deprecated
    public static void setFilePermissions(Path file) {
        try {
            Files.setPosixFilePermissions(file, PosixFilePermissions.fromString("rwxr-xr-x"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static long getLastModified(Path file) {
        if (file != null) {
            try {
                return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return 0L;
    }

    public static boolean removeMeta(Path file) {
        boolean bl;
        block9: {
            if (!Files.exists(file, new LinkOption[0])) {
                return false;
            }
            FileSystem fileSystem = FileSystems.newFileSystem(file, null);
            try {
                Path root = fileSystem.getPath("/", new String[0]);
                Files.walkFileTree(root, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        try {
                            if (file.startsWith("/META-INF")) {
                                Files.deleteIfExists(file);
                            }
                        }
                        catch (Exception e) {
                            LOGGER.error("Failed to delete entry from META-INF", (Throwable)e);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                bl = true;
                if (fileSystem == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (fileSystem != null) {
                        try {
                            fileSystem.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.error("Failed to remove meta from {}", (Object)file, (Object)e);
                    return false;
                }
            }
            fileSystem.close();
        }
        return bl;
    }

    public static boolean mergeJars(Path input, Path output) {
        if (input == null || output == null) {
            return false;
        }
        final AtomicBoolean flag = new AtomicBoolean(true);
        try (FileSystem fs = FileSystems.newFileSystem(output, null);){
            final Path dstRoot = fs.getPath("/", new String[0]);
            try (FileSystem srcFs = FileSystems.newFileSystem(input, null);){
                final Path srcRoot = srcFs.getPath("/", new String[0]);
                Files.walkFileTree(srcRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        Path dst = dstRoot.resolve(srcRoot.relativize(file));
                        try {
                            Files.createDirectories(dst.getParent(), new FileAttribute[0]);
                            Files.copy(file, dst, StandardCopyOption.REPLACE_EXISTING);
                        }
                        catch (Exception e) {
                            flag.set(false);
                            e.printStackTrace();
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
        catch (Exception e) {
            flag.set(false);
            e.printStackTrace();
        }
        return flag.get();
    }

    public static Path createDirectories(Path dir) {
        try {
            return Files.createDirectories(dir, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create directories.", (Throwable)e);
            return null;
        }
    }

    public static List<Path> listDir(Path dir) {
        List<Path> list;
        block8: {
            Stream<Path> stream = Files.walk(dir, 1, new FileVisitOption[0]);
            try {
                list = stream.filter(e -> !e.equals(dir)).collect(Collectors.toList());
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e2) {
                    LOGGER.error("Failed to list directory. {}", (Object)dir.toAbsolutePath(), (Object)e2);
                    return Collections.emptyList();
                }
            }
            stream.close();
        }
        return list;
    }

    @Deprecated
    private static HashMap<Pair<Path, Path>, IOException> moveDirectory(final Path in, Path out, boolean replaceExisting, final boolean failFast) {
        final HashMap<Pair<Path, Path>, IOException> errors = new HashMap<Pair<Path, Path>, IOException>();
        if (!in.getFileName().toString().equals(out.getFileName().toString())) {
            out = out.resolve(in.getFileName().toString());
        }
        if (replaceExisting && Files.exists(out, new LinkOption[0])) {
            if (Files.isDirectory(out, new LinkOption[0])) {
                FileUtils.deleteDirectory(out);
            } else {
                try {
                    Files.deleteIfExists(out);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        try {
            Files.move(in, out, new CopyOption[0]);
            return errors;
        }
        catch (IOException e) {
            LOGGER.warn("Could not move {} to {} - trying another method", (Object)in, (Object)out, (Object)e);
            try {
                final Path finalOut = out;
                Files.walkFileTree(in, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path path, BasicFileAttributes basicFileAttributes) throws IOException {
                        block8: {
                            Path relative = in.getParent().relativize(path);
                            if (in.getFileName().toString().equals(finalOut.getFileName().toString())) {
                                relative = in.relativize(path);
                            }
                            Path outFile = finalOut.resolve(relative);
                            Files.createDirectories(outFile.getParent(), new FileAttribute[0]);
                            try {
                                Files.move(path, outFile, new CopyOption[0]);
                            }
                            catch (IOException e) {
                                boolean copyFailed;
                                block7: {
                                    copyFailed = true;
                                    try {
                                        Files.copy(path, outFile, new CopyOption[0]);
                                        copyFailed = false;
                                    }
                                    catch (IOException e2) {
                                        errors.put(new Pair<Path, Path>(path, outFile), e2);
                                        if (!failFast) break block7;
                                        return FileVisitResult.TERMINATE;
                                    }
                                }
                                if (copyFailed) break block8;
                                try {
                                    Files.delete(path);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult postVisitDirectory(Path directory, IOException ioException) throws IOException {
                        List<Path> list = FileUtils.listDir(directory);
                        if (list.isEmpty()) {
                            try {
                                Files.delete(directory);
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
            return errors;
        }
    }

    @Deprecated
    public static HashMap<Pair<Path, Path>, IOException> move(Path in, Path out) {
        return FileUtils.move(in, out, false, true);
    }

    @Deprecated
    public static HashMap<Pair<Path, Path>, IOException> move(Path in, Path out, boolean replaceExisting, boolean failFast) {
        if (Files.isDirectory(in, new LinkOption[0])) {
            return FileUtils.moveDirectory(in, out, replaceExisting, failFast);
        }
        HashMap<Pair<Path, Path>, IOException> errors = new HashMap<Pair<Path, Path>, IOException>();
        try {
            if (Files.exists(out, new LinkOption[0]) && Files.isDirectory(out, new LinkOption[0])) {
                out = out.resolve(in.getFileName().toString());
            }
            if (replaceExisting) {
                Files.move(in, out, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.move(in, out, new CopyOption[0]);
            }
        }
        catch (IOException e) {
            errors.put(new Pair<Path, Path>(in, out), e);
        }
        return errors;
    }

    public static void move(Path from, Path to, boolean replaceExisting) throws IOException {
        if (Files.isDirectory(from, new LinkOption[0])) {
            if (!Files.isDirectory(to, new LinkOption[0])) {
                throw new IllegalArgumentException("Requested to move directory into file.");
            }
            try (Stream<Path> children = Files.list(from);){
                children.filter(e -> e != from).forEach(SneakyUtils.sneak(e -> FileUtils.move(e, to.resolve(e.getFileName()), replaceExisting)));
            }
        } else if (Files.exists(from, new LinkOption[0])) {
            Files.createDirectories(from.toAbsolutePath().getParent(), new FileAttribute[0]);
            if (replaceExisting) {
                Files.move(from, to, StandardCopyOption.REPLACE_EXISTING);
            } else {
                Files.move(from, to, new CopyOption[0]);
            }
        }
    }

    public static String getHash(Path file, String hashType) {
        try {
            return FileUtils.hashToString(FileUtils.createChecksum(file, hashType));
        }
        catch (Exception e) {
            return "error - " + e.getMessage();
        }
    }

    private static byte[] createChecksum(Path file, String hashType) throws Exception {
        try (InputStream is = Files.newInputStream(file, new OpenOption[0]);){
            int numRead;
            byte[] buffer = new byte[4096];
            MessageDigest complete = MessageDigest.getInstance(hashType);
            do {
                if ((numRead = is.read(buffer)) <= 0) continue;
                complete.update(buffer, 0, numRead);
            } while (numRead != -1);
            byte[] byArray = complete.digest();
            return byArray;
        }
    }

    private static String hashToString(byte[] b) {
        StringBuilder result = new StringBuilder();
        for (byte value : b) {
            result.append(Integer.toString((value & 0xFF) + 256, 16).substring(1));
        }
        return result.toString();
    }

    private boolean move(File sourceFile, File destFile) {
        if (sourceFile.isDirectory()) {
            for (File file : sourceFile.listFiles()) {
                this.move(file, new File(file.getPath().substring("temp".length() + 1)));
            }
        } else {
            try {
                Files.move(Paths.get(sourceFile.getPath(), new String[0]), Paths.get(destFile.getPath(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
                return true;
            }
            catch (IOException e) {
                return false;
            }
        }
        return false;
    }
}

