/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.cloudsaves;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.event.ProgressEventType;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.S3ObjectSummary;
import com.amazonaws.services.s3.transfer.Download;
import com.amazonaws.services.s3.transfer.TransferManager;
import com.amazonaws.services.s3.transfer.TransferManagerBuilder;
import com.amazonaws.services.s3.transfer.Upload;
import com.google.common.hash.HashCode;
import com.google.common.hash.Hashing;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.covers1624.quack.util.HashUtils;
import net.creeperhost.minetogether.lib.util.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CloudSaveManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private static boolean isSetup = false;
    private static AmazonS3 s3 = null;
    private static String bucket = "";
    private static TransferManager transferManager = null;
    public static List<Upload> currentUploads = Collections.synchronizedList(new ArrayList());
    public static List<Download> currentDownloads = Collections.synchronizedList(new ArrayList());

    public static HashMap<String, S3ObjectSummary> listObjects() {
        return CloudSaveManager.listObjects(null);
    }

    public static void setup(String host, int port, String accessKeyId, String secretAccessKey, String bucketName) {
        if (host == null || host.isEmpty()) {
            return;
        }
        bucket = bucketName;
        ClientConfiguration config = new ClientConfiguration();
        config.setProxyHost(host);
        config.setProxyPort(port);
        config.withProtocol(Protocol.HTTP);
        BasicAWSCredentials credentials = new BasicAWSCredentials(accessKeyId, secretAccessKey);
        s3 = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withClientConfiguration(config)).withCredentials(new AWSStaticCredentialsProvider(credentials))).withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration("http://" + host + ":" + port, "us-east-2"))).build();
        if (!s3.doesBucketExistV2(bucket)) {
            s3.createBucket(bucket);
        }
        s3.listBuckets();
        transferManager = TransferManagerBuilder.standard().withS3Client(s3).build();
        isSetup = true;
    }

    public static HashMap<String, S3ObjectSummary> listObjects(String prefix) {
        if (!isSetup) {
            return null;
        }
        HashMap<String, S3ObjectSummary> tempList = new HashMap<String, S3ObjectSummary>();
        String nextMarker = null;
        boolean doStuff = true;
        while (doStuff) {
            ListObjectsRequest request = new ListObjectsRequest(bucket, prefix, nextMarker, null, 1000);
            ObjectListing objectListing = s3.listObjects(request);
            tempList.putAll(objectListing.getObjectSummaries().stream().collect(Collectors.toMap(S3ObjectSummary::getKey, object -> object)));
            nextMarker = objectListing.getNextMarker();
            doStuff = objectListing.isTruncated();
        }
        return tempList;
    }

    private static void uploadFile(Path file, String location, boolean blocking, String existingEtag) throws Exception {
        if (!isSetup) {
            return;
        }
        LOGGER.debug("Uploading {}", (Object)file);
        ObjectMetadata objectMetadata = null;
        try {
            if (Files.exists(file, new LinkOption[0]) && !Files.isDirectory(file, new LinkOption[0])) {
                objectMetadata = s3.getObjectMetadata(bucket, location);
            }
        }
        catch (AmazonS3Exception amazonS3Exception) {
            // empty catch block
        }
        HashCode fileHash = HashUtils.hash(Hashing.sha256(), file);
        if (objectMetadata != null && HashUtils.equals(fileHash, objectMetadata.getUserMetaDataOf("ourhash"))) {
            LOGGER.debug("Not uploading {} as object exists on server", (Object)file);
            return;
        }
        BufferedInputStream bufferedStream = Files.isDirectory(file, new LinkOption[0]) && FileUtils.listDir(file).isEmpty() ? new BufferedInputStream(new ByteArrayInputStream(new byte[0])) : new BufferedInputStream(Files.newInputStream(file, new OpenOption[0]));
        long fileSize = Files.size(file);
        ObjectMetadata meta = new ObjectMetadata();
        meta.addUserMetadata("ourhash", fileHash.toString());
        meta.addUserMetadata("ourlastmodified", String.valueOf(FileUtils.getLastModified(file)));
        meta.setContentLength(fileSize);
        Upload upload = transferManager.upload(bucket, location.replace(" ", ""), bufferedStream, meta);
        if (blocking) {
            upload.waitForUploadResult();
        } else {
            currentUploads.add(upload);
            upload.addProgressListener(progressEvent -> {
                ProgressEventType type = progressEvent.getEventType();
                if (type == ProgressEventType.TRANSFER_CANCELED_EVENT || type == ProgressEventType.TRANSFER_COMPLETED_EVENT || type == ProgressEventType.TRANSFER_FAILED_EVENT) {
                    currentUploads.remove(upload);
                    LOGGER.debug("Removed {} due to {}", (Object)upload.getDescription(), (Object)type.toString());
                }
            });
        }
    }

    public static List<UUID> getPrefixes() {
        if (!isSetup) {
            return null;
        }
        Pattern pattern = Pattern.compile(".*([a-z0-9A-Z]{8}-[a-z0-9A-Z]{4}-[a-z0-9A-Z]{4}-[a-z0-9A-Z]{4}-[a-z0-9A-Z]{12}).*");
        ArrayList<UUID> uuidList = new ArrayList<UUID>();
        for (Map.Entry<String, S3ObjectSummary> map : CloudSaveManager.listObjects().entrySet()) {
            String sub = map.getKey().substring(0, 38);
            Matcher matcher = pattern.matcher(sub);
            if (!matcher.find()) continue;
            try {
                UUID uuid = UUID.fromString(matcher.group(1));
                boolean exists = false;
                for (UUID uuid1 : uuidList) {
                    if (!uuid1.toString().equals(uuid.toString())) continue;
                    exists = true;
                    break;
                }
                if (exists) continue;
                uuidList.add(uuid);
            }
            catch (Exception exception) {}
        }
        return uuidList;
    }

    public static void syncManual(Path file, String location, boolean blocking, boolean client, HashMap<String, S3ObjectSummary> existing) throws Exception {
        if (!isSetup) {
            return;
        }
        LOGGER.debug("Uploading {}", (Object)file);
        ObjectMetadata objectMetadata = null;
        try {
            S3ObjectSummary summary = existing.get(location);
            if (Files.exists(file, new LinkOption[0]) && summary != null) {
                if (summary.getSize() <= 5242500L && HashUtils.equals(HashUtils.hash(Hashing.md5(), file), summary.getETag())) {
                    LOGGER.debug("Not syncing {} as object exists on server", (Object)file);
                    return;
                }
                objectMetadata = s3.getObjectMetadata(bucket, location);
            }
        }
        catch (AmazonS3Exception summary) {
            // empty catch block
        }
        HashCode fileHash = HashUtils.hash(Hashing.sha256(), file);
        if (objectMetadata != null) {
            LOGGER.debug("Client {} Server {}", (Object)fileHash, (Object)objectMetadata.getUserMetaDataOf("ourhash"));
            if (HashUtils.equals(fileHash, objectMetadata.getUserMetaDataOf("ourhash"))) {
                LOGGER.debug("Not syncing {} as object exists on server", (Object)file);
                return;
            }
            if (client) {
                CloudSaveManager.uploadFile(file, location, blocking, null);
            } else {
                CloudSaveManager.downloadFile(location, file, blocking, null);
            }
        } else {
            CloudSaveManager.uploadFile(file, location, blocking, null);
        }
    }

    public static void syncFile(Path file, String location, boolean blocking, HashMap<String, S3ObjectSummary> existingObjects) throws Exception {
        if (!isSetup) {
            return;
        }
        location = location.replace("\\", "/");
        LOGGER.debug("Uploading {}", (Object)file.toAbsolutePath());
        ObjectMetadata objectMetadata = null;
        try {
            if (Files.exists(file, new LinkOption[0]) && existingObjects.containsKey(location)) {
                S3ObjectSummary summary = existingObjects.get(location);
                if (summary.getSize() <= 5242500L && HashUtils.equals(HashUtils.hash(Hashing.md5(), file), summary.getETag())) {
                    LOGGER.debug("Not syncing {} as object exists on server", (Object)file);
                    return;
                }
                objectMetadata = s3.getObjectMetadata(bucket, location);
            }
        }
        catch (AmazonS3Exception summary) {
            // empty catch block
        }
        HashCode fileHash = HashUtils.hash(Hashing.sha256(), file);
        if (objectMetadata != null) {
            if (HashUtils.equals(fileHash, objectMetadata.getUserMetaDataOf("ourhash"))) {
                LOGGER.debug("Not uploading {} as object exists on server", (Object)file);
                return;
            }
            long ourModifiedClient = FileUtils.getLastModified(file);
            long ourModifiedServer = Long.parseLong(objectMetadata.getUserMetaDataOf("ourlastmodified"));
            LOGGER.debug("Client {} Server {}", (Object)ourModifiedClient, (Object)ourModifiedServer);
            if (ourModifiedClient > ourModifiedServer) {
                CloudSaveManager.uploadFile(file, location, blocking, null);
            } else if (ourModifiedClient < ourModifiedServer) {
                CloudSaveManager.downloadFile(location, file, blocking, null);
            }
        } else {
            CloudSaveManager.uploadFile(file, location, blocking, null);
        }
    }

    public static String getFile(String path) throws AmazonS3Exception {
        if (!isSetup) {
            return null;
        }
        return s3.getObjectAsString(bucket, path);
    }

    public static void deleteFile(String location) {
        if (!isSetup) {
            return;
        }
        try {
            LOGGER.debug("deleting file {}", (Object)location);
            s3.deleteObject(bucket, CloudSaveManager.urlEncodeParts(location));
        }
        catch (Throwable e) {
            LOGGER.warn("Error deleting file from bucket. {}", (Object)location, (Object)e);
        }
    }

    public static void downloadFile(String location, Path file, boolean blocking, String eTag) throws Exception {
        if (!isSetup) {
            return;
        }
        LOGGER.debug("Downloading {}", (Object)location);
        if (Files.exists(file, new LinkOption[0]) && !Files.isDirectory(file, new LinkOption[0])) {
            if (eTag != null && HashUtils.equals(HashUtils.hash(Hashing.md5(), file), eTag)) {
                LOGGER.debug("Not downloading {} as object exists on client", (Object)file);
                return;
            }
            ObjectMetadata objectMetadata = null;
            try {
                objectMetadata = s3.getObjectMetadata(bucket, location);
            }
            catch (AmazonS3Exception amazonS3Exception) {
                // empty catch block
            }
            if (objectMetadata != null && HashUtils.equals(HashUtils.hash(Hashing.md5(), file), objectMetadata.getUserMetaDataOf("ourhash"))) {
                LOGGER.debug("Not downloading {} as object exists on client", (Object)file);
                return;
            }
        }
        Download download = transferManager.download(bucket, CloudSaveManager.urlEncodeParts(location), file.toFile());
        if (blocking) {
            download.waitForCompletion();
        } else {
            currentDownloads.add(download);
            download.addProgressListener(progressEvent -> {
                ProgressEventType type = progressEvent.getEventType();
                if (type == ProgressEventType.TRANSFER_CANCELED_EVENT || type == ProgressEventType.TRANSFER_COMPLETED_EVENT || type == ProgressEventType.TRANSFER_FAILED_EVENT) {
                    currentUploads.remove(download);
                    LOGGER.debug("Removed {} due to {}", (Object)download.getDescription(), (Object)type.toString());
                }
            });
        }
    }

    private static boolean fileExists(String location) {
        if (!isSetup) {
            return false;
        }
        try {
            s3.getObjectMetadata(bucket, CloudSaveManager.urlEncodeParts(location));
        }
        catch (AmazonS3Exception e) {
            if (e.getStatusCode() == 404) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String fileToLocation(Path file, Path baseLocation) {
        return CloudSaveManager.urlEncodeParts(baseLocation.relativize(file).toString());
    }

    public static String urlEncodeParts(String string) {
        String collect = Arrays.stream(string.replace("\\", "/").split("/")).map(conn -> {
            try {
                return URLEncoder.encode(conn, "UTF-8") + "/";
            }
            catch (UnsupportedEncodingException e) {
                return "";
            }
        }).collect(Collectors.joining());
        return collect.substring(0, collect.length() - 1);
    }

    public static boolean uploadsInProgress() {
        return isSetup && currentUploads.size() > 0;
    }

    public static boolean downloadsInProgress() {
        return isSetup && currentUploads.size() > 0;
    }

    public static boolean transfersInProgress() {
        return CloudSaveManager.downloadsInProgress() || CloudSaveManager.uploadsInProgress();
    }

    @FunctionalInterface
    public static interface RunnableThrowable
    extends Runnable {
        @Override
        default public void run() {
            try {
                this.runThrows();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        public void runThrows() throws Exception;
    }
}

