/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.lib.chat;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatConnectionHandler;
import net.creeperhost.minetogether.lib.chat.ChatConnectionStatus;
import net.creeperhost.minetogether.lib.chat.FriendUpdateThread;
import net.creeperhost.minetogether.lib.chat.IChatListener;
import net.creeperhost.minetogether.lib.chat.KnownUsers;
import net.creeperhost.minetogether.lib.chat.MineTogetherChat;
import net.creeperhost.minetogether.lib.chat.data.Message;
import net.creeperhost.minetogether.lib.chat.data.Profile;
import net.creeperhost.minetogether.lib.chat.irc.IRCServer;
import net.creeperhost.minetogether.lib.chat.irc.IrcHandler;
import net.creeperhost.minetogether.lib.util.LimitedSizeQueue;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChatHandler {
    public static final Object ircLock = new Object();
    public static TreeMap<String, Boolean> newMessages = new TreeMap(String.CASE_INSENSITIVE_ORDER);
    static IRCServer IRC_SERVER;
    public static String CHANNEL;
    public static ChatConnectionStatus connectionStatus;
    public static TreeMap<String, LimitedSizeQueue<Message>> messages;
    static boolean online;
    public static AtomicBoolean isInitting;
    public static AtomicInteger tries;
    static AtomicBoolean inited;
    public static String initedString;
    public static String nick;
    static String realName;
    public static AtomicBoolean isInChannel;
    public static Logger logger;
    private static int serverId;
    public static AtomicInteger reconnectTimer;
    public static boolean rebuildChat;
    public static AtomicReference<List<String>> backupBan;
    public static CompletableFuture isBannedFuture;
    public static String currentParty;
    public static boolean hasParty;
    public static Profile pendingPartyInvite;
    public static IChatListener iChatListener;
    public static String mtHash;
    public static boolean first;
    public static HashMap<String, String> friends;
    public static ArrayList<String> autocompleteNames;

    public static void init(String mtHash, String nickIn, String realNameIn, IChatListener iChatListenerIn, boolean onlineIn) {
        if (first) {
            first = false;
            FriendUpdateThread.init(mtHash);
        }
        iChatListener = iChatListenerIn;
        ChatHandler.mtHash = mtHash;
        ChatConnectionHandler.INSTANCE.setup(nickIn, realNameIn, onlineIn);
        ChatConnectionHandler.INSTANCE.connect();
        ChatHandler.startCleanThread();
    }

    public static void reInit() {
        if (!isInitting.get() && initedString != null && realName != null) {
            inited.set(false);
            connectionStatus = ChatConnectionStatus.CONNECTING;
            ChatHandler.init(mtHash, initedString, realName, iChatListener, online);
        }
    }

    public static void addMessageToChat(String target, String user, String message) {
        LimitedSizeQueue<Message> tempQueue = messages.get(target);
        if (tempQueue == null) {
            tempQueue = new LimitedSizeQueue(150);
            messages.put(target, tempQueue);
        }
        Message messagePair = new Message(System.currentTimeMillis(), user, message);
        tempQueue.add(messagePair);
        if (iChatListener != null) {
            iChatListener.sendMessage(target, messagePair);
        }
        newMessages.put(target, Boolean.TRUE);
    }

    public static void addStatusMessage(String message) {
        ChatHandler.addMessageToChat(CHANNEL, "System", message);
    }

    public static String getNameForUser(String nick) {
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendMessage(String currentTarget, String text) {
        if (IrcHandler.sendMessage(currentTarget, text)) {
            Object object = ircLock;
            synchronized (object) {
                ChatHandler.addMessageToChat(currentTarget, nick, text);
            }
        }
    }

    public static void sendFriendRequest(String target, String desiredName) {
        IrcHandler.sendCTCPMessagePrivate(target, "FRIENDREQ", MineTogetherChat.profile.get().getFriendCode() + " " + desiredName);
    }

    public static void createPartyChannel(String owner) {
        IrcHandler.joinChannel("#" + owner);
        IrcHandler.sendString("MODE #" + owner + " +i", true);
        hasParty = true;
        currentParty = "#" + owner;
    }

    public static void leaveChannel(String channel) {
        if (!hasParty) {
            return;
        }
        IrcHandler.partChannel(channel);
        hasParty = false;
        currentParty = "";
    }

    public static void sendPartyInvite(String user, String owner) {
        if (!hasParty) {
            ChatHandler.createPartyChannel(owner);
        }
        IrcHandler.sendString("INVITE " + user + " #" + owner, true);
    }

    public static boolean isOnline() {
        return connectionStatus == ChatConnectionStatus.VERIFIED;
    }

    public static boolean hasNewMessages(String target) {
        return newMessages.get(target) != null && newMessages.get(target) != false;
    }

    public static void setMessagesRead(String target) {
        newMessages.put(target, false);
    }

    public static void acceptFriendRequest(String chatInternalName, String desiredName) {
        IrcHandler.sendCTCPMessagePrivate(chatInternalName, "FRIENDACC", MineTogetherChat.profile.get().getFriendCode() + " " + desiredName);
        ChatHandler.addMessageToChat(CHANNEL, "System", "Friend request accepted.");
    }

    public static void onPartyInvite(Profile profile) {
        pendingPartyInvite = profile;
        if (iChatListener != null) {
            iChatListener.onPartyInvite(profile);
        }
    }

    public static void acceptPartyInvite(Profile profile) {
        IrcHandler.joinChannel("#" + profile.getMediumHash());
        IrcHandler.sendString("MODE #" + profile.getMediumHash() + " +i", true);
        hasParty = true;
        currentParty = "#" + profile.getMediumHash();
        profile.setPartyMember(true);
        KnownUsers.update(profile);
        pendingPartyInvite = null;
    }

    public static void startCleanThread() {
        CompletableFuture.runAsync(() -> {
            while (true) {
                KnownUsers.clean();
                try {
                    Thread.sleep(30000L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }, MineTogetherChat.profileExecutor);
    }

    public static void leaveGroupChat() {
        ChatHandler.leaveChannel(currentParty);
        hasParty = false;
        currentParty = "";
    }

    public static String getPartyOwner() {
        return currentParty.replace("#", "");
    }

    public static boolean isPartyOwner() {
        return ChatHandler.getPartyOwner().equals(MineTogetherChat.profile.get().getMediumHash());
    }

    public static void onChannelNotice(String user, String message) {
        CompletableFuture.runAsync(() -> {
            Object object = ircLock;
            synchronized (object) {
                ChatHandler.addMessageToChat(CHANNEL, "System", message);
            }
        }, MineTogetherChat.chatMessageExecutor);
    }

    public static void onNotice(String name, String message) {
        CompletableFuture.runAsync(() -> {
            Object object = ircLock;
            synchronized (object) {
                ChatHandler.addMessageToChat(CHANNEL, "System", message);
            }
        }, MineTogetherChat.chatMessageExecutor);
    }

    public static void onCTCP(String user, String message) {
        CompletableFuture.runAsync(() -> {
            String[] split = message.split(" ");
            if (split.length < 1) {
                return;
            }
            switch (split[0].trim()) {
                case "FRIENDREQ": {
                    if (split.length < 3) {
                        return;
                    }
                    StringBuilder builder = new StringBuilder();
                    for (int i = 1; i < split.length; ++i) {
                        builder.append(split[i]).append(" ");
                    }
                    String chatMessage = builder.toString().trim();
                    if (iChatListener == null) break;
                    iChatListener.onFriendRequest(user, builder.toString().trim());
                    break;
                }
                case "FRIENDACC": {
                    if (split.length < 3) {
                        return;
                    }
                    StringBuilder builder = new StringBuilder();
                    for (int i = 2; i < split.length; ++i) {
                        builder.append(split[i]).append(" ");
                    }
                    if (iChatListener == null) break;
                    iChatListener.onFriendAccept(user, builder.toString().trim());
                    break;
                }
                case "SERVERID": {
                    IrcHandler.sendCTCPMessage(user, "SERVERID", ChatHandler.getServerId());
                    break;
                }
                case "VERIFY": {
                    if (user.startsWith("MT")) break;
                    String out = ChatHandler.getVerifyOutput();
                    if (MineTogetherChat.DEBUG_MODE) {
                        MineTogetherChat.logger.debug("VERIFY CALLED " + out);
                    }
                    IrcHandler.sendCTCPMessage(user, "VERIFY", out);
                }
            }
        }, MineTogetherChat.ircEventExecutor);
    }

    private static String getServerId() {
        if (iChatListener != null) {
            return iChatListener.onServerIdRequest();
        }
        return String.valueOf(serverId);
    }

    private static String getVerifyOutput() {
        if (iChatListener != null) {
            return iChatListener.getVerifyOutput();
        }
        return "";
    }

    public static void onUserBanned(String nick) {
        CompletableFuture.runAsync(() -> {
            if (nick.equalsIgnoreCase(ChatHandler.nick)) {
                IrcHandler.stop(true);
                MineTogetherChat.profile.getAndUpdate(profile1 -> {
                    profile1.setBanned(true);
                    if (isBannedFuture != null && !isBannedFuture.isDone()) {
                        isBannedFuture.cancel(true);
                    }
                    isBannedFuture = CompletableFuture.runAsync(() -> {
                        while (MineTogetherChat.profile.get().isBanned()) {
                            ChatCallbacks.isBanned(MineTogetherChat.INSTANCE.hash);
                            try {
                                Thread.sleep(60000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                    });
                    return profile1;
                });
            } else {
                Profile profile;
                if (iChatListener != null) {
                    iChatListener.setHasNewMessage(true);
                }
                if ((profile = KnownUsers.findByNick(nick)) == null) {
                    profile = KnownUsers.add(nick);
                }
                if (profile != null) {
                    profile.setBanned(true);
                    KnownUsers.update(profile);
                }
                backupBan.getAndUpdate(bans -> {
                    bans.add(nick);
                    return bans;
                });
            }
        }, MineTogetherChat.ircEventExecutor);
    }

    static {
        CHANNEL = "#MineTogether";
        connectionStatus = ChatConnectionStatus.DISCONNECTED;
        messages = new TreeMap(String.CASE_INSENSITIVE_ORDER);
        online = false;
        isInitting = new AtomicBoolean(false);
        tries = new AtomicInteger(0);
        inited = new AtomicBoolean(false);
        initedString = null;
        isInChannel = new AtomicBoolean(false);
        logger = LogManager.getLogger();
        serverId = -1;
        reconnectTimer = new AtomicInteger(10000);
        rebuildChat = false;
        backupBan = new AtomicReference(new ArrayList());
        currentParty = "";
        hasParty = false;
        first = true;
        friends = new HashMap();
        autocompleteNames = new ArrayList();
    }
}

