/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether.commands;

import com.google.gson.Gson;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.MineTogetherServer;
import net.creeperhost.minetogether.lib.util.WebUtils;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.UserListEntry;
import net.minecraft.server.management.WhiteList;
import net.minecraft.server.management.WhitelistEntry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class CommandInvite {
    public static LiteralArgumentBuilder<CommandSource> register() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"invite").requires(cs -> cs.func_197034_c(3))).then(Commands.func_197056_a((String)"username", (ArgumentType)StringArgumentType.string()).executes(cs -> CommandInvite.execute((CommandContext<CommandSource>)cs, StringArgumentType.getString((CommandContext)cs, (String)"username"))));
    }

    private static int execute(CommandContext<CommandSource> cs, String username) {
        MinecraftServer minecraftServer = ((CommandSource)cs.getSource()).func_197028_i();
        if (username.isEmpty()) {
            throw new CommandException((ITextComponent)new TranslationTextComponent("Invalid username"));
        }
        GameProfile gameProfile = minecraftServer.func_152358_ax().func_152655_a(username);
        if (gameProfile == null) {
            throw new CommandException((ITextComponent)new TranslationTextComponent("Failed to load GameProfile, Username is not valid"));
        }
        if (minecraftServer.func_184103_al().func_152599_k().func_152705_a(gameProfile)) {
            throw new CommandException((ITextComponent)new TranslationTextComponent(username + " Is already whitelisted"));
        }
        WhitelistEntry userWhiteListEntry = new WhitelistEntry(gameProfile);
        minecraftServer.func_184103_al().func_152599_k().func_152687_a((UserListEntry)userWhiteListEntry);
        minecraftServer.func_184103_al().func_187244_a();
        CommandInvite.sendUserInvite(gameProfile, minecraftServer);
        ((CommandSource)cs.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent(username + " Added to whitelist"), false);
        return 0;
    }

    public static void sendUserInvite(GameProfile profile, MinecraftServer server) {
        Gson gson = new Gson();
        WhiteList whitelistedPlayers = server.func_184103_al().func_152599_k();
        ArrayList<String> tempHash = new ArrayList<String>();
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hash = digest.digest(((WhitelistEntry)whitelistedPlayers.func_152683_b((Object)profile)).toString().getBytes(StandardCharsets.UTF_8));
            tempHash.add(Arrays.toString(digest.digest(hash)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        InviteClass invite = new InviteClass();
        invite.hash = tempHash;
        invite.id = MineTogetherServer.updateID;
        MineTogether.logger.debug("Sending " + gson.toJson(invite) + " to add endpoint");
        String resp = WebUtils.putWebResponse("https://api.creeper.host/serverlist/invite", gson.toJson(invite), true, true);
        MineTogether.logger.debug("Response from add endpoint " + resp);
    }

    public static class InviteClass {
        public int id = MineTogetherServer.updateID;
        public ArrayList<String> hash;
    }
}

