/*
 * Decompiled with CFR 0.152.
 */
package net.creeperhost.minetogether;

import com.mojang.authlib.exceptions.AuthenticationException;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.io.File;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import me.shedaniel.architectury.event.events.GuiEvent;
import me.shedaniel.architectury.event.events.client.ClientRawInputEvent;
import me.shedaniel.architectury.registry.KeyBindings;
import net.creeperhost.minetogether.MineTogether;
import net.creeperhost.minetogether.handler.AutoServerConnectHandler;
import net.creeperhost.minetogether.handler.ToastHandler;
import net.creeperhost.minetogether.lib.chat.ChatCallbacks;
import net.creeperhost.minetogether.lib.chat.ChatHandler;
import net.creeperhost.minetogether.lib.chat.irc.IrcHandler;
import net.creeperhost.minetogether.module.chat.ChatModule;
import net.creeperhost.minetogether.module.chat.screen.social.MineTogetherSocialInteractionsScreen;
import net.creeperhost.minetogether.module.connect.ConnectModule;
import net.creeperhost.minetogether.module.multiplayer.MultiPlayerModule;
import net.creeperhost.minetogether.module.serverorder.ServerOrderModule;
import net.creeperhost.minetogether.screen.OfflineScreen;
import net.creeperhost.minetogether.threads.FriendUpdateThread;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Session;
import org.apache.commons.codec.digest.DigestUtils;

public class MineTogetherClient {
    public static ToastHandler toastHandler;
    public static boolean isOnlineUUID;
    public static final KeyBinding mtSocialKey;
    static boolean firstOpen;

    public static void init() {
        toastHandler = new ToastHandler();
        GuiEvent.INIT_POST.register(MineTogetherClient::onScreenOpen);
        GuiEvent.RENDER_POST.register(MineTogetherClient::onScreenRender);
        GuiEvent.RENDER_HUD.register(MineTogetherClient::onHudRender);
        ClientRawInputEvent.KEY_PRESSED.register(MineTogetherClient::onRawInput);
        ConnectModule.init();
        MineTogetherClient.getUUID();
        ChatModule.init();
        MineTogetherClient.registerKeybindings();
        if (!isOnlineUUID) {
            MineTogether.logger.info("minetogether Has detected profile is in offline mode");
        }
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            MineTogether.logger.info("Shutdown called, Stopping our threads");
            IrcHandler.sendString("PART " + ChatHandler.CHANNEL, false);
            IrcHandler.sendString("QUIT ", false);
            IrcHandler.stop(true);
            FriendUpdateThread.stop();
        }));
    }

    private static ActionResultType onRawInput(Minecraft minecraft, int keyCode, int scanCode, int action, int modifiers) {
        if (minecraft.field_71462_r == null && !toastHandler.isActiveToast() && mtSocialKey.func_151470_d()) {
            minecraft.func_147108_a((Screen)new MineTogetherSocialInteractionsScreen());
            return ActionResultType.SUCCESS;
        }
        if (MineTogetherClient.toastHandler.toastMethod != null && mtSocialKey.func_151470_d()) {
            MineTogetherClient.toastHandler.toastMethod.run();
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    public static void registerKeybindings() {
        KeyBindings.registerKeyBinding((KeyBinding)mtSocialKey);
    }

    public static void removeVanillaSocialKeybinding() {
        Minecraft.func_71410_x().field_71474_y.field_244602_au.func_197979_b(InputMappings.field_197958_a);
        KeyBinding.func_74508_b();
    }

    public static UUID getUUID() {
        Session session = Minecraft.func_71410_x().func_110432_I();
        UUID uuid = Minecraft.func_71410_x().func_110432_I().func_148256_e().getId();
        isOnlineUUID = !uuid.equals(PlayerEntity.func_175147_b((String)session.func_111285_a()));
        return uuid;
    }

    public static String getPlayerHash() {
        return ChatCallbacks.getPlayerHash(MineTogetherClient.getUUID());
    }

    public static String getServerIDAndVerify() {
        Minecraft mc = Minecraft.func_71410_x();
        String serverId = DigestUtils.sha1Hex(String.valueOf(new Random().nextInt()));
        try {
            mc.func_152347_ac().joinServer(mc.func_110432_I().func_148256_e(), mc.func_110432_I().func_148254_d(), serverId);
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
            return null;
        }
        MineTogether.logger.info("new ServerID requested");
        return serverId;
    }

    public static void onHudRender(MatrixStack poseStack, float partialticks) {
        if (toastHandler != null) {
            toastHandler.render(poseStack);
        }
    }

    private static void onScreenRender(Screen screen, MatrixStack poseStack, int i, int i1, float part) {
        if (toastHandler != null) {
            toastHandler.render(poseStack);
        }
    }

    private static void onScreenOpen(Screen screen, List<Widget> abstractWidgets, List<IGuiEventListener> guiEventListeners) {
        if (firstOpen && screen instanceof MainMenuScreen) {
            ChatCallbacks.updateOnlineCount();
            MineTogetherClient.removeVanillaSocialKeybinding();
            File offline = new File("local/minetogether/offline.txt");
            if (!isOnlineUUID && !offline.exists()) {
                Minecraft.func_71410_x().func_147108_a((Screen)new OfflineScreen());
            }
            firstOpen = false;
        }
        MultiPlayerModule.onScreenOpen(screen, abstractWidgets, guiEventListeners);
        ServerOrderModule.onScreenOpen(screen, abstractWidgets, guiEventListeners);
        ChatModule.onScreenOpen(screen, abstractWidgets, guiEventListeners);
        AutoServerConnectHandler.onScreenOpen(screen, abstractWidgets, guiEventListeners);
    }

    static {
        isOnlineUUID = false;
        mtSocialKey = new KeyBinding(I18n.func_135052_a((String)"minetogether.keybindings.social", (Object[])new Object[0]), InputMappings.Type.KEYSYM, 80, I18n.func_135052_a((String)"minetogether.keybindings.category", (Object[])new Object[0]));
        firstOpen = true;
    }
}

