/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Predicate;
import net.covers1624.quack.io.IOUtils;

public class JarStripper {
    public static void stripJar(Path input, Path output, Predicate<Path> predicate) throws IOException {
        if (!Files.exists(input, new LinkOption[0])) {
            throw new FileNotFoundException("Input not found. " + input);
        }
        if (Files.exists(output, new LinkOption[0])) {
            throw new IOException("Output already exists. " + output);
        }
        try (FileSystem inFs = IOUtils.getJarFileSystem(input, true);
             FileSystem outFs = IOUtils.getJarFileSystem(output, true);){
            Path inRoot = inFs.getPath("/", new String[0]);
            Path outRoot = outFs.getPath("/", new String[0]);
            Files.walkFileTree(inRoot, new Visitor(inRoot, outRoot, predicate));
        }
    }

    private static class Visitor
    extends SimpleFileVisitor<Path> {
        private final Path inRoot;
        private final Path outRoot;
        private final Predicate<Path> predicate;

        private Visitor(Path inRoot, Path outRoot, Predicate<Path> predicate) {
            this.inRoot = inRoot;
            this.outRoot = outRoot;
            this.predicate = predicate;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path outDir = this.outRoot.resolve(this.inRoot.relativize(dir).toString());
            if (Files.notExists(outDir, new LinkOption[0])) {
                Files.createDirectories(outDir, new FileAttribute[0]);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path inFile, BasicFileAttributes attrs) throws IOException {
            Path rel = this.inRoot.relativize(inFile);
            Path outFile = this.outRoot.resolve(rel.toString());
            if (this.predicate.test(rel)) {
                Files.copy(inFile, outFile, new CopyOption[0]);
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

