/*
 * Decompiled with CFR 0.152.
 */
package net.covers1624.quack.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class PathTypeAdapter
extends TypeAdapter<Path> {
    @Override
    public void write(JsonWriter out, Path value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        if (value.getFileSystem().provider() != FileSystems.getDefault().provider()) {
            throw new IOException("Only default FileSystem can be serialized.");
        }
        out.value(value.toAbsolutePath().toString());
    }

    @Override
    public Path read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        return Paths.get(in.nextString(), new String[0]);
    }
}

