/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.nbt.path.parse;

import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import org.cyclops.cyclopscore.nbt.path.INbtPathExpression;
import org.cyclops.cyclopscore.nbt.path.NbtPathExpressionMatches;
import org.cyclops.cyclopscore.nbt.path.navigate.INbtPathNavigation;
import org.cyclops.cyclopscore.nbt.path.navigate.NbtPathNavigationAdapter;
import org.cyclops.cyclopscore.nbt.path.parse.INbtPathExpressionParseHandler;
import org.cyclops.cyclopscore.nbt.path.parse.NbtPathExpressionExecutionContext;

public class NbtPathExpressionParseHandlerChild
implements INbtPathExpressionParseHandler {
    private static final Pattern REGEX_CHILDNAME = Pattern.compile("^[a-zA-Z_0-9]+");

    @Override
    @Nullable
    public INbtPathExpressionParseHandler.HandleResult handlePrefixOf(String nbtPathExpression, int pos) {
        if (nbtPathExpression.charAt(pos) != '.' || nbtPathExpression.length() <= pos + 1) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        Matcher matcher = REGEX_CHILDNAME.matcher(nbtPathExpression).region(pos + 1, nbtPathExpression.length());
        if (!matcher.find()) {
            return INbtPathExpressionParseHandler.HandleResult.INVALID;
        }
        String childName = matcher.group();
        return new INbtPathExpressionParseHandler.HandleResult(new Expression(childName), 1 + childName.length());
    }

    public static class Expression
    implements INbtPathExpression {
        private final String childName;

        public Expression(String childName) {
            this.childName = childName;
        }

        String getChildName() {
            return this.childName;
        }

        @Override
        public NbtPathExpressionMatches matchContexts(Stream<NbtPathExpressionExecutionContext> executionContexts) {
            return new NbtPathExpressionMatches(executionContexts.map(executionContext -> {
                CompoundNBT tag;
                INBT childTag;
                INBT nbt = executionContext.getCurrentTag();
                if (nbt.func_74732_a() == 10 && (childTag = (tag = (CompoundNBT)nbt).func_74781_a(this.childName)) != null) {
                    return new NbtPathExpressionExecutionContext(childTag, (NbtPathExpressionExecutionContext)executionContext);
                }
                return null;
            }).filter(Objects::nonNull));
        }

        @Override
        public INbtPathNavigation asNavigation(@Nullable INbtPathNavigation child) {
            return new NbtPathNavigationAdapter(this.getChildName(), child);
        }
    }
}

