/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.cyclopscore.config.extendedconfig;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.fluid.Fluid;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import org.cyclops.cyclopscore.config.ConfigurableType;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.datastructure.Wrapper;
import org.cyclops.cyclopscore.init.ModBase;

public abstract class FluidConfig
extends ExtendedConfig<FluidConfig, ForgeFlowingFluid.Properties> {
    public FluidConfig(ModBase mod, String namedId, Function<FluidConfig, ForgeFlowingFluid.Properties> elementConstructor) {
        super(mod, namedId, elementConstructor);
    }

    protected static ForgeFlowingFluid.Properties getDefaultFluidProperties(ModBase mod, String texturePrefixPath, Consumer<FluidAttributes.Builder> fluidAttributesConsumer) {
        FluidAttributes.Builder fluidAttributes = FluidAttributes.builder((ResourceLocation)new ResourceLocation(mod.getModId(), texturePrefixPath + "_still"), (ResourceLocation)new ResourceLocation(mod.getModId(), texturePrefixPath + "_flow"));
        fluidAttributesConsumer.accept(fluidAttributes);
        final Wrapper<ForgeFlowingFluid.Properties> properties = new Wrapper<ForgeFlowingFluid.Properties>();
        final Wrapper source = new Wrapper();
        final Wrapper flowing = new Wrapper();
        properties.set(new ForgeFlowingFluid.Properties((Supplier)new Supplier<Fluid>(){

            @Override
            public Fluid get() {
                if (source.get() == null) {
                    source.set(new ForgeFlowingFluid.Source((ForgeFlowingFluid.Properties)properties.get()));
                }
                return (Fluid)source.get();
            }
        }, (Supplier)new Supplier<Fluid>(){

            @Override
            public Fluid get() {
                if (flowing.get() == null) {
                    flowing.set(new ForgeFlowingFluid.Flowing((ForgeFlowingFluid.Properties)properties.get()));
                }
                return (Fluid)flowing.get();
            }
        }, fluidAttributes));
        return (ForgeFlowingFluid.Properties)properties.get();
    }

    @Override
    public String getTranslationKey() {
        return "block." + this.getMod().getModId() + ".block_" + this.getNamedId();
    }

    @Override
    public ConfigurableType getConfigurableType() {
        return ConfigurableType.FLUID;
    }

    public ResourceLocation getIconLocationStill() {
        return new ResourceLocation(this.getMod().getModId(), "blocks/" + this.getNamedId() + "_still");
    }

    public ResourceLocation getIconLocationFlow() {
        return new ResourceLocation(this.getMod().getModId(), "blocks/" + this.getNamedId() + "_flow");
    }
}

